// screw drivers
// m.miller 04.26.23
#include "shapes3.inc"
#include "screwdrivers_materials.inc" 





// -----------------------------------------------------------------------------------------
//                      H A N D L E   P A R T S
//------------------------------------------------------------------------------------------

//--- handle void 
#declare handle_void_A = 
union{ 
    object{ Round_Box(<-1.5,0,-1>,<1.5,35,0>,0.5 , 0)}
}


//--- handle void with small grooves
#declare handle_void_B = 
union{ 
    object{ Round_Box(<-1.5,0,-1>,<1.5,35,0>,0.5 , 0)}
    cylinder {<0,0,0>,<0,35,0>,.2 translate <-1,0,0>}
    cylinder {<0,0,0>,<0,35,0>,.2 translate <-.5,0,0>}
    cylinder {<0,0,0>,<0,35,0>,.2 translate <0,0,0>}
    cylinder {<0,0,0>,<0,35,0>,.2 translate <.5,0,0>}
    cylinder {<0,0,0>,<0,35,0>,.2 translate <1,0,0>}
}

//--- handle void wide
#declare handle_void_C = 
union{ 
    object{ Round_Box(<-5,0,-1>,<5,35,0>,0.5 , 0)}
}


#declare profile_B =
lathe{ 
      cubic_spline
      46,
     <-0.000, 32.697>,
     <-0.000, 32.697>,
     <0.963, 32.674>,
     <2.574, 32.334>,
     <3.992, 31.404>,
     <4.366, 31.030>,
     <4.502, 30.610>,
     <4.502, 29.998>,
     <4.502, 25.975>,
     <4.502, 21.952>,
     <4.502, 17.969>,
     <4.502, 14.027>,
     <4.502, 9.671>,
     <4.502, 8.948>,
     <4.431, 8.538>,
     <4.054, 8.021>,
     <3.567, 6.921>,
     <3.408, 5.776>,
     <3.430, 5.435>,
     <3.785, 5.193>,
     <3.430, 4.904>,
     <3.798, 4.622>,
     <3.450, 4.247>,
     <3.805, 3.893>,
     <3.516, 3.578>,
     <3.535, 3.401>,
     <4.093, 3.132>,
     <4.408, 2.864>,
     <4.511, 2.628>,
     <4.511, 2.289>,
     <4.511, 1.494>,
     <4.454, 1.253>,
     <4.145, 1.038>,
     <3.769, 0.657>,
     <3.561, 0.166>,
     <3.362, 0.000>,
     <1.173, 0.000>,
     <0.749, 0.218>,
     <0.749, 0.501>,
     <0.749, 4.940>,
     <0.749, 11.605>,
     <0.749, 16.725>,
     <0.749, 17.056>,
     <0.494, 17.349>,
     <-0.000, 17.349>,
     <-0.000, 17.349>
      }




#declare profile_A =
lathe{ 
      cubic_spline
      50,
     <-0.000, 35.000>,
     <-0.000, 35.000>,
     <1.861, 34.477>,
     <3.021, 33.562>,
     <3.478, 32.305>,
     <3.282, 31.145>,
     <2.874, 30.590>,
     <2.852, 30.360>,
     <3.371, 29.939>,
     <3.989, 29.677>,
     <4.192, 29.381>,
     <4.192, 28.739>,
     <4.192, 26.035>,
     <4.192, 20.001>,
     <4.192, 16.964>,
     <4.192, 13.985>,
     <4.192, 10.986>,
     <4.055, 10.301>,
     <3.545, 9.835>,
     <3.058, 9.455>,
     <2.895, 9.073>,
     <3.069, 8.792>,
     <3.454, 8.674>,
     <3.652, 8.409>,
     <3.124, 6.812>,
     <2.975, 5.422>,
     <3.092, 3.952>,
     <2.961, 3.537>,
     <3.197, 3.287>,
     <3.033, 3.005>,
     <3.309, 2.802>,
     <3.178, 2.493>,
     <3.447, 2.303>,
     <3.316, 2.021>,
     <3.544, 1.854>,
     <3.479, 1.595>,
     <3.657, 1.413>,
     <3.657, 1.177>,
     <3.657, 0.326>,
     <3.508, 0.106>,
     <2.936, 0.106>,
     <1.480, 0.106>,
     <1.249, 0.351>,
     <1.249, 3.440>,
     <1.249, 11.220>,
     <1.249, 15.081>,
     <1.092, 15.414>,
     <0.641, 15.414>,
     <-0.000, 15.414>,
     <-0.000, 15.414>
      }
            
#declare profile_C =
lathe{ 
      cubic_spline
      59,
     <-0.000, 35.638>,
     <-0.000, 35.638>,
     <1.050, 35.563>,
     <2.448, 35.136>,
     <3.475, 34.424>,
     <3.801, 33.902>,
     <3.878, 33.484>,
     <3.878, 33.085>,
     <3.878, 30.261>,
     <3.878, 30.045>,
     <3.654, 29.802>,
     <3.878, 29.488>,
     <3.878, 29.287>,
     <3.878, 27.712>,
     <3.878, 27.502>,
     <3.688, 27.226>,
     <3.878, 26.973>,
     <3.878, 26.726>,
     <3.878, 25.336>,
     <3.878, 25.133>,
     <3.653, 24.892>,
     <3.878, 24.614>,
     <3.878, 24.335>,
     <3.878, 22.951>,
     <3.878, 22.780>,
     <3.664, 22.535>,
     <3.878, 22.250>,
     <3.878, 22.021>,
     <3.878, 20.777>,
     <3.878, 20.549>,
     <3.672, 20.305>,
     <3.878, 20.042>,
     <3.878, 19.786>,
     <3.878, 18.178>,
     <3.878, 17.896>,
     <3.550, 17.666>,
     <3.550, 17.437>,
     <3.550, 16.939>,
     <3.473, 16.704>,
     <2.970, 15.642>,
     <2.684, 14.322>,
     <2.752, 12.988>,
     <2.997, 12.022>,
     <2.752, 9.763>,
     <2.563, 8.562>,
     <2.538, 8.255>,
     <2.326, 8.065>,
     <2.520, 7.885>,
     <2.509, 7.571>,
     <2.261, 4.101>,
     <2.125, 1.225>,
     <2.128, 1.000>,
     <2.135, 0.628>,
     <2.337, 0.404>,
     <2.308, 0.168>,
     <2.079, 0.000>,
     <1.773, 0.000>,
     <-0.000, 0.000>,
     <-0.000, 0.000>
      }


// -----------------------------------------------------------------------------------------
//                     S H A F T
//------------------------------------------------------------------------------------------

#declare shaft_rad = 1.1;

#declare shaft_flat =
difference {
    sphere_sweep {
         cubic_spline
         8,
         <-0.000, 0.000, 0.000> , shaft_rad
         <-0.000, 0.000, 0.000> , shaft_rad
         <-0.000, -2.808, 0.000> , shaft_rad
         <-0.000, -27.175, 0.000> , shaft_rad
         <-0.000, -30.124, 0.000> , shaft_rad
         <-0.000, -35.500, 0.000> , shaft_rad * 1.5
         <-0.000, -43.000, 0.000> , shaft_rad
         <-0.000, -43.000, 0.000> , shaft_rad
         tolerance 0.000001
         }
     plane { <0,0,1>,0 rotate <-2.9,0,0> translate <0,-35.5,-.55>} 
     plane { <0,0,-1>,0 rotate <2.9,0,0> translate <0,-35.5,.55>} 
     plane { <1,0,0>,0 rotate <0,0,3> translate <-1.25,-35.5,0>} 
     plane { <-1,0,0>,0 rotate <0,0,-3> translate <1.25,-35.5,0>}
     plane { <0,1,0>,0 translate <0,-43,0>}   
}    
     

#declare shaft_phillips =
#declare voidcut = sphere {<0,0,0> 1 scale <.7,6,1> }
difference {
    union {
        cylinder {<0,0,0>,<0,-40,0>,shaft_rad} 
        cone {<0,-40,0>,shaft_rad,<0,-43,0>,shaft_rad/4 }
    }
    object { voidcut translate <0,-43,-1.2> }
    object { voidcut rotate <0,90,0> translate <1.2,-43,0> }
    object { voidcut translate <0,-43,1.2> }
    object { voidcut rotate <0,90,0> translate <-1.2,-43,0> }
} 



// -----------------------------------------------------------------------------------------
//               M A K E   S C R E W D R I V E R 
//               macro requires grip style, shaft style, & 3 materials 
//#declare standard =  1; 
//#declare phillips =  2;
//#declare grip_A   =  1;   //plastic craftsman
//#declare grip_B   =  2;   //plastic craftsman - with blue end
//#declare grip_C   =  3;   //plastic simple
//#declare grip_D   =  4;   //old wood style 
//------------------------------------------------------------------------------------------

#macro make_screwdriver (grip, shaft, M_handle, M_detail_A, M_detail_B) 
union {
    
    
    #switch (grip)
        #case (1)
            difference {
              object { profile_A material {M_handle} }
              object { handle_void_B translate <0,0,-3.75> rotate <0,0,0> material {M_detail_A}} 
              object { handle_void_A translate <0,0,-3.75> rotate <0,60,0> material {M_detail_B}} 
              object { handle_void_B translate <0,0,-3.75> rotate <0,120,0> material {M_detail_A}} 
              object { handle_void_A translate <0,0,-3.75> rotate <0,180,0> material {M_detail_B}} 
              object { handle_void_B translate <0,0,-3.75> rotate <0,240,0> material {M_detail_A}} 
              object { handle_void_A translate <0,0,-3.75> rotate <0,300,0> material {M_detail_B}}
              rotate <0,30,0> 
            } 
            cylinder {<0,0,0>,<0,17,0>,.5 material {M_steel_aged_2}} 
         #break
    
        #case (2)
            union {
                difference {
                    object { profile_A material {M_handle} }
                    object { handle_void_A translate <0,9,-3.75> rotate <0,0,0> material {M_detail_A}} 
                    object { handle_void_B translate <0,9,-3.75> rotate <0,60,0> material {M_handle}} 
                    object { handle_void_A translate <0,9,-3.75> rotate <0,120,0> material {M_detail_A}} 
                    object { handle_void_B translate <0,9,-3.75> rotate <0,180,0> material {M_handle}} 
                    object { handle_void_A translate <0,9,-3.75> rotate <0,240,0> material {M_detail_A}} 
                    object { handle_void_B translate <0,9,-3.75> rotate <0,300,0> material {M_handle}}
                    plane { <0,1,0>,0 translate <0,9,0>}
                } 
                difference {
                    object { profile_A material {M_detail_B} }
                    plane { <0,-1,0>,0 translate <0,9,0>}
                } 
            }
        #break
    
        #case (3)
        difference {
          object { profile_B material {M_handle} }
          object { handle_void_B translate <0,0,-3.75> rotate <0,0,0> material {M_detail_A}} 
          object { handle_void_A translate <0,0,-3.75> rotate <0,60,0> material {M_detail_B}} 
          object { handle_void_B translate <0,0,-3.75> rotate <0,120,0> material {M_detail_A}} 
          object { handle_void_A translate <0,0,-3.75> rotate <0,180,0> material {M_detail_B}} 
          object { handle_void_B translate <0,0,-3.75> rotate <0,240,0> material {M_detail_A}} 
          object { handle_void_A translate <0,0,-3.75> rotate <0,300,0> material {M_detail_B}}
          rotate <0,30,0> 
        } 
        #break

        #case (4)
            union {
                difference {
                  object { profile_C material {M_handle} }
                  object { handle_void_C translate <0,9,-3.55> rotate <0,0,0> material {M_handle}} 
                  object { handle_void_C translate <0,9,-3.55> rotate <0,90,0> material {M_handle}} 
                  object { handle_void_C translate <0,9,-3.55> rotate <0,180,0> material {M_handle}} 
                  object { handle_void_C translate <0,9,-3.55> rotate <0,270,0> material {M_handle}} 
                  plane { <0,1,0>,0 translate<0,8.1,0> }
                }  
                
                difference {
                    object { profile_C material {M_detail_A} }
                    plane { <0,-1,0>,0 translate<0,8.1,0> }
                    #declare voidcut = sphere {<0,0,0>, .15 scale <1,1.5,1> translate <0,6.5,-2.4> material {M_black_dull}} 
                    #for (i, 0, 23)
                      object {voidcut rotate <0,i*15,0>}
                    #end
                    }
                scale <1.3,1.3,1.3>     
            } 
        #break


    #end
    

    #switch (shaft)
        #case (1)
            object {shaft_flat material {M_steel_aged_2 scale <2,4,2>} }
        #break
        #case (2)
             object {shaft_phillips material {M_steel_aged_2 scale <2,4,2>} }
        #break   
    #end    
    
} 
#end


