// fallout vault boy
// m.miller 04.25.23

#version 3.8; 
global_settings {    
    max_trace_level 7
    ambient_light <.013,.01,.01> * 5                  
}                        

background { rgb <0.12, 0.11, 0.1> * 1 } 

#declare light_left =
light_source {
    <0,0,0> 
    #declare light_color = color red .05 green .05 blue .05 ;                      
    light_color * 30                  
    area_light
    <250, 0, 0> <0, 0, 250>         
    16, 16                          
    adaptive 0                    
    jitter                        
    circular                      
    orient                     
    fade_distance 400
    fade_power 2     
    translate <-100,300,-250>
}   
light_left

#declare light_back =
light_source {
    <0,0,0> 
    #declare light_color = color red .05 green .065 blue .07 ;                      
    light_color * 5                 
    area_light
    <250, 0, 0> <0, 0, 250>         
    16, 16                          
    adaptive 0                    
    jitter                        
    circular                      
    orient                     
    fade_distance 400
    fade_power 2     
    translate <200,200,100>
}   
light_back


   

// -----------------------------------------------------------------------------------------
//                      S K Y
//------------------------------------------------------------------------------------------ 
background { rgb <0.12, 0.11, 0.1> * 10 } 
#include "sky.inc"
object { bg_sphere (<2000,2000,2000>, <0,100,0>, 250) scale <-1,1,1> }



// -----------------------------------------------------------------------------------------
//                      V A U L T   B O Y 
//------------------------------------------------------------------------------------------ 
#include "vault_boy.inc"
#include "vault_boy_thin.inc"

#declare vault_boy_cutaway =
object {
    union {
        difference {
            object { vault_boy} 
            object { vault_boy_thin }
            plane {<1,0,0>, 0 translate <1,0,0> material {M_metal_gold}}
        } 
        difference {
            object { vault_boy_thin }
            plane {<1,0,0>, 0 translate <3,0,0> material {M_red_dark_gloss}}
        } 
    }
}

object { vault_boy              rotate <0,-50,0>    translate <-60,0,0>   }
object { vault_boy              rotate <0,10,0>      translate <0,0,0>     }
object { vault_boy_thin         rotate <0,-20,0>     translate <60,0,0>    }
object { vault_boy_cutaway      rotate <0,-20,0>    translate <105,0,0>    }





// -----------------------------------------------------------------------------------------
//                      S T A G E 
//------------------------------------------------------------------------------------------  
#declare stage = 
union {
    box {<-.5,0,-1>,<.5,-.01,1> }   
    difference {
        box {<-.5,0,0>,<.5,1,1> } 
        cylinder { <-.65,0,0>,<.65,0,0>, .5 translate <0,.5,0>}
    }                              
    material {M_enviroment_sunny scale <1,1.1,1> translate <0,-.1,0>}
    scale <1000,170,250>  translate <0,0,100> rotate <0,0,0>
    no_shadow
}
stage




// -----------------------------------------------------------------------------------------
//                      C A M E R A 
//------------------------------------------------------------------------------------------ 
#declare cam_front =
    camera {
        up <0, 1, 0>  
        angle 40    
        location <50,70,-350> 
        look_at <20,50,0>
    } 

#declare cam_elev =
    camera {
        up <0, 1, 0>  
        angle 1.3    
        location <100,200,-10000> 
        look_at <0,50,0>
    } 
    
#declare cam_side =
    camera {
        up <0, 1, 0>  
        angle 1.3   
        location <-10000,200,> 
        look_at <0,50,0>
    } 

#declare cam_iso =
    camera {
        up <0, 1, 0>  
        angle 25    
        location <-300,300,-300> 
        look_at <0,40,0>
    } 
    

camera {cam_front}
//camera {cam_iso} 
//camera {cam_elev} 
//camera {cam_side}




