// Fallout Vault Boy
// m.miller 4.25.


#include "shapes3.inc"
// -----------------------------------------------------------------------------------------
//                       M A T E R I A L S 
//------------------------------------------------------------------------------------------ 

#declare C_clear  =         rgbt 1 ;
#declare C_white =          color rgb<1,1,1>  ;
#declare C_black =          color rgb<0,0,0>  ;
#declare C_gray_dark =      color rgb<0.07,0.07,0.07>  ;
#declare C_gray_black =     color rgb<0.03,0.03,0.03>  ;
#declare C_gold =           color red 0.82 green 0.6 blue 0.196078;
#declare C_yellow_dull  =   color rgb<1,.9,.10>  ;
#declare C_blue =           color rgb<0,.5,.9>  ;
#declare C_light_blue =     color red 0.6 green 0.8 blue 1; 
#declare C_horizon_blue =   color red .82 green 1 blue .98;
#declare C_gray20 =         color red 0.2 green 0.2 blue 0.2; 
#declare C_red_dark =       color rgb<.5,0,0>  ;

#declare C_map_enviroment_sunny =
color_map {
    [ 0.0     C_gray20 ]  
    [ 0.1     C_gray20 ]
    [ 0.3     C_horizon_blue ]
    [ 0.6     C_light_blue ]
    [ 1.0     C_blue ]
    }
    
    
#declare F_dull =
finish {
    ambient .2
    diffuse .7   
    phong .1
    phong_size 10  
}

#declare F_flat =
finish {
    ambient 0
    diffuse 1   
    phong .1
    phong_size 20  
} 

#declare F_gloss =
finish {
    ambient .2
    diffuse 1   
    phong 1
    phong_size 100  
    reflection {.01, .72 fresnel}
}

#declare imgDiffuse = "vault_boy_diffuse.png"   
#declare imgBump = "vault_boy_bump.png" 
#declare M_vault_boy_front =
material {
    texture {
       pigment { 
            image_map {
                png imgDiffuse     
                map_type 0
                interpolate 4 
                }
      }
     normal  {
        bump_map {
            png imgBump 
            map_type 0
            interpolate 4 
        } 
        bump_size .5
    }
    finish {F_dull}
    }
    scale <100,100,1> 
    translate <-50,-11,0>  
}

#declare F_metal_polished  =
finish {
    reflection {0, 1 fresnel on }
    conserve_energy 
    brilliance 5
    ambient 0
    diffuse .5 
    phong 5    
    phong_size 40
    metallic
    specular .4
    roughness 1/20
    reflection .5   
}

#declare M_red_dark_gloss =
material {
    texture {
       pigment { C_red_dark*.75 }
       finish { F_gloss }
   }
}

#declare M_black_dull =
material {
    texture {
       pigment { C_black }
       finish { F_dull }
   }
}

#declare M_gray_dark_dull =
material {
    texture {
       pigment { C_gray_dark }
       finish { F_dull }
   }
}

#declare M_gold_gloss =
material {
    texture {
       pigment { C_gold }
       finish { F_gloss }
   }
}


#declare M_yellow_dull =
material {
    texture {
       pigment { C_yellow_dull }
       finish { F_dull }
   }
}

#declare M_white_dull =
material {
    texture {
       pigment { C_white }
       finish { F_dull }
   }
}

   
#declare M_enviroment_sunny =
material {
    texture {
        pigment {
            gradient y
            color_map{C_map_enviroment_sunny }
        }
    finish {F_dull}    
    }
}   


#declare T_gold = texture{ pigment{ rgb C_gold }} 
#declare M_metal_gold = material{ texture{ T_gold   finish{F_metal_polished}} }

// -----------------------------------------------------------------------------------------
//                      B O D Y
//------------------------------------------------------------------------------------------
#declare body =
#declare th = .1 ;
#declare sf = 2.0 ;
#declare nStrenth = -5 ;
#declare nSize = 1 ; 
#declare left_hand_pos = <-10, 32, -.5> ;
#declare left_wrist_pos = <-10.55, 33, 1> ;
#declare right_hand_pos =  <12.5, 33, 0> ;
#declare right_wrist_pos = <13.75, 34, 1> ;

blob {
     threshold th
     sphere{ <0,0,0>, 1, 1 scale <10,10,7> rotate <20,0,0> translate <2, 47.5, 1> } //--- chest 
     sphere{ <0,0,0>, 1, 1 scale <9,10,7> rotate <20,0,0> translate <1, 41, -.5> } //--- chest 
      

     sphere{ <0,0,0>, 1, 1 scale <4,5,5>    translate <1.355, 53, 1.814> }          //---neck
     sphere{ <0,0,0>, 1, 1 scale <5,4,4>    translate <-5.374, 49, 1> }             //--- left shoulder
     sphere{ <0,0,0>, 1, 1 scale <5,4,4>    translate <7.4, 50, 1> }                //--- right shoulder

     cylinder { <2.527, 29.155, -1>, <2, 45.769, 1.814>, 9, 1 scale <1,1,.7>}        //--- torso to hip
     sphere{ <0,0,0>, 1, 1 scale <9,13,9.5>     translate <1, 32, -.5> }             //--- belly
     
     cylinder { 
        <-5.374, 50, 1.814>,                //--- left upper arm
        <-14.964, 40.773, 3.4>,             //--- left elbow
        3.5, 1 }            
     cylinder { 
        <-14.964, 40.773, 2.8>,             //--- left elbow
        left_wrist_pos,                     //--- left wrist
        3, 1 }       
           
 
     sphere{ <0,0,0>, 1, 1 scale <5,12,6> translate <-3, 29, -2> }                  //--- left upper leg joint
     cylinder {                  
        <-4, 24, -2>,                       //--- left upper leg
        <-5.5, 15, -2.8>,                   //--- left knee
         3.5, 1 scale <1,1,1.2>
         }     
     cylinder {                  
        <-5.75, 14, -3>,                    //--- left knee
        <-7, 5, -4>,                        //--- left ankle
         3.2, 1 scale <1,1,1.2>
         }
 
     cylinder { 
        <7.7, 51, 1.814>,                   //--- right upper arm 
        <16.042, 44.614, 1.814>,            //--- right elbow
        3.5, 1 }                 
     cylinder { 
        <17.042, 44.614, 1.814>,            //--- right elbow
        right_wrist_pos,                    //--- right wrist
        3, 1 }             

     cylinder { 
        <6.154, 26, -.1>,                   //--- right upper leg 
        <5.4, 15, 2.4> ,                    //--- right knee 
         3.5, 1  scale <1,1,1.3>}          
     cylinder { 
        <5.238, 14, 3> ,                    //--- right knee 
        <5, 5, 4.5>,                        //--- right ankle
         3.2, 1  scale <1,1,1.2>} 

      sphere{ <0,0,0>, 1, -1 scale <30,3,30> translate <0,1,0> }                //--- negative blob at ankle
}



// -----------------------------------------------------------------------------------------
//                      F O O T
//------------------------------------------------------------------------------------------
#declare foot =
#declare th = 0.5 ;
#declare sf = 2.0 ;

difference { 
    #declare nSize = 1 ;
    blob {
         threshold th
         sphere{ <0,0,0>, 1, 1 scale <3.339, 3.490, 2.194> * sf  translate <1.034, 0.967, -0.031> }
         sphere{ <0,0,0>, 1, 1 scale <3.563, 2.096, 1.547> * sf  translate <4.975, 0.256, -0.031> }
         sphere{ <0,0,0>, 1, 1 scale <1, 2.008, 1> * sf  translate <-0.012, 4.542, -0.031> }
         sphere{ <0,0,0>, 1, -1 scale <20,2,20>  translate <0, -2, 0> }
         translate <0,.5,0>
         }
     plane {<0,1,0>, 0 }
     scale <1,.8,1> 
}     

// -----------------------------------------------------------------------------------------
//                      L E F T   H A N D
//------------------------------------------------------------------------------------------                                                                                           
#declare l_hand =
#declare th = 0.5 ;
#declare sf = 2.0 ;
#declare nStrenth = -5 ;
#declare nSize = 1 ;
blob {
     threshold th
     sphere{ <0,0,0>, 1, 1 scale <0.485, 0.495, 0.345> * sf  translate <2.131, -0.388, -0.993> }
     sphere{ <0,0,0>, 1, 1 scale <0.532, 0.543, 0.411> * sf  translate <2.736, -0.645, -1.332> }
     sphere{ <0,0,0>, 1, 1 scale <0.530, 0.482, 0.397> * sf  translate <3.448, -0.948, -1.609> }
     sphere{ <0,0,0>, 1, 1 scale <0.501, 0.868, 0.429> * sf  translate <3.535, 1.450, -0.000> }
     sphere{ <0,0,0>, 1, 1 scale <0.604, 0.564, 0.429> * sf  translate <3.074, 0.749, -0.000> }
     sphere{ <0,0,0>, 1, 1 scale <1.148, 1.222, 0.816> * sf  translate <1.067, -1.741, -0.192> }
     sphere{ <0,0,0>, 1, 1 scale <1.450, 1.520, 1.031> * sf  translate <1.080, -0.905, -0.136> }
     sphere{ <0,0,0>, 1, 1 scale <0.604, 0.531, 0.429> * sf  translate <2.439, 0.372, -0.000> }
     sphere{ <0,0,0>, 1, 1 scale <0.530, 0.482, 0.397> * sf  translate <3.228, -3.114, -1.595> }
     sphere{ <0,0,0>, 1, 1 scale <0.532, 0.543, 0.411> * sf  translate <2.529, -2.414, -1.278> }
     sphere{ <0,0,0>, 1, 1 scale <0.485, 0.495, 0.345> * sf  translate <2.074, -1.883, -0.993> }
     sphere{ <0,0,0>, 1, 1 scale <0.485, 0.495, 0.345> * sf  translate <1.483, -2.935, -0.862> }
     sphere{ <0,0,0>, 1, 1 scale <0.532, 0.543, 0.411> * sf  translate <1.938, -3.467, -1.147> }
     sphere{ <0,0,0>, 1, 1 scale <0.530, 0.482, 0.397> * sf  translate <2.637, -4.167, -1.465> }
     sphere{ <0,0,0>, 1, 1 scale <1.148, 1.222, 0.816> * sf  translate <0.479, -0.389, 0.473> }
     }
     


// -----------------------------------------------------------------------------------------
//                      R I G H T   H A N D
//------------------------------------------------------------------------------------------   
#declare r_hand =
#declare th = 0.5 ;
#declare sf = 2.0 ;
#declare nStrenth = -5 ;
#declare nSize = 1 ;
blob {
     threshold th
     sphere{ <0,0,0>, 1, 1 scale <0.485, 0.495, 0.345> * sf  translate <-2.131, -0.388, -0.993> }
     sphere{ <0,0,0>, 1, 1 scale <0.532, 0.543, 0.411> * sf  translate <-2.736, -0.645, -1.332> }
     sphere{ <0,0,0>, 1, 1 scale <0.530, 0.482, 0.397> * sf  translate <-3.448, -0.948, -1.609> }
     sphere{ <0,0,0>, 1, 1 scale <0.501, 0.868, 0.429> * sf  translate <-3.535, 1.450, -0.000> }
     sphere{ <0,0,0>, 1, 1 scale <0.604, 0.564, 0.429> * sf  translate <-3.074, 0.749, -0.000> }
     sphere{ <0,0,0>, 1, 1 scale <1.148, 1.222, 0.816> * sf  translate <-1.067, -1.741, -0.192> }
     sphere{ <0,0,0>, 1, 1 scale <1.450, 1.520, 1.031> * sf  translate <-1.080, -0.905, -0.136> }
     sphere{ <0,0,0>, 1, 1 scale <0.604, 0.531, 0.429> * sf  translate <-2.439, 0.372, -0.000> }
     sphere{ <0,0,0>, 1, 1 scale <0.530, 0.482, 0.397> * sf  translate <-3.228, -3.114, -1.595> }
     sphere{ <0,0,0>, 1, 1 scale <0.532, 0.543, 0.411> * sf  translate <-2.529, -2.414, -1.278> }
     sphere{ <0,0,0>, 1, 1 scale <0.485, 0.495, 0.345> * sf  translate <-2.074, -1.883, -0.993> }
     sphere{ <0,0,0>, 1, 1 scale <0.485, 0.495, 0.345> * sf  translate <-1.483, -2.935, -0.862> }
     sphere{ <0,0,0>, 1, 1 scale <0.532, 0.543, 0.411> * sf  translate <-1.938, -3.467, -1.147> }
     sphere{ <0,0,0>, 1, 1 scale <0.530, 0.482, 0.397> * sf  translate <-2.637, -4.167, -1.465> }
     sphere{ <0,0,0>, 1, 1 scale <1.148, 1.222, 0.816> * sf  translate <-0.479, -0.389, 0.473> }
     }
     
                                                                                                 
// -----------------------------------------------------------------------------------------
//                      H E A D
//------------------------------------------------------------------------------------------
#declare head =
#declare th = 0.5 ;
#declare sf = 2.0 ;
#declare nStrenth = -5 ;
#declare nSize = 1 ;
union {
    blob {
         threshold th 
         //---scull
         sphere{ <0,0,0>, 1, 1 scale <8.407, 9.703, 7.173> * sf  translate <25.000, 62.786, -4.421> }
         sphere{ <0,0,0>, 1, 1 scale <9.0, 10.385, 10.754> * sf  translate <25.000, 72.968, 0.550> }
         sphere{ <0,0,0>, 1, 1 scale <7.037, 9.736, 7.796> * sf  translate <25.000, 67.632, 6.097> }
    
         sphere{ <0,0,0>, 1, -1 scale <7,7,7>    translate <25, 53, 1.814> }          //--- negative neck bobble point
    
         //---nose
         sphere{ <0,0,0>, 1, 1 scale <.75, 1.5, 2> * sf  translate <25.000, 64.96, -11> } 
         sphere{ <0,0,0>, 1, 1 scale <1.5, .7, 2> * sf  translate <25.000, 63.913, -11> }
         sphere{ <0,0,0>, 1, 1 scale <.75, .6, 1> * sf  translate <25.000, 63.913, -13> }  
         sphere{ <0,0,0>, 1, -1.5 scale <3, 2, 1> * sf  rotate <10,0,0> translate <25.000, 66, -16> }  //neg dip
         //---chin
         sphere{ <0,0,0>, 1, 1 scale <2.7, 2.088, 2.108> * sf  translate <25.000, 58, -7.8> }
         //--- ears
         sphere{ <0,0,0>, 1, 1 scale <1.101, 2.937, 2.352> * sf  rotate <0,0,-10> translate <36.000, 64.768, 6.097> }
         sphere{ <0,0,0>, 1, 1 scale <1.101, 2.937, 2.352> * sf  rotate <0,0,10> translate <14.000, 64.768, 6.097> }
         //--- ear holes
         sphere{ <0,0,0>, 1, -1.2 scale <1.475, 3.146, 3.5> translate <37.000, 65.540, 4.5> }
         sphere{ <0,0,0>, 1, -1.2 scale <1.475, 3.146, 3.5> translate <13.000, 65.540, 4.5> }
         material {M_vault_boy_front} 
         } 
         sphere{ <0,0,0>, 1 scale <2,4,2>    translate <25, 53, 1.814> material {M_vault_boy_front} }          //--- neck bobble point
         //--- ear plugs
         union {
             sphere{ <0,0,0>, 1  scale <1.4, 1.8, 2> translate <35.5000, 64.540, 4.5> }
             sphere{ <0,0,0>, 1  scale <1.4, 1.8, 2> translate <14.5000, 64.540, 4.5> } 
             material {M_vault_boy_front}
         }
}


// -----------------------------------------------------------------------------------------
//                      H A I R
//------------------------------------------------------------------------------------------
#declare hair = 
blob {
    #declare th = 0.5 ;
    #declare nStrenth = -5 ;
    #declare nSize = 1 ;
    threshold th
    #declare sf = 1.8 ;
    sphere{ <0,0,0>, 1, 1 scale <8.152, 9.206, 8.953> * sf  translate <0.224, 70.235, 5.959> }
    sphere{ <0,0,0>, 1, 1 scale <8.023, 7.255, 8.563> * sf  translate <0.224, 77.643, 4.234> }
    sphere{ <0,0,0>, 1, 1 scale <8.508, 10.291, 7.593> * sf  translate <0.224, 68.702, 6.517> }
    sphere{ <0,0,0>, 1, 1 scale <8.612, 4.966, 10.309> * sf  translate <0.224, 82.149, -2.459> }
    sphere{ <0,0,0>, 1, 1 scale <1.936, 3.587, 4.456> * sf  translate <10.613, 75.647, 2.472> }
    sphere{ <0,0,0>, 1, 1 scale <1.829, 4.369, 4.980> * sf  translate <-10.389, 74.507, 0.887> }
    material {M_yellow_dull}
    }


#declare hair_curl_A =
sphere_sweep {
     cubic_spline
     12,
     <-13.250, 84.316, -7.619> , 0.526
     <-13.250, 84.316, -7.619> , 0.526
     <-13.109, 81.424, -8.296> , 1.278
     <-10.096, 79.098, -9.481> , 2.389
     <-6.690, 81.353, -10.260> , 2.051
     <-3.371, 83.317, -11.818> , 2.051
     <-0.323, 81.794, -11.818> , 2.051
     <2.046, 83.825, -11.818> , 2.051
     <5.500, 85.315, -10.531> , 2.051
     <7.397, 82.302, -10.057> , 2.051
     <6.5, 82.302, -2> , 3.051
     <6.5, 82.302, -2> , 3.051
     tolerance 0.000001   
     material {M_yellow_dull}
     }
     
#declare hair_curl_B =
sphere_sweep {
     cubic_spline
     8,
     <-6.690, 81.353, -10.260> , 3
     <-3.371, 83.317, -11.818> , 2.5
     <-0.323, 81.794, -11.818> , 2.5
     <2.046, 83.825, -11.818> , 2.5
     <5.500, 85.315, -10.531> , 2.5
     <7.397, 82.302, -10.057> , 2.5
     <7, 82.302, -3> , 3
     <7, 82.302, -3> , 3
     tolerance 0.000001   
     material {M_yellow_dull}
     }
     
#declare hair_curl_C =
sphere_sweep {
     cubic_spline
     8,
     <10.140, 79.017, -2.841> , 1.434
     <10.140, 79.017, -2.841> , 1.434
     <11.636, 79.784, -0.894> , 1.863
     <12.648, 78.498, 1.842> , 2.4
     <12.305, 75.518, 2.870> , 1.863
     <11.636, 72.955, 2.141> , 1.732
     <10.930, 70.696, 1.227> , 1.1
     <10.930, 70.696, 1.227> , 0.5
     tolerance 0.000001 
     material {M_yellow_dull}
     }
   
#declare hair_curl_D =
sphere_sweep {
     cubic_spline
     12,
     <8.567, 83.723, -6.297> , 2.367
     <8.567, 83.723, -6.297> , 2.367
     <5.225, 86.572, -6.297> , 2.367
     <0.170, 87.037, -6.297> , 2.367
     <-5.235, 86.087, -6.297> , 2.367
     <-9.381, 83.045, -6.297> , 2.178
     <-10.026, 78.972, -4.785> , 2.178
     <-10.660, 76.242, -2.786> , 1.763
     <-10.611, 75.073, -0.169> , 1.763
     <-9, 73.741, 2.687> , 1.3
     <-9, 73.577, 5.809> , 1
     <-8, 73.526, 8.686> , .75
     tolerance 0.000001   
     material {M_yellow_dull}
     }
       
// -----------------------------------------------------------------------------------------
//                      V A U L T   B O Y
//------------------------------------------------------------------------------------------


#declare letterCount = 9 ;
#declare letterArray = array[letterCount] ;
#declare letterArray[0] = "V"  ;
#declare letterArray[1] = "A"  ;
#declare letterArray[2] = "U"  ;
#declare letterArray[3] = "L"  ;
#declare letterArray[4] = "T"  ;
#declare letterArray[5] = "-" ;
#declare letterArray[6] = "T"  ;
#declare letterArray[7] = "E"  ;
#declare letterArray[8] = "C"  ;

    
#declare kurn = -11;
#declare letter_offset = -20;
#declare sz = <5,6.5,2> ;

declare vault_boy_label =
intersection {
    union {
        #for (i, 0, letterCount-1)
            #declare c = i*kurn;
            text { 
                ttf "arial.ttf", 
                letterArray[i], 
                1 , 
                2  
                scale sz  
                translate <0,2,letter_offset> 
                rotate <0,c,0> 
                material {M_black_dull} 
              }
        #end 
        rotate <0,-kurn*(letterCount/2),0>
    } 
    cone { <0,0,0>,19.1,<0,8,0>,18.1  material {M_white_dull}}
    
} 

#declare vault_boy = 
union{  
    union {
        object { body material {M_vault_boy_front}  }
        union {
            object {head translate <-24,2,0> scale <1,1,1>}  
            object {hair scale <-1,1,1> translate <1,0,0>} 
            object {hair_curl_A  translate <0,-2,0>}
            object {hair_curl_B  scale <.9,1,1> translate <0,0,3>}
            object {hair_curl_C  translate <0,-1,-2>} 
            object {hair_curl_C  translate <0,1,2>}  
            object {hair_curl_D  translate <1,-3,1>}
            scale <.95,1,.9> 
            translate <0,1,0>
        }
        object {foot rotate <0,110,>    translate <-7, 0, -4.3> material {M_black_dull}}    
        object {foot rotate <0,30,>     translate <4.9, 0, 5.5> material {M_black_dull}} 
        object {r_hand scale <1,1,1>    rotate <0,-20,-10>      translate right_hand_pos    material {M_vault_boy_front translate <45,35,0>}}  
        object {l_hand scale <1,1,1>    rotate <0,20,10>        translate left_hand_pos     material {M_vault_boy_front translate <45,35,0>}} 
        translate <0,9,1>
    }

    union {
        cone { <0,0,0>,19,<0,8,0>,18  material {M_black_dull}} 
        sphere {<0,0,0> 1 scale <18,2,18> translate <0,8,0> material {M_gray_dark_dull}}
    }
    vault_boy_label
} 








// -----------------------------------------------------------------------------------------
//                     U N D E R L A Y S
//------------------------------------------------------------------------------------------

/*

#declare imgDiffuse = "vault_boy_underlay_front.jpg" 
#declare M_vault_boy_front =
material {
    texture {
       pigment { 
            image_map {
                jpeg imgDiffuse     
                map_type 0
                interpolate 4 
                }
      }
    finish {F_flat emission .2}
    }
    scale <100,100,1> 
    translate <-50,0,0>  
}


  
#declare imgDiffuse = "vault_boy_underlay_side.jpg" 
#declare M_vault_boy_side = 
material {
    texture {
       pigment { 
            image_map {
                jpeg imgDiffuse     
                map_type 0
                interpolate 4 
                }
      }
    finish {F_flat emission .2}
    }
    scale <100,100,1> 
    translate <-50,0,0>  
}

  
#declare image_front =
#declare rad = .01 ;
union {
    union { 
        #declare sc = <50.000, 50.000, .1> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 50, 0.000> }
        material {M_vault_boy_front} 
        translate <0,-11,0>
        }
    sphere {<0,0,0>,2}
}

 
#declare image_side =
#declare rad = .01 ;
union {
    union { 
        #declare sc = <50.000, 50.000, .1> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 50, 0.000> }
        material {M_vault_boy_side} 
        translate <0,-11,0>
        }
    rotate <0,90,0>    
}

*/



//object { image_front }
//object { image_side translate <0,0,-5> }
