// -----------------------------------------------------------------------------------------
//                      S C R E W S  &   B O L T   H E A D
//------------------------------------------------------------------------------------------
//m.miller 4.23.23
#include "shapes3.inc"





// -----------------------------------------------------------------------------------------
//                      M A T E R I A L S
//------------------------------------------------------------------------------------------

#declare C_rust_red =       color rgb  <0.6, 0.3, 0.25>      ;
#declare C_rust_red_film =  color rgbt <0.6, 0.3, 0.25,.5>   ;
#declare C_rust_gray =      color rgb  <0.80, 0.80, 0.85>    ;
#declare C_rust_gray_dark = color rgb  <0.70, 0.70, 0.80>    ; 
#declare C_clear  =         rgbt 1                           ; 
#declare C_white =          color rgb<1,1,1>  ;
#declare C_gray50 =         color red 0.5 green 0.5 blue 0.5;  
#declare C_gray70 =         color red 0.7 green 0.7 blue 0.7; 

//--- steel old
#declare sz = <.1,2,.1> ;   
#declare turb = 1.1; 
#declare bump = .03; 

#declare T_metal_steel_old =
texture { 
    pigment { 
        spotted 
        color_map {
            [0.0        C_rust_gray]
            [0.1        C_rust_gray_dark]
            [0.3        C_rust_gray_dark * .9] 
            [0.55       C_rust_gray * 1.5]
            [0.85       C_rust_gray * 1.5]
            [0.9        C_rust_gray_dark]
            [1.000      C_rust_gray]
        }
        turbulence turb
        scale sz
    } 

    finish {  
        reflection {.001, .2 fresnel on } 
        conserve_energy 
        brilliance 5
        ambient 0
        brilliance 5
        diffuse 1 
        phong 1.5    
        phong_size 20
        metallic
        specular 3 
        roughness .01
        reflection .2 
    }
    
    normal {
         crackle 
         turbulence turb 
         bump_size bump
         scale sz
     }   
 }
 


//--- steel old spotted 
#declare sz = <1,1,1>*.5 ;   
#declare turb = 1.1; 
#declare bump = .2; 

#declare T_metal_steel_spotted =
texture { 
    pigment { 
        spotted 
        color_map {
            [0.0        C_clear              ]
            [0.2        C_rust_red           ]
            [0.3        C_rust_red_film * .7 ] 
            [0.4        C_clear              ]
            [0.85       C_clear              ]
            [0.9        C_rust_red_film * .6 ]
            [1.000      C_clear              ]
        } 
        turbulence turb
        scale sz
        } 

    finish {  
        reflection {.001, .2 fresnel on } 
        conserve_energy 
        brilliance 5
        ambient 0
        brilliance 5
        diffuse 1 
        phong 1.5    
        phong_size 20
        metallic
        specular 3 
        roughness .01
        reflection .2 
    }
    
    normal {
        pigment_pattern{ 
            spotted 
            color_map {
                [0.0        C_white  ]
                [0.2        C_gray50 ]
                [0.3        C_gray70 ] 
                [0.4        C_white  ]
                [0.85       C_white  ]
                [0.9        C_gray50 ]
                [1.000      C_white  ]
            } 
            turbulence turb
            scale sz
         }  
         bump_size bump
     }   
 }




//--- steel aged
#declare M_steel_aged =
material {
   texture { T_metal_steel_old }
   texture { T_metal_steel_spotted scale <1.5,2.5,1.5>}
}




// macro for simple coil shape using a pre-plotted circle 
// 24 points normalized from -1 to 1 
#macro coil (radA,radB,turns,h,objType)
  
    #declare sPoint = sphere {<0,0,0>, radB }                              
    #declare pointDataCount = 24 ;
    #declare pointArray = array[pointDataCount] ;
    #declare pointArray[0] = <0.000, 0.000, 1.000>  ;
    #declare pointArray[1] = <-0.258, 0.000, 0.965>  ;
    #declare pointArray[2] = <-0.500, 0.000, 0.866>  ;
    #declare pointArray[3] = <-0.707, 0.000, 0.707>  ;
    #declare pointArray[4] = <-0.866, 0.000, 0.500>  ;
    #declare pointArray[5] = <-0.965, 0.000, 0.258>  ;
    #declare pointArray[6] = <-1.000, 0.000, 0.000>  ;
    #declare pointArray[7] = <-0.965, 0.000, -0.258>  ;
    #declare pointArray[8] = <-0.866, 0.000, -0.500>  ;
    #declare pointArray[9] = <-0.707, 0.000, -0.707>  ;
    #declare pointArray[10] = <-0.500, 0.000, -0.866>  ;
    #declare pointArray[11] = <-0.258, 0.000, -0.965>  ;
    #declare pointArray[12] = <0.000, 0.000, -1.000>  ;
    #declare pointArray[13] = <0.258, 0.000, -0.965>  ;
    #declare pointArray[14] = <0.500, 0.000, -0.866>  ;
    #declare pointArray[15] = <0.707, 0.000, -0.707>  ;
    #declare pointArray[16] = <0.866, 0.000, -0.500>  ;
    #declare pointArray[17] = <0.965, 0.000, -0.258>  ;
    #declare pointArray[18] = <0.999, 0.000, 0.000>  ;
    #declare pointArray[19] = <0.965, 0.000, 0.258>  ;
    #declare pointArray[20] = <0.866, 0.000, 0.500>  ;
    #declare pointArray[21] = <0.707, 0.000, 0.707>  ;
    #declare pointArray[22] = <0.500, 0.000, 0.866>  ;
    #declare pointArray[23] = <0.258, 0.000, 0.965>  ; 
    
   
    #if (objType="plotCoil")
        #declare c=pointDataCount;
        #declare yOffset = h/(pointDataCount*turns);
        #declare cnt=0;
        sphere_sweep {
        cubic_spline
        c * turns,
        #declare j=0; 
        #while (j<turns)
            #declare i=0;
            #while (i<c) 
                #declare cnt=cnt+1;
                #declare pos = pointArray[i];
                #declare nY = (cnt*yOffset);
                #declare nPos = <pos.x,pos.y + nY,pos.z>;
                nPos * radA , radB
                #declare i=i+1;
            #end 
            #declare j=j+1;
        #end
        tolerance 0.000001
        }
    #end 
    
    #if (objType="plotPoints")
        #declare c=pointDataCount;
        #declare yOffset = h/(pointDataCount*turns);
        #declare cnt=0;
        #declare j=0; 
        #while (j<turns)
            #declare i=0;
            #while (i<c) 
                #declare cnt=cnt+1;
                #declare pos = pointArray[i];
                #declare nY = (cnt*yOffset);
                #declare nPos = <pos.x,pos.y + nY,pos.z>;
                object { sPoint translate nPos * radA }
                #declare i=i+1;
            #end 
            #declare j=j+1;
        #end
    #end 
#end


#declare phillips_void =
#declare rad = .25 ;
difference { 
    #declare sc = <1.000, 1.000, 1.000> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 1.000, 0.000> } 
    union {
        #declare sc = <0.800, 2.000, 0.800> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <1.000, 1.000, 1.000> } 
        #declare sc = <0.800, 2.000, 0.800> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <1.000, 1.000, -1.000> } 
        #declare sc = <0.800, 2.000, 0.800> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-1.000, 1.000, -1.000> } 
        #declare sc = <0.800, 2.000, 0.800> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-1.000, 1.000, 1.000> } 
        }
    scale <.5,1,.5>     
    }
      

// -----------------------------------------------------------------------------------------
//                      B O L T   W I T H   O P T   T H R E A D S  
//------------------------------------------------------------------------------------------
#macro make_bolt(rad,len,opt1)
    #declare bolt_rad=.5;
    #declare bolt_length=.5;
    #declare tread_size = (rad*bolt_rad)/4;
    #declare tread_turns = (len*bolt_length)*2 ;
    #declare thread_length = len*bolt_length ;
    
    #if (opt1=0)
        cylinder { <0,0,0>,<0,-bolt_length,0>, bolt_rad scale <rad,len,rad>} 
    #end

    #if (opt1=1)
        difference {
        object { cylinder { <0,0,0>,<0,-bolt_length,0>, bolt_rad scale <rad,len,rad> } }
        //thread cutter
        object { coil(bolt_rad*rad, tread_size, tread_turns, thread_length + tread_size , "plotCoil" ) rotate<180,0,0> }  
        }
    #end
#end



// -----------------------------------------------------------------------------------------
//                      P A N    H E A D   F L A T  
//------------------------------------------------------------------------------------------
#macro make_pan_head_flat(rad,len)
    #declare bolt_rad=.5;
    #declare bolt_length=.5; 
    #declare slot_depth =  (rad*bolt_rad)/7;
    #declare slot_offset = len/3;
    union {
       difference {
            sphere {<0,0,0>, .5 scale <rad,len,rad> translate <0,len/5,0> }
            plane { <0,1,0>, 0 }
            box {<-rad*2,slot_offset,-slot_depth>,<rad*2,len,slot_depth>}   //flat slot
       } 
   }  
#end



// -----------------------------------------------------------------------------------------
//                      P A N   H E A D   P H I L L I P S
//------------------------------------------------------------------------------------------
#macro make_pan_head_phillips(rad,len)
    #declare bolt_rad=.5;
    #declare bolt_length=.5; 
    #declare slot_depth =  (rad*bolt_rad)/6;
    #declare slot_offset = len/3;
    union {
       difference {
            sphere {<0,0,0>, .5 scale <rad,len,rad> translate <0,len/5,0> }
            plane { <0,1,0>, 0 }
            object {phillips_void scale <rad*.65,len*2,rad*.65> translate <0,0,0> }
       } 
   }  
#end 




// -----------------------------------------------------------------------------------------
//                      F L A T   H E A D   P H I L L I P S
//------------------------------------------------------------------------------------------
#macro make_flat_head_phillips(rad,len)
    #declare bolt_rad=.5;
    #declare bolt_length=.5; 
    #declare slot_depth =  (rad*bolt_rad)/3;
    #declare slot_offset = len/3;
    difference {
        union { 
            cone { <0,0,0>,rad*bolt_rad, <0,len,0>,(rad*bolt_rad)*2 } 
            sphere {<0,0,0>, 1 scale <rad,len/4,rad> translate <0,len,0> }
        } 
        object {phillips_void scale <rad*1.1,len*2,rad*1.1> translate <0,0,0> }
    }
#end 


// -----------------------------------------------------------------------------------------
//                      B O L T   H E A D  
//------------------------------------------------------------------------------------------
#macro make_bolt_head(rad,len)
    #declare bolt_rad=.5;
    #declare bolt_length=.5; 
    #declare slot_depth =  (rad*bolt_rad)/3;
    #declare slot_offset = len/3;
    #declare bolt_cut = (rad*bolt_rad)/1.2;
    difference {
        union { 
            cylinder {<0,0,0>,<0,len,0>,rad*bolt_rad }
            sphere {<0,0,0>, .5 scale <rad,len/2,rad> translate <0,len,0> }
            sphere {<0,0,0>, .5 scale <rad,len/2,rad> translate <0,0,0> }
        }
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,0,0>}
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,60,0>}
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,120,0>}
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,180,0>}
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,240,0>}
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,300,0>}
    }
#end 





// -----------------------------------------------------------------------------------------
//                      N U T  
//------------------------------------------------------------------------------------------
#macro make_nut(rad,len)
    #declare bolt_rad=.5;
    #declare bolt_length=.5; 
    #declare slot_depth =  (rad*bolt_rad)/3;
    #declare slot_offset = len/3;
    #declare bolt_cut = (rad*bolt_rad)/1.2;
    difference {
        union { 
            cylinder {<0,0,0>,<0,len,0>,rad*bolt_rad }
            sphere {<0,0,0>, .5 scale <rad,len/1.5,rad> translate <0,len,0> } 
            sphere {<0,0,0>, .5 scale <rad,len/1.5,rad> translate <0,0,0> }
        }
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,0,0>}
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,60,0>}
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,120,0>}
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,180,0>}
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,240,0>}
        plane { <1,0,0>, 0 translate <-bolt_cut,0,0> rotate <0,300,0>}
    }
#end 


