// artist wood mannequin model
// m.miller 4.16.23

// -----------------------------------------------------------------------------------------
//                      M A T E R I A L S
//------------------------------------------------------------------------------------------

#declare C_gray   = color rgb <0.15,.15,.17> * 2 ; 
#declare C_gray80 = color red 0.8 green 0.8 blue 0.8; 
#declare C_white = color rgb<1,1,1>  ;
#declare C_tan = color red 0.85 green 0.66 blue 0.5;






#declare F_smooth =
finish {
    ambient 0
    diffuse 1   
    phong 1.2
    phong_size 60  
    reflection {.01, .73 fresnel}
    roughness 0.05
}

#declare F_metal_polished  =
finish {
    reflection {0, 1 fresnel on }
    conserve_energy 
    brilliance 5
    ambient 0
    diffuse .5 
    phong 5    
    phong_size 40
    metallic
    specular .4
    roughness 1/20
    reflection .5   
}

#declare F_soft_plastic =
finish {
    ambient .2
    diffuse 1   
    phong .7
    phong_size 50 
    reflection {.005, .1 fresnel} 
}     


#declare T_Wood35_tweaked=
texture {
    pigment {
        wood
        turbulence 0.03725
        omega 0.65725
        lambda 2.425
        color_map {
            [0.250 color rgbt <0.60000, 0.43353, 0.21565, 0.000> *1.5]
            [0.350 color rgbt <0.66275, 0.28607, 0.10000, 0.000> *1.5]
            [0.525 color rgbt <0.60000, 0.43353, 0.21565, 0.000> *1.5]
            [0.600 color rgbt <0.66475, 0.38647, 0.15000, 0.000> *1.5]
            [0.750 color rgbt <0.60000, 0.43353, 0.21565, 0.000> *1.5]
            [0.850 color rgbt <0.66275, 0.38667, 0.15000, 0.000> *1.5]
            [1.000 color rgbt <0.60000, 0.43353, 0.21565, 0.000> *1.5]
        }
        scale <0.25, 0.225, 1.0>
    }
}

#declare T_wood = texture { T_Wood35_tweaked   finish { diffuse .8 specular 0.20 roughness 0.2 ambient 0.25 }};
#declare T_gray80 = texture{ pigment{ rgb C_gray80 transmit 0 }}
#declare M_metal_chrome = material{ texture{ T_gray80   finish{F_metal_polished}}  }    
#declare M_default = material { texture { pigment {C_gray} finish {F_smooth}}}          

//#declare M_body = material{ texture{ pigment{C_tan}}}
#declare M_body = material{ texture{T_wood} scale<2,10,2> }


// -----------------------------------------------------------------------------------------
//                      B A L L   J O I N T
//------------------------------------------------------------------------------------------


#declare screw_head =  
object { 
difference {
    sphere { <0,0,0>, 1.1 scale <1,1,.7>} 
    box { <-.7, .15, 0>,< .7, -.15, -1> translate <0,0,-.5>} 
    box { <-.15, .7, 0>,< .15, -.7, -1> translate <0,0,-.5>}
    } 
    rotate <90,0,0> 
    material {M_metal_chrome}
}

#declare ball_joint =
union {
    difference {
        sphere{ <0,0,0>, 1 scale <2.7,2.7,2.7> translate <0.000, 0.000, 0.000> }
        box { <-4,4,-.2>,<4,-4,.2> }  //---slot 
        sphere{ <0,0,0>, .8 scale <1,1,1> translate <0, 0, -2.7> } //---screw recess
        material {M_body}  
    } 
    object { screw_head scale <.75,.75,.75> rotate <-90,0,0> translate <0,0,-2.2> }
}


// -----------------------------------------------------------------------------------------
//                      H E A D
//------------------------------------------------------------------------------------------
#declare head_sor =
lathe{ 
     cubic_spline
      13,
     <-0.000, 1.295>,
     <-0.000, 1.295>,
     <1.833, 1.303>,
     <2.953, 2.177>,
     <4.175, 7.547>,
     <4.492, 8.974>,
     <4.398, 10.400>,
     <3.925, 11.589>,
     <3.098, 12.668>,
     <1.870, 13.503>,
     <0.694, 13.854>,
     <-0.000, 13.908>,
     <-0.000, 13.908>
     material {M_body}
     }


#declare head = 
union {
    difference {
        object { head_sor } 
        plane { <0,0,1>, 0 translate <0,6,-2.6> rotate <-8,0,0> material {M_body} }
        material {M_body}
    }
    //---neck           
    object { ball_joint scale <.9,.9,.9> rotate <0,-90,0>}        
}



     
     
// -----------------------------------------------------------------------------------------
//                      C H E S T 
//------------------------------------------------------------------------------------------
#declare chest_sor =
lathe{ 
      cubic_spline
      9,
     <-0.000, 1.347>,
     <-0.000, 1.347>,
     <2.452, 1.347>,
     <4.353, 2.517>,
     <6.205, 7.770>,
     <6.988, 13.496>,
     <3.847, 16.535>,
     <0.004, 16.535>,
     <0.004, 16.535>
      material {M_body}
      }
      


#declare chest = 
union {
    difference {
        object { chest_sor scale <.9,1,.87>} 
        plane { <0,0,1>, 0 translate <0,5,-4.75> rotate <4,0,0> material {M_body} } 
        material {M_body}         
    }           
    //--- mid navel
    object { ball_joint scale <1.46,1.46,1.46> rotate <0,90,0> }
}



// -----------------------------------------------------------------------------------------
//                     G E N E R I C   A R M 
//------------------------------------------------------------------------------------------
#declare arm_sor =
lathe{ 
      cubic_spline
      10,
     <-0.000, -15.582>,
     <-0.000, -15.582>,
     <0.968, -15.582>,
     <1.779, -14.605>,
     <1.916, -11.084>,
     <2.656, -5.179>,
     <2.070, -2.857>,
     <0.682, -1.966>,
     <-0.000, -1.966>,
     <-0.000, -1.966>
      }

// -----------------------------------------------------------------------------------------
//                     G E N E R I C   L E G
//------------------------------------------------------------------------------------------
#declare leg_sor =
lathe{ 
      cubic_spline
      12,
     <0.013, -2.238>,
     <0.013, -2.238>,
     <1.578, -2.238>,
     <2.817, -3.218>,
     <3.198, -5.763>,
     <2.774, -9.093>,
     <2.266, -12.846>,
     <2.059, -15.554>,
     <1.965, -17.990>,
     <0.714, -19.251>,
     <-0.000, -19.251>,
     <-0.000, -19.251>
      }



// -----------------------------------------------------------------------------------------
//                      U P P E R   A R M 
//------------------------------------------------------------------------------------------
#declare upper_arm_sor =
lathe{ 
      cubic_spline
      10,
     <-0.000, -15.582>,
     <-0.000, -15.582>,
     <0.968, -15.582>,
     <1.779, -14.605>,
     <1.916, -11.084>,
     <2.656, -5.179>,
     <2.070, -2.857>,
     <0.682, -1.966>,
     <-0.000, -1.966>,
     <-0.000, -1.966>
      }
      

#declare upper_arm_left = 
union { 
    difference {
        object {upper_arm_sor scale <.90,1,.90>translate <0,1,0>} 
        plane { <0,-1,0>, 0 translate <0,-2.3,0> }  
        plane { <0,1,0>, 0 translate <0,-14,0> }   
        translate <0,.46,0> 
        material {M_body}
    }          
    object { ball_joint scale <1,1,1> }
    rotate <0,-15,0>
}

#declare upper_arm_right = 
union { 
    difference {
        object {upper_arm_sor scale <.90,1,.90>translate <0,1,0>} 
        plane { <0,-1,0>, 0 translate <0,-2.3,0> }  
        plane { <0,1,0>, 0 translate <0,-14,0> }   
        translate <0,.46,0> 
        material {M_body}
    }          
    object { ball_joint scale <1,1,1> }
    rotate <0,15,0>
}


// -----------------------------------------------------------------------------------------
//                      L O W E R   A R M 
//------------------------------------------------------------------------------------------


#declare lower_arm_left = 
union {
    difference {
        object {arm_sor scale <.8,.9,.8>translate <0,1,0>} 
        plane { <0,-1,0>, 0 translate <0,-1.5,0> }  
        plane { <0,1,0>, 0 translate <0,-12,0> } 
        material {M_body} 
      }           
    object { ball_joint scale <.65,.65,.65> }
    rotate <0,-80,0>            
}

#declare lower_arm_right = 
union {
    difference {
        object {arm_sor scale <.8,.9,.8>translate <0,1,0>} 
        plane { <0,-1,0>, 0 translate <0,-1.5,0> }  
        plane { <0,1,0>, 0 translate <0,-12,0> } 
        material {M_body} 
      }           
    object { ball_joint scale <.65,.65,.65> }
    rotate <0,80,0>            
}


// -----------------------------------------------------------------------------------------
//                      H A N D    
//------------------------------------------------------------------------------------------
#declare hand_left =
union {
     difference {
         sphere{ <0,0,0>, .9 scale <2.192, 4.213, 2.192> translate <-0.000, -4.436, 0.000> }
         plane { <1,0,0>, 0 rotate <0,0,10> translate <-1.5,0,0> }  
         rotate <0,90,0> //---turn hand 
         material {M_body} 
     }
    object { ball_joint scale <.55,.55,.55> rotate <0,0,0>}
    rotate <0,80,0> 
}
      
      
#declare hand_right =
union {
     difference {
         sphere{ <0,0,0>, .9 scale <2.192, 4.213, 2.192> translate <-0.000, -4.436, 0.000> }
         plane { <1,0,0>, 0 rotate <0,0,10> translate <-1.5,0,0> }  
         rotate <0,90,0> //---turn hand 
         material {M_body} 
     }
    object { ball_joint scale <.55,.55,.55> rotate <0,180,0>}
    rotate <0,80,0> 
}
       
// -----------------------------------------------------------------------------------------
//                      U P P E R   L E G    
//------------------------------------------------------------------------------------------

#declare upper_leg_left = 
union { 
    difference {
        object {leg_sor scale <.95,1,.95> translate <0,0,0>}
        plane { <0,-1,0>, 0 translate <0,-2.7,0> }  
        plane { <0,1,0>, 0 translate <0,-18,0> } 
        translate <0,.8,0>
        material {M_body}  
    }          
    object { ball_joint scale <1,1,1> rotate <0,0,0>}
    rotate <0,90,0> 
}


#declare upper_leg_right = 
union { 
    difference {
        object {leg_sor scale <.95,1,.95> translate <0,0,0>}
        plane { <0,-1,0>, 0 translate <0,-2.7,0> }  
        plane { <0,1,0>, 0 translate <0,-18,0> } 
        translate <0,.8,0>
        material {M_body}  
    }          
    object { ball_joint scale <1,1,1> rotate <0,0,0>}
    rotate <0,-90,0> 
}


// -----------------------------------------------------------------------------------------
//                      L O W E R  L E G    
//------------------------------------------------------------------------------------------

#declare lower_leg_left = 
union { 
    difference {
        object {leg_sor scale <.85,1,.85> translate <0,0,0>}
        plane { <0,-1,0>, 0 translate <0,-2.7,0> }  
        plane { <0,1,0>, 0 translate <0,-18.2,0> } 
        translate <0,.8,0> 
        material {M_body} 
    }          
    object { ball_joint scale <.87,.87,.87> rotate <0,0,0>}
    rotate <0,90,0>              
}


#declare lower_leg_right = 
union { 
    difference {
        object {leg_sor scale <.85,1,.85> translate <0,0,0>}
        plane { <0,-1,0>, 0 translate <0,-2.7,0> }  
        plane { <0,1,0>, 0 translate <0,-18.2,0> } 
        translate <0,.8,0> 
        material {M_body} 
    }          
    object { ball_joint scale <.87,.87,.87> rotate <0,0,0>}
    rotate <0,-90,0>              
}


// -----------------------------------------------------------------------------------------
//                      F O O T
//------------------------------------------------------------------------------------------

#declare foot =
union { 
     difference {
         sphere{ <0,0,0>, 1 scale <2.927, 2.927, 5> translate <-0.000, -3.5, -2> }
         plane {<0,1,0>,0 translate <0,-3.5,0>} 
         plane {<0,0,-1>,0 translate <0,0,1.9>}
         material {M_body}
    }
    object { ball_joint scale <.67,.67,.67> rotate <0,90,0>}
    rotate <0,0,0> 
}  
      
      
      
// -----------------------------------------------------------------------------------------
//                      P E L V I S 
//------------------------------------------------------------------------------------------
#declare pelvis_sor =
lathe{ 
      cubic_spline
      9,
     <-0.000, -4.461>,
     <-0.000, -4.461>,
     <4.252, -4.461>,
     <6.153, -2.874>,
     <5.655, 1.417>,
     <4.813, 4.807>,
     <2.283, 6.434>,
     <0.019, 6.434>,
     <0.019, 6.434>
      }

#declare pelvis = 
difference {
    object { pelvis_sor  scale <.94,1.1,.8> translate <0,2,0>} 
    plane { <0,0,1>, 0 translate <0,5,-4.25> rotate <2,0,0>  }
    plane { <0,-1,0>, 0 translate <0,7.3,0> } 
    plane { <0,1,0>, 0 translate <0,-2.2,0> }
    material {M_body}          
}



// -----------------------------------------------------------------------------------------
//                      P O S E
//------------------------------------------------------------------------------------------
#declare x_back     =   1 ;
#declare x_forward  =  -1 ;
#declare y_right    =   1 ;
#declare y_left     =  -1 ;
#declare z_right    =   1 ;
#declare z_left     =  -1 ;



//--- pivot transforms
#declare head_offset = <0,18,0> ;
#declare chest_offset = <0,8.4,0> ;
#declare pelvis_offset = <0,-1,0> ;   // centet of mannequin pose
#declare upper_arm_left_offset =  <-8.45,12.1,0> ; 
#declare lower_arm_left_offset =  <0,-14.7,0> ;
#declare upper_arm_right_offset = <8.45,12.1,0>  ;    
#declare lower_arm_right_offset = <0,-14.7,0>  ;
#declare upper_leg_left_offset = <-3.15,-4,0> ;
#declare upper_leg_right_offset = <3.15,-4,0> ;
#declare lower_leg_left_offset =  <0,-19,0> ;
#declare lower_leg_right_offset = <0,-19,0> ;
#declare hand_right_offset = <0,-13,0> ;
#declare hand_left_offset = <0,-13,0> ;
#declare foot_left_offset = <0,-19,0> ;
#declare foot_right_offset = <0,-19,0> ;
      
      

//--- poses
#declare standing = 1;
#declare sitting  = 2;
#declare balance  = 3;
#declare sitting2  = 4;

#macro mannequin_pose (pose) 

    #switch (pose)
        #case (standing)
            
            //---head            
            #declare head_tilt = 0*x_forward;
            #declare head_turn = 0*y_right;
             
            //---chest 
            #declare chest_tilt = 0*x_forward;
            #declare chest_turn = 0*y_right; 
            
            //---pelvis
            #declare pelvis_tilt = 0*x_forward;
            #declare pelvis_turn = 0*y_left; 
            
            //--- right arm
            #declare upper_arm_right_rise = 0*x_back;
            #declare upper_arm_right_fan =  0*y_left;
            #declare lower_arm_right_rise = 0*x_back;
            #declare lower_arm_right_fan =  0*y_left;                                                   
            
            //--- left arm
            #declare upper_arm_left_rise = 0*x_forward;
            #declare upper_arm_left_fan = 0*y_right;
            #declare lower_arm_left_rise = 0*x_back;
            #declare lower_arm_left_fan =  0*y_left; 
            
            //--- left hand
            #declare hand_left_rise = 0*x_back;
            #declare hand_left_turn =  90*y_left;   
            
            //--- right hand
            #declare hand_right_rise = 0*x_back;
            #declare hand_right_turn =  -90*y_right;
            
            //--- left upper leg
            #declare upper_leg_left_rise = 0*x_back;
            #declare upper_leg_left_fan =  0*z_right; 
            
            //--- right upper leg
            #declare upper_leg_right_rise = 0*x_back;
            #declare upper_leg_right_fan =  0*z_right; 
            
            //--- left lower leg
            #declare lower_leg_left_rise = 0*x_back;
            #declare lower_leg_left_fan =  0*y_left; 
            
            //--- right lower leg
            #declare lower_leg_right_rise = 0*x_back;
 
 
             //--- foot right
            #declare foot_right_rise = 0*x_back;
            #declare foot_right_fan =  0*y_left;

             //--- foot left
            #declare foot_left_rise = 0*x_back;
            #declare foot_left_fan =  0*y_left;
            
        #break


        #case (sitting)
            
            //---head            
            #declare head_tilt = 10*x_forward;
            #declare head_turn = 20*y_right;
             
            //---chest 
            #declare chest_tilt = 20*x_forward;
            #declare chest_turn = 0*y_right; 
            
            //---pelvis
            #declare pelvis_tilt = 0*x_forward;
            #declare pelvis_turn = 0*y_left; 
            
            //--- right arm
            #declare upper_arm_right_rise = 30*x_back;
            #declare upper_arm_right_fan =  20*y_left;
            #declare lower_arm_right_rise = 20*x_back;
            #declare lower_arm_right_fan =  0*y_left;                                                   
            
            //--- left arm
            #declare upper_arm_left_rise = 30*x_back;
            #declare upper_arm_left_fan = 20*y_right;
            #declare lower_arm_left_rise = 20*x_back;
            #declare lower_arm_left_fan =  0*y_left; 
            
            //--- left hand
            #declare hand_left_rise = 40*x_back;
            #declare hand_left_turn =  -70*y_right;   
            
            //--- right hand
            #declare hand_right_rise = 40*x_back;
            #declare hand_right_fan =  -90*y_right;
            
            //--- left upper leg
            #declare upper_leg_left_rise = 89*x_back;
            #declare upper_leg_left_fan =  20*z_left; 
            
            //--- right upper leg
            #declare upper_leg_right_rise = 89*x_back;
            #declare upper_leg_right_fan =  20*z_right; 
            
            //--- left lower leg
            #declare lower_leg_left_rise = -90*x_back;
            
            //--- right lower leg
            #declare lower_leg_right_rise = -90*x_back;
 
                
             //--- foot right
            #declare foot_right_rise = 0*x_back;
            #declare foot_right_fan =  0*y_left;

             //--- foot left
            #declare foot_left_rise = 0*x_back;
            #declare foot_left_fan =  0*y_left;
                                                                  
        #break


        #case (sitting2)
            
            //---head            
            #declare head_tilt = 30*x_back;
            #declare head_turn = -60*y_right;
             
            //---chest 
            #declare chest_tilt = 20*x_forward;
            #declare chest_turn = 0*y_right; 
            
            //---pelvis
            #declare pelvis_tilt = 0*x_forward;
            #declare pelvis_turn = 0*y_left; 
            
            //--- right arm
            #declare upper_arm_right_rise = 30*x_back;
            #declare upper_arm_right_fan =  30*y_left;
            #declare lower_arm_right_rise = 20*x_back;
            #declare lower_arm_right_fan =  0*y_left;                                                   
            
            //--- left arm
            #declare upper_arm_left_rise = 30*x_back;
            #declare upper_arm_left_fan =  30*y_right;
            #declare lower_arm_left_rise = 20*x_back;
            #declare lower_arm_left_fan =  0*y_left; 
            
            //--- left hand
            #declare hand_left_rise = 35*x_back;
            #declare hand_left_turn =  0*y_right;   
            
            //--- right hand
            #declare hand_right_rise = 35*x_back;
            #declare hand_right_fan =  0*y_right;
            
            //--- left upper leg
            #declare upper_leg_left_rise = 95*x_back;
            #declare upper_leg_left_fan =  20*z_left; 
            
            //--- right upper leg
            #declare upper_leg_right_rise = 95*x_back;
            #declare upper_leg_right_fan =  20*z_right; 
            
            //--- left lower leg
            #declare lower_leg_left_rise = -10*x_back;
            
            //--- right lower leg
            #declare lower_leg_right_rise = -10*x_back;
 
                
             //--- foot right
            #declare foot_right_rise = -20*x_back;
            #declare foot_right_fan =  0*y_left;

             //--- foot left
            #declare foot_left_rise = -20*x_back;
            #declare foot_left_fan =  0*y_left;
                                                                  
        #break
        
        
        #case (balance)
            
            //---head            
            #declare head_tilt = -20*x_forward;
            #declare head_turn = 10*y_right;
             
            //---chest 
            #declare chest_tilt = 40*x_forward;
            #declare chest_turn = 0*y_right; 
            
            //---pelvis
            #declare pelvis_tilt = 0*x_forward;
            #declare pelvis_turn = 20*y_left; 
            
            //--- right arm
            #declare upper_arm_right_rise = 30*x_back;
            #declare upper_arm_right_fan =  30*y_left;
            #declare lower_arm_right_rise = 50*x_back;
            #declare lower_arm_right_fan =  0*y_left;                                                   
            
            //--- left arm
            #declare upper_arm_left_rise = -90*x_forward;
            #declare upper_arm_left_fan = 90*y_right;
            #declare lower_arm_left_rise = 40*x_back;
            #declare lower_arm_left_fan =  0*y_left; 
            
            //--- left hand
            #declare hand_left_rise = 60*x_back;
            #declare hand_left_turn =  30*y_left;   
            
            //--- right hand
            #declare hand_right_rise = 20*x_back;
            #declare hand_right_fan =  180*y_right;
            
            //--- left upper leg
            #declare upper_leg_left_rise = 40*x_back;
            #declare upper_leg_left_fan =  5*z_left; 
            
            //--- right upper leg
            #declare upper_leg_right_rise = -10*x_back;
            #declare upper_leg_right_fan =  30*z_right; 
            
            //--- left lower leg
            #declare lower_leg_left_rise = 50*x_forward;
            
            //--- right lower leg
            #declare lower_leg_right_rise = -60*x_back;
 
                
             //--- foot right
            #declare foot_right_rise = -20*x_back;
            #declare foot_right_fan =  0*y_left;

             //--- foot left
            #declare foot_left_rise = 8*x_back;
            #declare foot_left_fan =  -20*y_left;
                                                                  
        #break
    #end    
    
    union { 
        union {
            union {
                object { head   rotate <head_tilt,0,0>    rotate <0,head_turn,0> translate head_offset}
                object { chest  }
                
                union {      //--- upper_arm_left
                    object { upper_arm_left  }
                    
                    union {
                        object { lower_arm_left }
                        object {
                            hand_left  
                            rotate <0,hand_left_turn,0> 
                            rotate <hand_left_rise,0,0> 
                            translate hand_left_offset
                            

                            }
                        rotate <lower_arm_left_rise,0,0>   
                        rotate <0,lower_arm_left_fan,0>  
                        translate lower_arm_left_offset
                    }
                    rotate <upper_arm_left_rise,0,0>   
                    rotate <0,upper_arm_left_fan,0>  
                    translate upper_arm_left_offset
                 
                 }
                 
                

                
                union {     //--- upper arm right
                    object { upper_arm_right }
                   
                    union {
                        object { lower_arm_right  }
                        //--- hand
                        object {
                            hand_right  
                            rotate <0,hand_right_turn,0> 
                            rotate <hand_right_rise,0,0>
                            translate hand_right_offset 
                            }
                        
                        rotate <lower_arm_right_rise,0,0>  
                        rotate <0,lower_arm_right_fan,0> 
                        translate lower_arm_right_offset  
                    }
                    
                    rotate <upper_arm_right_rise,0,0>  
                    rotate <0,upper_arm_right_fan,0> 
                    translate upper_arm_right_offset 
                }    
     
                rotate <chest_tilt,0,0>
                rotate <0,chest_turn,0>
                translate chest_offset 
                
            }  
            
            union {
                object { pelvis  }
                
                
                union {
                     object {upper_leg_left}
                     
                     union {
                         object {lower_leg_left }
                         object { foot rotate <foot_left_rise,0,0> rotate <0,foot_left_fan,0> translate foot_left_offset }
                         
                         //---left knee
                         rotate <lower_leg_left_rise,0,0> 
                         translate lower_leg_left_offset
                     }
                     
                     //--- left leg joint at pelvis
                     rotate <0,0,upper_leg_left_fan>
                     rotate <upper_leg_left_rise,0,0>   
                     translate upper_leg_left_offset 
                     
                }
                
                union {
                     object {upper_leg_right}
                     
                    union {
                         object {lower_leg_right }
                         object { foot rotate <foot_right_rise,0,0> rotate <0,foot_right_fan,0> translate foot_right_offset } 
                         
                         //---right knee
                         rotate <lower_leg_right_rise,0,0> 
                         translate lower_leg_right_offset
                     }
                     //--- right leg joint at pelvis
                     rotate <0,0,upper_leg_right_fan> 
                     rotate <upper_leg_right_rise,0,0>  
                     translate upper_leg_right_offset
                }
                
                
                
                rotate <pelvis_tilt,0,0>
                rotate <0,pelvis_turn,0>
                translate pelvis_offset 
            }
            
        }
    }
    

    
#end

   