// solder gun
// m.miller 04.10.23

#version 3.8; 
global_settings {    
    max_trace_level 7
    ambient_light <.01,.01,.011> * 5                  
}                        
#include "shapes.inc"
#include "shapes2.inc"


// -----------------------------------------------------------------------------------------
//                      L I G H T
//------------------------------------------------------------------------------------------ 
#declare array_count = 12    ;
#declare light_front =
light_source {
    <0,0,0> 
    #declare light_color = color red .05 green .05 blue .05 ;                      
    light_color * 10                  
    area_light
    <200, 0, 0> <0, 0, 200>         
    array_count, array_count                          
    adaptive 0                    
    jitter                        
    circular                      
    orient                     
    fade_distance 200
    fade_power 2     
    translate <0,100,-200>
}   
light_front

#declare array_count = 16    ;
#declare light_back =
light_source {
    <0,0,0> 
    #declare light_color = color red .05 green .05 blue .05 ;                      
    light_color * 10                  
    area_light
    <200, 0, 0> <0, 0, 200>         
    array_count, array_count                          
    adaptive 0                    
    jitter                        
    circular                      
    orient                     
    fade_distance 200
    fade_power 2     
    translate <100,100,100>
}   
light_back



//---------------------------------------------------------------------------------   
//                               F O G            
//--------------------------------------------------------------------------------- 
#declare fog_color_tan = rgbft<0.35, 0.3, 0.25, 0.0, 0.0> ; 
#declare fog_color_gray = rgbft<0.17, 0.17, 0.17, 0.0, 0.0> ;
#declare fog_color_blue = rgbft<0.10, 0.27, 0.4, 0.0, 0.0>;
 

#declare show_fog = true;
#declare fog_color = fog_color_gray * .1; 
#declare fog_distance = 1000;
#declare fog_turb = 2;
#declare fog_depth = 200; 
#declare fog_octaves = 100;
#declare fog_os = 5;

#if (show_fog = true) 
    fog {
        distance fog_distance
        color fog_color
        turbulence fog_turb  
        turb_depth fog_depth
        octaves fog_octaves   
        fog_offset fog_os  
        }
#end

// -----------------------------------------------------------------------------------------
//                      M A N N E Q U I N
//------------------------------------------------------------------------------------------

//--- poses
// standing = 1;
// sitting  = 2;
// balance  = 3;

#include "mannequin_pose.inc"
object { mannequin_pose(1) translate <0,46.5,0> }
object { mannequin_pose(3) rotate <0,50,0> translate  <40,41.75,-20> } 
object { mannequin_pose(2) rotate <0,-45,0> translate <-45,37.5,-5> }
object { mannequin_pose(4) rotate <0,55,0> translate <40,8,50> }


// -----------------------------------------------------------------------------------------
//                      S T A G E
//------------------------------------------------------------------------------------------
union {
    union {
        object { Round_Box(<-20,0,-20>,<20,30,20>, 1.5   , 0) rotate <0,-45,0> translate <-50,0,0> }
        plane { <0,1,0>, 0 }
        material {M_default} 
    }    
        object { sphere { <0,0,0>, 20 } translate <-110,20,100> material{ texture{T_wood} scale<8,30,8> }}
    
}

         

// -----------------------------------------------------------------------------------------
//                      C A M E R A 
//------------------------------------------------------------------------------------------

#declare ortho_fov = 1.64;   
#declare pers_fov = 47;

#macro view_zero(f, pos)
    camera {
        up <0, 1, 0>
        angle f    
        location <-20,30, -210> 
        look_at pos
    } 
#end 

view_zero(pers_fov,<0,40,0>) 
