// -----------------------------------------------------------------------------------------
//                      L I G H T S
//------------------------------------------------------------------------------------------ 

#declare array_count = 8    ;

// --- S K Y  L I G H T
#declare light_A =
light_source {
    <0,0,0> 
    #declare light_color = color red .05 green .05 blue .05 ;                      
    light_color * 50                  
    area_light
    <300, 0, 0> <0, 0, 100>         
    array_count, array_count                          
    adaptive 0                    
    jitter                        
    circular                      
    orient                     
    fade_distance 80
    fade_power 2     
    translate <200, 600, -200>
}   
light_A



// --- S K Y  L I G H T
#declare light_B =
light_source {
    <0,0,0> 
    #declare light_color = color red .05 green .05 blue .05 ;                      
    light_color * 5                  
    area_light
    <200, 0, 0> <0, 0, 200>         
    array_count, array_count                          
    adaptive 0                    
    jitter                        
    circular                      
    orient                     
    fade_distance 100
    fade_power 2     
    translate <0, 350, -600>
}   
light_B





//pc board led
#declare light_D =
light_source {
    <0,0,0> 
    #declare light_color = color red .5 green 0 blue 0 ;                      
    light_color * 20                   
    area_light
    <1, 0, 0> <0, 0, 1>         
    8,8                          
    adaptive 0                    
    jitter                        
    circular                      
    orient 
    fade_distance 1
    fade_power 2                       
    
}


// --- S K Y  L I G H T
#declare light_zero =
light_source {
    <0,0,0> 
    #declare light_color = color red .05 green .05 blue .05 ;                      
    light_color * 20                  
    area_light
    <50, 0, 0> <0, 0, 50>         
    array_count, array_count                          
    adaptive 0                    
    jitter                        
    circular                      
    orient                     
    fade_distance 200
    fade_power 2     
    translate <0,500,0>
}   
light_zero




// -----------------------------------------------------------------------------------------
//                      C A M E R A S
//------------------------------------------------------------------------------------------ s

#macro render_plan(f, nx, nz)
    camera {
        up <0, 1, 0>
        angle f    
        location <0, 50000, 0>
        look_at <0 , 0 ,  0> 
        translate <nx,0,nz>
    } 
#end 

#macro render_front_elev(f, nx, ny)
    camera {
        up <0, 1, 0>
        angle f    
        location <0, 40, -100000>
        look_at <0 , 0 ,  0> 
        translate <nx,ny,0>
    } 
#end 
 
 
#macro render_side_elev(f, nx, ny)
    camera {
        up <0, 1, 0>
        angle f    
        location <-5000, 0, 0>
        look_at <0 , 0 ,  0> 
        translate <nx,ny,0>
    } 
#end 


#macro render_ceiling(f, nx, ny)
    camera {
        up <0, 1, 0>
        angle f    
        location <0, -5000, 0>
        look_at <0 , 0 ,  0> 
        translate <nx,ny,0>
    } 
#end 



#macro render_top_left(f, pos)
    camera {
        up <0, 1, 0>
        angle f    
        location <0, 200, -200> 
        look_at pos
    } 
#end 


#macro render_bottom_left(f, pos)
    camera {
        up <0, 1, 0>
        angle f    
        location <-50, -50, -50> 
        look_at pos
    } 
#end 



#macro render_top_right(f, pos)
    camera {
        up <0, 1, 0>
        angle f    
        location <100, 50, -50> 
        look_at pos
    } 
#end   


#macro render_bottom_right(f, pos)
    camera {
        up <0, 1, 0>
        angle f    
        location <50, -50, -50> 
        look_at pos
    } 
#end        

#macro render_ground_left(f, pos)
    camera {
        up <0, 1, 0>
        angle f    
        location <-20, 10, -250> 
        look_at pos
    } 
#end       



#macro render_view_A(f, pos)
    camera {
        up <0, 1, 0>
        angle f    
        location <-60, 50, -210> 
        look_at pos
    } 
#end  


#macro render_view_B(f, pos)
    camera {
        up <0, 1, 0>
        angle f    
        location <-80, 55, -90> 
        look_at pos
    } 
#end  

#macro render_view_C(f, pos)
    camera {
        up <0, 1, 0>
        angle f    
        location <250, 380, -400> 
        look_at pos
    } 
#end  

#macro render_view_D(f, pos)
    camera {
        up <0, 1, 0>
        angle f    
        location <-250, 400, -1000> 
        look_at pos
    } 
#end  
           
           
#macro view_zero(f, pos)
    camera {
        up <0, 1, 0>
        angle f    
        location <-200, 200, -200> 
        look_at pos
    } 
#end 
      