// solder gun
// m.miller 04/10/23


// -----------------------------------------------------------------------------------------
//                      M A P S 
//------------------------------------------------------------------------------------------

   

#declare imgDiffuse = "solder_gun_diffuse.jpg" 
#declare imgBump = "solder_gun_bump.jpg"

#declare M_solding_gun =
material {
    texture {
       pigment { 
            image_map {
                jpeg imgDiffuse     
                map_type 0
                interpolate 4 
                }
      }
   
     finish { 
        F_plastic_gloss2
     }
     
    normal  {
        bump_map {
            jpeg imgBump 
            map_type 0
            interpolate 4 
        } 
        bump_size 1
    }
        
    }
    
    
    scale <100,100,100> 
    rotate x*90
    translate <-50,0,-50>  
}


// -----------------------------------------------------------------------------------------
//                      U N D E R L A Y 
//------------------------------------------------------------------------------------------  
#declare sg_underlay =
#declare rad = .05 ;
union { 
    #declare sc = <100.000, 0.100, 100.000> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) translate <-0.000, 0.000, 0.000> } 
      }




// -----------------------------------------------------------------------------------------
//                      V O I D S   F O R   M A I N   B O D Y 
//------------------------------------------------------------------------------------------       
      
            
#declare sg_body_cut_A =
#declare rad = 1 ;
union { 
    #declare sc = <71.364, 9.919, 25.983> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <32.864, 15, -13.992> } 
    #declare sc = <100, 9.919, 25.983> ;
    #declare rad = 2 ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <35.905, 14.9, 41.5> }
    material {M_solding_gun} 
      } 
      
      
#declare sg_body_cut_B =  
difference {
    cylinder { <0, 0, 13.811>,<5.709, 0.000, 0.582>,4.183 translate<0,4,0> }  
    plane { <0,0,1>, 0 translate <0, 0, 4.367> } 
    plane { <0,0,-1>, 0 translate <0, 0, 11> } 
    material {M_solding_gun}
}

#declare gun_label_void = 
#declare rad = .25 ;
union { 
    #declare sc = <16.210, 1.044, 2.75> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,1.5> translate <18.959, 4.494, 15.5> } 
      }
            
            
         
#declare p1 = <3.8,0, 18.6> ;
#declare p2 = <38.121, 0, 18.6> ;
#declare p3 = <42.510, 0, 15.097> ;
#declare p4 = <30.539, 0, -23.041>;
#declare p5 = <3.353, 0, 1.280> ;
     
#declare void_punch_A =  cylinder { <0,0,0>,<0,50,0>, 1.4 } ; 
     


// -----------------------------------------------------------------------------------------
//                      M A I N   B O D Y  P A R T S 
//------------------------------------------------------------------------------------------
   
#declare screw_head =  
object { 
difference {
    sphere { <0,0,0>, 1.1 scale <1,1,.7>} 
    box { <-.7, .15, 0>,< .7, -.15, -1> translate <0,0,-.5>} 
    box { <-.15, .7, 0>,< .15, -.7, -1> translate <0,0,-.5>}
    } 
    rotate <90,0,0> 
    material {M_metal_chrome}
}
  
#declare gun_grip_A =
sphere_sweep {
     cubic_spline
     23,
     <3.353, 0.000, 1.280> , 1.085
     <3.353, 0.000, 1.280> , 1.085
     <8.509, 0.0, 0.152> , 1.284
     <10.134, 0.0, -3.030> , 1.284
     <10.371, 0.0, -7.161> , 1.284
     <8.610, 0.0, -12.071> , 1.284
     <11.625, 0.0, -12.959> , 1.284
     <14.265, 0.0, -14.374> , 1.284
     <17.178, 0.0, -18.099> , 1.284
     <21.040, 0.0, -25.823> , 1.284
     <26.025, 0.0, -35.373> , 1.284
     <28.483, 0.0, -40.008> , 1.284
     <28.624, 0.0, -42.395> , 1.284
     <36.629, 0.0, -42.887> , 1.284
     <43.861, 0.0, -42.816> , 1.284
     <45.827, 0.0, -41.904> , 1.284
     <44.353, 0.0, -37.690> , 1.284
     <39.718, 0.0, -26.034> , 1.284
     <33.469, 0.0, -13.675> , 1.284
     <28.694, 0.0, -5.249> , 1.284
     <29.326, 0.0, -2.089> , 1.284
     <33.258, 0.0, 0.578> , 1.284
     <33.258, 0.0, 0.578> , 1.284
     tolerance 0.000001
     }
     


#declare gun_handle =
sphere_sweep {
     cubic_spline
     8,
     <38.868, 0.000, -44.031> , 8.037
     <38.868, 0.000, -44.031> , 8.037
     <35.956, 0.000, -36.183> , 8.037
     <30.033, 0.000, -23.823> , 8.312
     <24.006, 0.000, -12.062> , 7.807
     <19.910, 0.000, -6.034> , 8.796
     <20.027, 0.000, 2.976> , 10.989
     <20.027, 0.000, 2.976> , 10.989
     tolerance 0.000001
     }


#declare gun_grip_groove = cylinder { <0, 0, >, <50, 0, 0>, 0.30 }  ;

#declare sg_butt_old = 
object { cylinder { <0, 0, 0>, <0,0,5>, 10.1 }  
    scale <1,.2,1>
    translate <37.5,0,-44> 
    } 

         

#declare sg_butt =        
difference {
    object { 
        Round_Cylinder(<-11.5,0,0>, <11.5,0,0>, 4 , 3,0) 
        translate <37.5,0,-42>
        }
     plane { <0,0,-1> 0 rotate <0,-3,0> translate <37,0,-41>}
     plane { <0,0,1> 0 rotate <0,0,0> translate <37,0,-44>}
         
}        


#declare gun_trigger =  
object { 
    union {
        sphere_sweep {
             cubic_spline
         11,
         <11.380, 0.000, -3> , 0.634
         <11.380, 0.000, -3> , 0.634
         <7.501, 0.000, -3> , 0.634
         <4.623, 0.000, -3> , 0.634
         <5.159, 0.000, -4.504> , 0.634
         <5.300, 0.000, -6.705> , 0.634
         <5.102, 0.000, -8.850> , 0.634
         <4.651, 0.000, -10.684> , 0.634
         <7.247, 0.000, -10.656> , 0.634
         <11.746, 0.000, -10.656> , 0.634
         <11.746, 0.000, -10.656> , 0.634
         scale <1,1.2,1>
         } 

        #declare rad = .25 ;
        #declare sc = <2.6, 0.255, 4.702> ; 
        difference {
            object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <7.501, 0.000, -6.039> } 
            sphere{ <0,0,0>, 1 scale <0.7, 0.5, 0.7> translate <7.109, .3, -5> }
            sphere{ <0,0,0>, 1 scale <0.7, 0.5, 0.7> translate <7.109, .3, -8.759> }
        }material { M_sg_maroon_gloss}         
         
    }
}     


#declare sg_ribs =
#declare rad = .5 ; 
difference {
    union { 
        #declare sc = <2, 1, 0.458> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <22,2,1.0> translate <19.017, 0, 4.367> } 
        #declare sc = <2, 1, 0.458> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <22,2,1.0> translate <19.017, 0, 6.561> } 
        #declare sc = <2, 1, 0.458> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <22,2,1.0> translate <19.017, 0, 8.796> } 
        scale <1,3,1>
       
          } 
     plane { <0,-1,0>, -2 }
     translate <0,3.5,0>  
     material {M_solding_gun}
           
}  



// -----------------------------------------------------------------------------------------
//                      M A I N   B O D Y   
//------------------------------------------------------------------------------------------  
#declare sg_body_A =
#declare rad = 3 ;
union { 

    union {
       object {screw_head scale 1 translate p1 + <0,4.25,0>} 
       object {screw_head scale 1 translate p2 + <0,4.25,0>}
       object {screw_head scale 1 translate p3 + <0,2.5,0>}
       object {screw_head scale 1 translate p4 + <0,3.0,0>}
       object {screw_head scale 1 translate p5 + <0,4.25,0>}
    }
    
    object {sg_ribs }
    object { gun_trigger }
    object { sg_butt material {M_solding_gun} }
    object { sg_butt scale <1,.8,1>translate <.2,0,-.5> material {M_solding_gun} }
    
    difference {
        union { 
            #declare sc = <10, 3.960, 13> ; 
            difference {
                 object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <5.2,2,2> translate <19.017, -0.000, 10.394> }  
                 plane { <1,0,0> 0 translate <-5.5,0,0>}
                 }
            difference {        
                 object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <5.22,.7,2.02> translate <19.017, -0.000, 10.394> } 
                 plane { <1,0,0> 0 translate <-5.6,0,0>}
                 }

            difference {
                object { gun_grip_A scale <1,2,1> }
                plane { <0,0,1> 0 translate <0,0,-42>}
                sphere{ <0,0,0>, 1 scale <8.8, 20, 8.8> translate <1, 0.000, -6.0> } //--trigger curve
            }
            difference {
                union {           
                    object { gun_handle scale <1,.25,1> translate <0,1.25,0>} 
                    object { gun_handle scale <1,.25,1> translate <0,-1.25,0>}
                    sphere{ <0,0,0>, 1 scale <6.524, 1, 6.524> translate <13.199,1.2, -7.015> }

                } 
                plane { <0,0,1> 0 translate <0,0,-42> } 
                #declare i=0;
                #declare c=30;
                #declare gap=1.5;
                #declare zPos =-42;
                #while (i<c)
                    #declare nZ = zPos + (i*gap);
                    object { gun_grip_groove scale <1,3,1> translate <0,3.0,nZ>}
                    #declare i=i+1;    
                #end 
                
                plane { <0,0,1> 0 translate <0,0,-42>} 
                sphere{ <0,0,0>, 1 scale <9, 50, 9> translate <1, 0.000, -6.0> } //--trigger curve
            }
         }
         object { sg_body_cut_A } 
         object { sg_body_cut_B translate <10,0,0> }
         object { sg_body_cut_B translate <21,0,0> }
         object { sg_body_cut_B translate <32,0,0> } 
         object {gun_label_void translate <0,2,-1.5> } 
         
         object { void_punch_A translate p1 } 
         object { void_punch_A translate p2 }
         object { void_punch_A translate p3 }
         object { void_punch_A translate p4 }
         object { void_punch_A translate p5 }

         object {cylinder { <-5.847, 0, 16.052>,<-23.000, 0, 16.052>,2.1 translate<5,0,0> }}
         object {cylinder { <-5.847, 0, 11.052>,<-23.000, 0, 11.052>,2.1 translate<5,0,0> }} 
         
         #declare rad = .25 ;
         #declare sc = <4.780, 1, 5.653> ;
         object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <7.501, 0.000, -6.039> } 
         material {M_solding_gun}
     }
}




// -----------------------------------------------------------------------------------------
//                     H E A T   M E T A L   E L E M E N T S 
//------------------------------------------------------------------------------------------
#declare rod_nut =
difference {
    object { Round_Cylinder(<-26.478, 0, 0>, <-28.564, 0, 0> , 1.756 , 1,   0)}
    #declare i=0;
    #declare c=6;
    #declare a=60;
    
    #while (i < c)
    
        plane { <0,-1,0> 0 translate <0,1.5,0> rotate <a*i,0,0> }   
        #declare i=i+1;
        
    #end
}



#declare sg_rods = 
union {
    cylinder { <0, 0, 16.052>,<-23.000, 0, 16.052>,1.8 translate <0,0,0> }
    cylinder { <0, 0, 11.052>,<-23.000, 0, 11.052>,1.8 translate <0,0,0> }
    
    object { Round_Cylinder(<-23.000, 0, 16.052>, <-26.478, 0, 16.052> , 2.2 , .5,   0)}
    object { Round_Cylinder(<-23.000, 0, 11.052>, <-26.478, 0, 11.052> , 2.2 , .5,   0)}

    object { rod_nut translate <0,0,16.052> }
    object { rod_nut translate <0,0,11.052> } 
    material {M_metal_chrome}
}


#declare gun_tip = 
difference {
    sphere_sweep {
         cubic_spline
         18,
         <-27.426, 0.0, 16.052> , 0.426
         <-27.426, 0.0, 16.052> , 0.426
         <-30.578, 0.0, 16.052> , 0.426
         <-31.998, 0.0, 16.052> , 0.426
         <-33.909, 0.0, 15.943> , 0.426
         <-38.683, 0.0, 15.943> , 0.426
         <-44.350, 0.0, 15.920> , 0.426
         <-45.597, 0.0, 15.708> , 0.521
         <-46.632, 0.0, 15.708> , 0.788
         <-45.079, 0.0, 14.885> , 0.426
         <-42.728, 0.0, 14.509> , 0.426
         <-38.965, 0.0, 14.109> , 0.426
         <-37.178, 0.0, 13.686> , 0.426
         <-33.886, 0.0, 12.040> , 0.426
         <-31.887, 0.0, 11.169> , 0.426
         <-30.052, 0.0, 11.028> , 0.426
         <-27.630, 0.0, 11.052> , 0.426
         <-27.630, 0.0, 11.052> , 0.426
         tolerance 0.000001
         }   
   plane { <0,-1,0> 0 translate <0,.35,0>  }
   material {M_old_copper scale <2,2,2>}      
         
} 




#declare gun_solder_tip =
object {
    #declare th = 0.5 ;
    #declare sf = 2.1 ;
    #declare nStrenth = -5 ;
    #declare nSize = 1 ;
    blob {
         threshold th
         sphere{ <0,0,0>, 1, 1 scale <1.031, 1.031, 1.031> * sf  translate <-45.403, 0.000, 15.587> }
         sphere{ <0,0,0>, 1, 1 scale <0.798, 0.798, 0.798> * sf  translate <-46.759, 0.000, 15.799> }
         sphere{ <0,0,0>, 1, 1 scale <0.637, 0.637, 0.5> * sf  translate <-43.934, 0.000, 14.672> }
         }  
    scale <1,.6,1>  
    translate <0,-.05,0>   
    material {M_metal_chrome}
}   



// -----------------------------------------------------------------------------------------
//                     L I G H T   B U L B 
//------------------------------------------------------------------------------------------
#include "macro_coil.inc"
#declare light_filament = 
object { 
    coil (.7,.13,2,2,"plotCoil") 
    }
      
#declare gun_bulb =  
union {
    #declare th = 0.4 ;
    #declare sf = 2.0 ;
    #declare nStrenth = -5 ;
    #declare nSize = 1 ;
    blob {
         threshold th
         sphere{ <0,0,0>, 1, 1 scale <.9, .9, .9> * sf  translate <-9.7, 0.000, 4.035> }
         sphere{ <0,0,0>, 1, 1 scale <1.459, 1.459, 1.459> * sf  translate <-7.676, 0.000, 4.035> } 
         material {M_glass}
         }
     
    cylinder {  <-7, 0.000, 4.035>, <-5, 0.000, 4.035>, 1.72 material {M_metal_chrome}} 
    object { light_filament material {M_gold_glow} rotate <0,0,90> translate <-7,0,3.99> } 
} 







#declare gun_light =
light_source {
    <0,0,0> 
    #declare light_color = color red .7 green .6 blue .5 ;                      
    light_color * 10                   
    area_light
    <1, 0, 0> <0, 0, 1>         
    8,8                          
    adaptive 0                    
    jitter                        
    circular                      
    orient 
    fade_distance 4
    fade_power 2  
    translate <-12,1,4>                     
    
}     

gun_light


// -----------------------------------------------------------------------------------------
//                     C O R D
//------------------------------------------------------------------------------------------

#declare gun_cord_sweep = 
#declare sz = .8 ;
sphere_sweep {
     cubic_spline
     11,
     <39.414, 0.0, -37.257> , sz
     <39.414, 0.0, -37.257> , sz
     <43.276, 0.0, -51.828> , sz
     <41.703, 0.0, -63.535> , sz
     <31.919, -.3, -71.747> , sz
     <31.394, -.7, -84.677> , sz
     <41.179, -1.2, -92.715> , sz
     <65.991, -1.5, -88.521> , sz
     <88.880,  -2, -73.494> , sz
     <120.856, -2, -70.349> , sz
     <120.856, -2, -70.349> , sz
     tolerance 0.000001
     }

#declare gun_cord_base = 
#declare sz = 2 ;
sphere_sweep {
     cubic_spline
     4, 
     <39.414, 0.0, -37.257> , sz
     <39.414, 0.0, -37.257> , sz
     <43.276, 0.0, -51.828> , sz
     <41.703, 0.0, -63.535> , sz
     tolerance 0.000001
     }
     
#include "macro_coil.inc"
#declare cord_coil_A = 
object { 
    coil (2,.2,10,8,"plotCoil") 
    material {M_metal_chrome} 
    }

#declare cord_coil_B = 
object { 
    coil (2,.2,5,1,"plotCoil") 
    material {M_metal_chrome} 
    }
    
#declare gun_cord =
union {
    union {   
        object {cord_coil_A  rotate <-90,0,0> } 
        object {cord_coil_B  rotate <-90,0,-90>  translate <0,0,-15.5>} 
        rotate <0,-5,0>
        translate <42,0,-44>
    }
    //object {gun_cord_base}
    object {gun_cord_sweep translate <0,.4,0>}
    object {gun_cord_sweep translate <0,-.4,0>} 
    material {M_black_rubber}
} 


// -----------------------------------------------------------------------------------------
//                     L A B E L
//------------------------------------------------------------------------------------------

#declare imgDiffuse = "weller_label.png" 


#declare M_sg_label =
material {
    texture {
       pigment { 
            image_map {
                png imgDiffuse     
                map_type 0
                interpolate 4 
                }
      }
   
     finish { 
        F_satin 
     } 

    } 
    rotate <90,0,0> 
    scale <14,1,2.2>   
    translate <7,1,1> 
}

#declare gun_label =
#declare rad = .05 ;
union { 
    #declare sc = <14.000, 0.13, 2.2> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) material {M_sg_label} scale <2,2,2>  translate <16.000, 0.000, 2.800> }
    scale <1,.1,1>
    translate <3, 5.5, 11.6> 
      }
      

// -----------------------------------------------------------------------------------------
//                     C O M P L E T E   S O L D E R I N G   G U N
//------------------------------------------------------------------------------------------
                  
#declare solder_gun = 
union {
    object {sg_body_A } 
    object {sg_rods} 
    object {gun_label}
    object {gun_tip}
    object {gun_solder_tip}
    object {gun_bulb}
    object {gun_cord} 
}     

      



// -----------------------------------------------------------------------------------------
//                     U N D E R L A Y
//------------------------------------------------------------------------------------------

/*
#declare imgDiffuse = "soldering_iron_underlay.jpg" 


#declare M_sg_underlay =
material {
    texture {
       pigment { 
            image_map {
                jpeg imgDiffuse     
                map_type 0
                interpolate 4 
                }
      }
   
     finish { 
        F_flat 
             emission .2
     } 

    } 
    rotate <90,0,0> 
    scale <100,1,100> 
    translate <-50,0,-50>  
}
*/  