// -----------------------------------------------------------------------------------------
//                      R O O M
//------------------------------------------------------------------------------------------


#declare imgDiffuse = "cmu_block_diffuse.jpg" 
#declare imgBump = "cmu_block_bump.jpg"

#declare M_cmu_block =
material {
    texture {
       pigment { 
            image_map {
                jpeg imgDiffuse     
                map_type 0
                interpolate 4 
                }
      }
   
     finish { 
        F_satin
     }
     
    normal  {
        bump_map {
            jpeg imgBump 
            map_type 0
            interpolate 4 
        } 
        bump_size 1
    }
        
    }
    
    
    scale <1200,800,1200> 
    //rotate x*90
    translate <-600,0,0>  
}

#declare imgDiffuse = "concrete_floor_diffuse.jpg" 
#declare imgBump = "concrete_floor_bump.jpg"

#declare M_concrete_floor =
material {
    texture {
       pigment { 
            image_map {
                jpeg imgDiffuse     
                map_type 0
                interpolate 4 
                }
      }
   
     finish { 
        F_concrete_smooth
     }
     
    normal  {
        bump_map {
            jpeg imgBump 
            map_type 0
            interpolate 4 
        } 
        bump_size 1
    }
        
    }
    
    
    scale <1200,1200,1200> 
    rotate x*90
    translate <-600,0,0>  
}



#declare beams =
#declare rad = 1 ;
union { 
    #declare sc = <12.000, 43.344, 473.973> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-561.271, 756.580, -370.678> } 
    #declare sc = <12.000, 43.344, 473.973> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-421.271, 756.580, -370.678> } 
    #declare sc = <12.000, 43.344, 473.973> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-281.271, 756.580, -370.678> } 
    #declare sc = <12.000, 43.344, 473.973> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-141.271, 756.580, -370.678> } 
    #declare sc = <12.000, 43.344, 473.973> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-1.271, 756.580, -370.678> } 
    #declare sc = <12.000, 43.344, 473.973> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <138.728, 756.580, -370.678> } 
    #declare sc = <12.000, 43.344, 473.973> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <278.728, 756.580, -370.678> } 
    #declare sc = <12.000, 43.344, 473.973> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <418.728, 756.580, -370.678> } 
    #declare sc = <12.000, 43.344, 473.973> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <558.728, 756.580, -370.678> }
   material {M_old_wall}
      }


#declare work_floor =
#declare rad = .25 ;
object {
    #declare sc = <600.000, 0.500, 400.000> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 0.000, -400.000> } 
    material {M_concrete_floor}
}

#declare work_ceiling =
#declare rad = .25 ;
object {
    #declare sc = <600.000, 0.500, 400.000> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 800, -400.000> } 
    material {M_old_wall}
}

#declare wall = 
union { 
    difference { 
        //---wall
        #declare rad = 1 ;
        #declare sc = <600.000, 400.000, 24.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-0.000, 400.000, 25.00> } 
        
        //---window cut
        #declare rad = 1 ;
        #declare sc = <100.000, 50, 100> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <400.000, 600.000, 0.000> } 
       // material {M_old_wall}
       material {M_cmu_block}
    }  
}


#declare cmu =
#declare rad = 1 ; 
difference {
    union { 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-534.707, 33.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-399.707, 33.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-264.707, 33.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-129.707, 33.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <5.292, 33.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <140.292, 33.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <275.292, 33.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <410.292, 33.510, -0.999> } 
        #declare sc = <58.853, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <539.630, 33.510, -0.999> } 
        #declare sc = <27.270, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <569.866, 103.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <472.356, 103.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <337.356, 103.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <202.356, 103.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <67.356, 103.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-67.643, 103.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-202.643, 103.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-337.643, 103.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-472.643, 103.510, -0.999> } 
        #declare sc = <27.993, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-570.404, 103.510, -0.999> } 
        #declare sc = <27.993, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-570.404, 243.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-472.643, 243.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-337.643, 243.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-202.643, 243.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-67.643, 243.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <67.356, 243.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <202.356, 243.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <337.356, 243.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <472.356, 243.510, -0.999> } 
        #declare sc = <27.270, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <569.866, 243.510, -0.999> } 
        #declare sc = <58.853, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <539.630, 173.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <410.292, 173.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <275.292, 173.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <140.292, 173.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <5.292, 173.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-129.707, 173.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-264.707, 173.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-399.707, 173.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-534.707, 173.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-534.707, 313.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-399.707, 313.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-264.707, 313.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-129.707, 313.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <5.292, 313.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <140.292, 313.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <275.292, 313.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <410.292, 313.510, -0.999> } 
        #declare sc = <58.853, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <539.630, 313.510, -0.999> } 
        #declare sc = <27.270, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <569.866, 383.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <472.356, 383.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <337.356, 383.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <202.356, 383.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <67.356, 383.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-67.643, 383.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-202.643, 383.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-337.643, 383.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-472.643, 383.510, -0.999> } 
        #declare sc = <27.993, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-570.404, 383.510, -0.999> } 
        #declare sc = <27.993, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-570.404, 523.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-472.643, 523.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-337.643, 523.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-202.643, 523.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-67.643, 523.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <67.356, 523.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <202.356, 523.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <337.356, 523.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <472.356, 523.510, -0.999> } 
        #declare sc = <27.270, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <569.866, 523.510, -0.999> } 
        #declare sc = <58.853, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <539.630, 453.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <410.292, 453.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <275.292, 453.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <140.292, 453.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <5.292, 453.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-129.707, 453.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-264.707, 453.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-399.707, 453.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-534.707, 453.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-534.707, 593.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-399.707, 593.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-264.707, 593.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-129.707, 593.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <5.292, 593.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <140.292, 593.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <275.292, 593.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <410.292, 593.510, -0.999> } 
        #declare sc = <58.853, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <539.630, 593.510, -0.999> } 
        #declare sc = <27.270, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <569.866, 663.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <472.356, 663.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <337.356, 663.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <202.356, 663.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <67.356, 663.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-67.643, 663.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-202.643, 663.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-337.643, 663.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-472.643, 663.510, -0.999> } 
        #declare sc = <27.993, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-570.404, 663.510, -0.999> } 
        #declare sc = <27.993, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-570.404, 803.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-472.643, 803.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-337.643, 803.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-202.643, 803.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-67.643, 803.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <67.356, 803.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <202.356, 803.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <337.356, 803.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <472.356, 803.510, -0.999> } 
        #declare sc = <27.270, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <569.866, 803.510, -0.999> } 
        #declare sc = <58.853, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <539.630, 733.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <410.292, 733.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <275.292, 733.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <140.292, 733.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <5.292, 733.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-129.707, 733.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-264.707, 733.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-399.707, 733.510, -0.999> } 
        #declare sc = <65.000, 33.000, 1.000> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <-534.707, 733.510, -0.999> } 
        translate <0,0,2>
         }
        #declare rad = 1 ;
        #declare sc = <100.000, 50, 100> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <400.000, 600.000, 0.000> } 
        material {M_cmu_block}
}




#declare wall_trim =
#declare rad = 3 ;
union { 
    #declare sc = <600.000, 25.000, 4.000> ;
    object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <0, 20, -4.199> } 
    material {M_old_trim}
      }                  
      
      

#declare window_frame =
#declare rad = .25 ; 
union {
    union { 
        #declare sc = <-100.000, -6.048, -10.071> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <400.000, 556.086, 24.602> } 
        #declare sc = <-100.000, -6.048, -10.071> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <400.000, 644.348, 24.602> } 
        #declare sc = <-6.410, -38.163, -10.071> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <306.435, 600.280, 24.602> } 
        #declare sc = <-6.410, -38.013, -10.071> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <493.563, 600.269, 24.602> } 
        #declare sc = <-6.037, -33.442, -1.206> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <488.124, 600.263, 21.978> } 
        #declare sc = <-6.037, -33.574, -1.206> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <311.873, 600.273, 21.978> } 
        #declare sc = <-94.187, -5.321, -1.206> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <399.999, 639.041, 21.978> } 
        #declare sc = <-94.187, -5.321, -1.206> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <399.999, 561.392, 21.978> } 
        #declare sc = <-94.187, -5.321, -1.206> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <399.999, 561.392, 26.736> } 
        #declare sc = <-94.187, -5.321, -1.206> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <399.999, 639.041, 26.736> } 
        #declare sc = <-6.037, -33.574, -1.206> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <311.873, 600.273, 26.736> } 
        #declare sc = <-6.037, -33.442, -1.206> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <488.124, 600.263, 26.736> } 
        }
        //---glass
        #declare rad = .25 ;
        #declare sc = <-84.385, -35.039, -1.206> ;
        object { Round_Box(<-.5,-.5,-.5> * sc, <.5,.5,.5> *sc, rad , 0) scale <2,2,2> translate <399.804, 600.273, 24.328> material {M_glass} } 
}

#declare wall_components =
union {
    object { wall          }
    object { window_frame  }
    object { cmu           }
    object { wall_trim     }
}      


#declare room =
object {
    union {        
        object { wall_components }
        object { wall_components scale <-1,1,1> rotate <0,-90,0> translate <-600,0,-590> }
        object { beams           }
        object { work_floor      }
        object { work_ceiling    }

        }
}        