// convert x3d
// m.miller 03.09.2023

#include "shapes.inc"
#include "shapes2.inc"


// -----------------------------------------------------------------------------------------
//                      M A T E R I A L S
//------------------------------------------------------------------------------------------ 


//--- C O L O R S
#ifndef (Transparent) #declare Transparent = rgbt 1 ;#end
#declare C_white =          color rgb<1,1,1>  ;
#declare C_black =          color rgb<0,0,0>  ;
#declare C_red =            color rgb<1,0,0>  ;  
#declare C_red_dark =       color rgb<.9,0,0>  ;
#declare C_green =          color rgb<0,1,0>  ;
#declare C_blue =           color rgb<0,.5,.9>  ;
#declare C_orange =         color rgb<1,1,0>  ;
#declare C_copper =         color rgb <0.40, 0.20, 0.15>;  
#declare C_silver =         color rgb <0.85, 0.85, 0.8>;   
#declare C_gold =           color red 0.82 green 0.6 blue 0.196078;
#declare C_gold_bright=     color <0.90, 0.65, 0.15>;
#declare C_light_blue =     color red 0.6 green 0.8 blue 1; 
#declare C_horizon_blue =   color red .82 green 1 blue .98; 
#declare C_light_green =    color rgb<.75,1,.9>  ;
#declare C_gray10 =         color red 0.1 green 0.1 blue 0.1;   
#declare C_gray20 =         color red 0.2 green 0.2 blue 0.2;
#declare C_gray30 =         color red 0.3 green 0.3 blue 0.3; 
#declare C_gray40 =         color red 0.4 green 0.4 blue 0.4;
#declare C_gray50 =         color red 0.5 green 0.5 blue 0.5;
#declare C_gray60 =         color red 0.6 green 0.6 blue 0.6; 
#declare C_gray70 =         color red 0.7 green 0.7 blue 0.7;   
#declare C_gray80 =         color red 0.8 green 0.8 blue 0.8; 
#declare C_gray90 =         color red 0.9 green 0.9 blue 0.9;
#declare C_tan =            color red 0.85 green 0.66 blue 0.5;
#declare C_tan_dark =       color red 0.66 green 0.5 blue 0.4;


#declare F_soft_metal =
finish {
    ambient 0
    diffuse 1   
    phong 1
    phong_size 70  
    metallic
    reflection {.01, .7 fresnel}
}



#declare F_gloss =
finish {
    ambient .2
    diffuse 1   
    phong 1
    phong_size 100  
    reflection {.01, .52 fresnel}
}


#declare F_glossy =
finish {
    ambient .2
    diffuse 1   
    phong 1
    phong_size 60  
    reflection {.001, .1 fresnel}
}
      
#declare F_metal_hard =
finish {
    conserve_energy 
    brilliance 5
    ambient .2
    diffuse 1 
    phong 20    
    phong_size 50
    metallic
    specular 10
    roughness 1/20
    reflection {0.01, .7 fresnel on } 
}   



#declare F_metal_dull  =
finish {
     reflection {.3, 1 fresnel on } 
     conserve_energy 
     brilliance 5   
     ambient 1
     diffuse 1
     phong .1    
     phong_size 200   
     metallic 1
     specular .8 
     roughness .1  
     reflection .15  
}


#declare F_metal_hard  =
finish {  
    reflection {.01, 1 fresnel on } 
    conserve_energy 
    brilliance 5
    ambient 0
    brilliance 5
    diffuse 1 
    phong 2    
    phong_size 100
    metallic
    specular 1 
    roughness 1/100
    reflection .2
} 

#declare F_metal_hard2  =
finish {  
    reflection {.01, 1 fresnel on } 
    conserve_energy 
    brilliance 5
    ambient .1
    brilliance 5
    diffuse 1 
    phong 2    
    phong_size 100
    metallic
    specular 1 
    roughness .2
    reflection .1
}

#declare F_metal_polished  =
finish {
    reflection {0, 1 fresnel on }
    conserve_energy 
    brilliance 5
    ambient 0
    diffuse .5 
    phong 5    
    phong_size 40
    metallic
    specular .4
    roughness 1/20
    reflection .5   
}


#declare F_metal_polished  =
finish {
    reflection {0, 1 fresnel on }
    conserve_energy 
    brilliance 5
    ambient 0
    diffuse .5 
    phong 5    
    phong_size 40
    metallic
    specular .4
    roughness 1/20
    reflection .5   
}






//--- T E X T U R E S   G R A Y 
#declare T_black = texture{ pigment{ rgb C_black transmit 0 }}
#declare T_gray10 = texture{ pigment{ rgb C_gray50 transmit 0 }}
#declare T_gray20 = texture{ pigment{ rgb C_gray50 transmit 0 }}
#declare T_gray30 = texture{ pigment{ rgb C_gray50 transmit 0 }}
#declare T_gray40 = texture{ pigment{ rgb C_gray50 transmit 0 }}
#declare T_gray50 = texture{ pigment{ rgb C_gray50 transmit 0 }}
#declare T_gray60 = texture{ pigment{ rgb C_gray60 transmit 0 }}  
#declare T_gray70 = texture{ pigment{ rgb C_gray70 transmit 0 }}
#declare T_gray80 = texture{ pigment{ rgb C_gray80 transmit 0 }}
#declare T_white = texture{ pigment{ rgb C_white transmit 0 }}  
#declare T_tan = texture{ pigment{ rgb C_tan transmit 0 }}   
#declare T_tan_dark = texture{ pigment{ rgb C_tan_dark transmit 0 }}  
#declare T_red = texture{ pigment{ rgb C_red transmit 0 }}   

#declare T_gold = texture{ pigment{ rgb C_gold transmit 0 }} 
#declare T_gold_bright = texture{ pigment{ rgb C_gold_bright transmit 0 }} 

// metals
#declare M_metal_alum = material{ texture{ T_gray80   finish{F_metal_dull}}  }
#declare M_metal_steel = material{ texture{ T_gray70   finish{F_metal_hard}} } 
#declare M_metal_chrome = material{ texture{ T_gray80   finish{F_metal_polished}}  }
#declare M_metal_gold = material{ texture{ T_gold   finish{F_metal_polished}} }
#declare M_metal_gold_bright = material{ texture{ T_gold_bright   finish{F_metal_polished}}  } 


#declare M_default =
material {
    texture {
        pigment { C_gray70 }
        finish  { F_soft_metal }
   }
}



#declare imgDiffuse = "box_deco_diffuse.png" 
#declare imgBump = "box_deco_bump.png"

#declare M_box_deco_panel =
material {
    texture {
       pigment { 
            image_map {
                png imgDiffuse     
                map_type 0
                interpolate 4 
                }
      }
   
     finish { 
        F_glossy
     }
     
    normal  {
        bump_map {
            png imgBump 
            map_type 0
            interpolate 4 
        } 
        bump_size .08 
    }
        
    }
    rotate y*180 
    scale <98,98,1> 
    translate <-49,1,0>  
}



#declare frame_corners =
#declare rad = .5 ;
union { 
    #declare sc = <3.000, 3.000, 3.000> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-47.000, 3.000 - 3.000,-47.000> } 
    #declare sc = <3.000, 3.000, 3.000> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <47.000, 3.000 - 3.000,-47.000> } 
    #declare sc = <44.000, 3.000, 3.000> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <0.000, 3.000 - 3.000,-47.000> } 
    #declare sc = <3.000, 3.000, 44.000> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <47.000, 97.000 - 3.000,0.000> } 
    #declare sc = <3.000, 3.000, 44.000> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <47.000, 3.000 - 3.000,0.000> } 
    #declare sc = <3.000, 3.000, 44.000> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-47.000, 3.000 - 3.000,0.000> } 
    #declare sc = <3.000, 3.000, 44.000> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-47.000, 97.000 - 3.000,0.000> } 
    #declare sc = <44.000, 3.000, 3.000> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <0.000, 97.000 - 3.000,-47.000> } 
    #declare sc = <3.000, 3.000, 3.000> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <47.000, 97.000 - 3.000,-47.000> } 
    #declare sc = <3.000, 3.000, 3.000> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-47.000, 97.000 - 3.000,-47.000> } 
    #declare sc = <3.000, 44.000, 3.000> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <47.000, 50.000 - 44.000,-47.000> } 
    #declare sc = <3.000, 44.000, 3.000> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-47.000, 50.000 - 44.000,-47.000> } 
    #declare sc = <3.000, 44.000, 3.000> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-47.000, 50.000 - 44.000,47.000> } 
    #declare sc = <3.000, 44.000, 3.000> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <47.000, 50.000 - 44.000,47.000> } 
    #declare sc = <3.000, 3.000, 3.000> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-47.000, 97.000 - 3.000,47.000> } 
    #declare sc = <3.000, 3.000, 3.000> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <47.000, 97.000 - 3.000,47.000> } 
    #declare sc = <44.000, 3.000, 3.000> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <0.000, 3.000 - 3.000,47.000> } 
    #declare sc = <44.000, 3.000, 3.000> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <0.000, 97.000 - 3.000,47.000> } 
    #declare sc = <3.000, 3.000, 3.000> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <47.000, 3.000 - 3.000,47.000> } 
    #declare sc = <3.000, 3.000, 3.000> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-47.000, 3.000 - 3.000,47.000> } 
    material {M_metal_gold_bright}
    }

#declare box_door_stop =
difference {
    #declare rad = .5 ;
    union { 
        #declare sc = <1.000, 3.000, 44.000> ;
        object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-46.288, 9.000 - 3.000,0.000> } 
        #declare sc = <1.000, 3.000, 44.000> ;
        object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-46.288, 91.000 - 3.000,0.000> } 
        #declare sc = <1.000, 38.000, 3.000> ;
        object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-46.288, 50.000 - 38.000,41.000> } 
        #declare sc = <1.000, 38.000, 3.000> ;
        object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-46.288, 50.000 - 38.000,-41.000> } 
        #declare sc = <0.500, 3.000, 3.000> ;
        object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-45.768, 85.000 - 3.000,35.000> } 
        #declare sc = <0.500, 3.000, 3.000> ;
        object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-45.768, 85.000 - 3.000,-35.000> } 
        #declare sc = <0.500, 3.000, 3.000> ;
        object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-45.768, 15.000 - 3.000,-35.000> } 
        #declare sc = <0.500, 3.000, 3.000> ;
        object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <-45.768, 15.000 - 3.000,35.000> } 
    }
    cylinder { <-60,0,0>,<0,0,0>, 1 translate <0, 85, 35>  }
    cylinder { <-60,0,0>,<0,0,0>, 1 translate <0, 85, -35> }
    cylinder { <-60,0,0>,<0,0,0>, 1 translate <0, 15, 35>  }
    cylinder { <-60,0,0>,<0,0,0>, 1 translate <0, 15, -35>  }
      
}  
      
      
#declare box_top_bottom =
#declare rad = 1 ;
union { 
    #declare sc = <44.000, 2.000, 44.000> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <0.000, 97.000 - 2.000,0.000> } 
    #declare sc = <44.000, 2.000, 44.000> ;
    object { Round_Box(<-1,0,-1> * sc, <1,2,1> *sc, rad , 0) translate <0.000, 0.179 - 2.000,0.000> } 
    material {M_metal_gold_bright}
    }
           



//Round_Cone( point A, radius A, point B, radius B, rounding radius, merge on)
#declare panel_detail_A =
object{ 
    Round_Cone( 
        <0,0,0>, 14,
        <0,3,0>, 11 , 0.5, 0)  
        scale<1,1,1>  rotate<-90,0,0> 
       } 


#declare panel_detail_B =
object{ 
    Round_Cone( 
        <0,0,0>, 6,
        <0,2,0>, 4 , 0.5, 0)  
        scale<1,1,1>  rotate<-90,0,0> 
       }

#declare panel_detail_C = 
object{
    sphere {<0,0,0>, 2.18 }
}


#declare deco_panel =  
union {
    union {
        box { <-49.00, 1, 0>, < 49.00, 99, 1> scale <1,1,1> translate<0,0,0> }
        object { panel_detail_A translate <0,50,.5>     }      //center    
        object { panel_detail_B translate <-34.2,50,.5> }      //left 
        object { panel_detail_B translate <34.2,50,.5>  }      //right
        object { panel_detail_B translate <0,84.2,.5>   }      //top 
        object { panel_detail_B translate <0,15.5,.5>  }      //bottom 
        material {M_box_deco_panel} 
    }
    
    union {
        object { panel_detail_C translate <-17.5,50,.5>  }      //left
        object { panel_detail_C translate < 17.5,50,.5>  }      //right
        object { panel_detail_C translate < 0,67.5,.5>  }      //left
        object { panel_detail_C translate < 0,32.5,.5>  }      //right 
        material {M_metal_gold_bright}
    }
    

}


#declare box_leg =  
union { 
    union {
        sphere_sweep {
             cubic_spline
             13,
             <5.273, 6.701, 1.466> , 0.764
             <5.273, 6.701, 1.466> , 0.764
             <4.583, 8.226, 1.480> , 0.886
             <3.243, 9.464, 1.387> , 1.141
             <2.439, 10.551, 1.324> , 1.395
             <3.100, 13.395, 1.607> , 1.472
             <4.120, 16.488, 1.895> , 1.756
             <5.714, 20.289, 2.985> , 1.852
             <7.385, 24.535, 4.115> , 2.368
             <6.845, 29.487, 5.492> , 2.837
             <2.656, 34.048, 6.480> , 3.551
             <-3.693, 37.329, 6.792> , 4.229
             <-3.693, 37.329, 6.792> , 4.229
             tolerance 0.000001
             }
                 
        sphere_sweep {
             cubic_spline
             13,
             <0.000, 38.588, 0.000> , 6.935
             <0.000, 38.588, 0.000> , 6.935
             <6.314, 34.217, 0.000> , 5.988
             <8.130, 29.657, 0.000> , 5.087
             <7.385, 24.535, 0.000> , 3.929
             <5.714, 20.289, 0.000> , 2.731
             <4.120, 16.488, 0.000> , 2.034
             <3.100, 13.395, 0.000> , 1.472
             <2.439, 10.551, 0.000> , 1.395
             <3.243, 9.464, 0.000> , 1.141
             <4.583, 8.226, 0.000> , 0.886
             <5.273, 6.701, 0.000> , 0.764
             <5.273, 6.701, 0.000> , 0.764
             tolerance 0.000001
             }
             
             
        sphere_sweep {
             cubic_spline
             13,
             <5.273, 6.701, -1.466> , 0.764
             <5.273, 6.701, -1.466> , 0.764
             <4.583, 8.226, -1.480> , 0.886
             <3.243, 9.464, -1.387> , 1.141
             <2.439, 10.551, -1.324> , 1.395
             <3.100, 13.395, -1.607> , 1.472
             <4.120, 16.488, -1.895> , 1.756
             <5.714, 20.289, -2.985> , 1.852
             <7.385, 24.535, -4.115> , 2.368
             <6.845, 29.487, -5.492> , 2.837
             <2.656, 34.048, -6.480> , 3.551
             <-3.693, 37.329, -6.792> , 4.229
             <-3.693, 37.329, -6.792> , 4.229
             tolerance 0.000001
             }    
    scale <1,1,.75>
    }     
    sphere {<0,0,0>,5.25 translate <-.5,5.25,0>}
  
} 

#declare jack_box = 
union {
    union {
        object { deco_panel scale <1,1,-1> translate <0,0,49>} 
        object { deco_panel scale <1,1,1> translate <0,0,-49>}
        object { deco_panel scale <1,1,1> rotate <0,-90,0>translate <49,0,0>}
        object { box_door_stop material {M_metal_gold_bright} }
        object { frame_corners }
        object { box_top_bottom }
        translate <0,35,0>     
    }
    union {
        object { box_leg rotate <0,135,0> translate <-48,0,-48>}  
        object { box_leg rotate <0,35,0> translate < 48,0,-48>} 
        
        object { box_leg rotate <0,-135,0> translate <-48,0,48>}  
        object { box_leg rotate <0,-35,0> translate < 48,0,48>}
        
        material {M_metal_gold_bright} 
    }
}    
    
    
    