

// -----------------------------------------------------------------------------------------
//                      M A T E R I A L S
//------------------------------------------------------------------------------------------ 


//--- C O L O R S
#declare C_white =          color rgb<1,1,1>  ;
#declare C_black =          color rgb<0,0,0>  ;
#declare C_red =            color rgb<1,0,0>  ;  
#declare C_red_dark =       color rgb<.5,0,0>  ; 
#declare C_maroon =         color rgb<.45,.02,.02>  ;
#declare C_green =          color rgb<0,1,0>  ;
#declare C_blue =           color rgb<0,.5,.9>  ;
#declare C_orange =         color rgb<1,1,0>  ;
#declare C_copper =         color rgb <0.40, 0.20, 0.15>;  
#declare C_silver =         color rgb <0.85, 0.85, 0.8>;   
#declare C_gold =           color red 0.82 green 0.6 blue 0.196078;
#declare C_gold_bright=     color <0.90, 0.65, 0.15>;
#declare C_light_blue =     color red 0.6 green 0.8 blue 1; 
#declare C_horizon_blue =   color red .82 green 1 blue .98; 
#declare C_light_green =    color rgb<.75,1,.9>  ;  
#declare C_gray5 =          color red 0.05 green 0.05 blue 0.05;
#declare C_gray10 =         color red 0.1 green 0.1 blue 0.1;   
#declare C_gray20 =         color red 0.2 green 0.2 blue 0.2;
#declare C_gray30 =         color red 0.3 green 0.3 blue 0.3; 
#declare C_gray40 =         color red 0.4 green 0.4 blue 0.4;
#declare C_gray50 =         color red 0.5 green 0.5 blue 0.5;
#declare C_gray60 =         color red 0.6 green 0.6 blue 0.6; 
#declare C_gray70 =         color red 0.7 green 0.7 blue 0.7;   
#declare C_gray80 =         color red 0.8 green 0.8 blue 0.8; 
#declare C_gray90 =         color red 0.9 green 0.9 blue 0.9;
#declare C_tan =            color red 0.85 green 0.66 blue 0.5;
#declare C_tan_dark =       color red 0.66 green 0.5 blue 0.4;

                   
#declare F_soft_plastic =
finish {
    ambient .3
    diffuse 1   
    phong 1
    phong_size 20 
    reflection {.001, .1 fresnel} 
}                      




#declare F_concrete_smooth =
finish {
    ambient .3
    diffuse 1   
    phong 1
    phong_size 60 
    reflection {.01, .5 fresnel} 
} 


#declare F_rubber =
finish {
    ambient .2
    diffuse 1   
    phong .5
    phong_size 20  
}


#declare F_flat =
finish {
    ambient 0
    diffuse 1   
    phong .1
    phong_size 20  
} 

#declare F_gloss =
finish {
    ambient .2
    diffuse 1   
    phong 1
    phong_size 100  
    reflection {.01, .72 fresnel}
}
      
#declare F_satin =
finish {
    ambient .2
    diffuse 1   
    phong .5
    phong_size 40  
}

#declare F_metal_dull  =
finish {
     reflection {.3, 1 fresnel on } 
     conserve_energy 
     brilliance 5   
     ambient 1
     diffuse 1
     phong .1    
     phong_size 60   
     metallic 1
     specular .8 
     roughness .05  
     reflection .15  
}




#declare F_metal_polished  =
finish {
    reflection {0, 1 fresnel on }
    conserve_energy 
    brilliance 5
    ambient 0
    diffuse .5 
    phong 5    
    phong_size 40
    metallic
    specular .4
    roughness 1/20
    reflection .5   
}



#declare F_glass_cover =
     finish {
     reflection {0, .5 fresnel on } 
     conserve_energy 
     ambient 0
     diffuse .5 
     phong 5     
     phong_size 100   
     metallic 0
     specular .25 
     roughness 1/10  
     diffuse 1
}


#declare F_glow =
    finish {
    ambient 1
    emission 5
    } 
    


     
#declare F_plastic_gloss2 =    
    finish {
    reflection {.03, .2 fresnel on } 
    conserve_energy 
    brilliance 1
    ambient .1
    diffuse .5 
    phong 5    
    phong_size 80
    specular .3 
    roughness .05

    }
    
     

//--- T E X T U R E S   G R A Y 


#declare T_gray80 = texture{ pigment{ rgb C_gray80 transmit 0 }}

#declare M_metal_chrome = material{ texture{ T_gray80   finish{F_metal_polished}}  }
 



#declare M_metal_chrome = 
material{ 
    texture{ 
        pigment{ color red 0.8 green 0.8 blue 0.8 }   
        finish{ F_metal_polished }
     } 
}


#declare C_map_old_copper =
    color_map {
        [ 0.0  C_copper *.83]  
        [ 0.3  C_copper *.83]
        [ 0.5  C_gray60 *.63]
        [ 0.8  C_copper *.63] 
        [ 1    C_copper *.83]
        }
        
        
#declare M_old_copper =
material {
    texture {
        pigment {
            bozo 
            color_map {C_map_old_copper }
        } 
       finish { F_metal_dull }
    }  
}      
        


#declare T_glass =
texture {
    pigment{ rgbf <0.0, 0.0, 0,1, 0.9> }
    finish {
        reflection {0.3, 1 fresnel}
        conserve_energy
    }
} 

#declare I_glass =
interior {
    ior 1.33
}

#declare N_crackle_A =
normal { 
    pigment_pattern{ 
        crackle 
        turbulence 0.2
        colour_map {[0.00, rgb 0]
                    [0.25, rgb 1]
                    [0.95, rgb 1]
                    [1.00, rgb 0]
                    } 
     }
} 

#declare N_leopard_A =
normal { 
    pigment_pattern{ 
        leopard 
        turbulence 0.2
        colour_map {[0.00, rgb 0] 
                    [0.5, rgb 0]
                    [0.6, rgb 1]
                    [0.9, rgb 1]
                    [1.00, rgb 0]
                    } 
     }
} 

#declare N_granite_A =
normal { 
    pigment_pattern{ 
        granite 
        turbulence 0.2
        colour_map {[0.00, rgb 1] 
                    [0.5, rgb 1]
                    [0.7, rgb 0]
                    [0.9, rgb 0]
                    [1.00, rgb 1]
                    } 
     } 
     bump_size .02
} 


#declare N_ripple_A = normal { bozo 0.2 scale 0.2 }  
#declare N_ripple_large = normal{N_ripple_A scale 10 bump_size 5}
#declare N_small_bumps = normal { leopard bump_size 10 scale 1 warp { turbulence 1 }}
#declare N_granite = normal { granite 1 bump_size 1 scale 1 warp { turbulence .5 }} 
#declare N_leopard = normal { leopard bump_size 9 scale .5 warp { turbulence 6 }} 
#declare N_mud_bozo = normal { bozo bump_size 5 scale 1 warp { turbulence 3 }} 
#declare N_mud_wrinkles = normal { wrinkles bump_size 2 scale 1 warp { turbulence 3 }} 
#declare N_crackle = normal { crackle bump_size .1 scale 1 warp { turbulence 1 }}  
#declare N_mud_agate = normal { agate bump_size 2 scale 1 warp { turbulence 1 }} 


// -----------------------------------------------------------------------------------------
//                      M I S C   M A T E R I A L S
//------------------------------------------------------------------------------------------

#declare M_sg_maroon_gloss =
material {
    texture {
       pigment { C_maroon }
       finish { F_gloss }
   }
}

#declare M_glass =
material {
    texture {T_glass}
    interior {I_glass}
}



#declare M_black_rubber =
material {
    texture {
       pigment { C_black }
       finish { F_rubber }
   }
}

    

#declare M_white_glow = 
material{ 
    texture{ 
        pigment {C_white} 
        finish {F_glow} 
        } 
}



#declare M_old_trim = 
material{ 
    texture{ 
        pigment {C_horizon_blue *.2} 
        finish {F_soft_plastic}
        normal {N_granite_A scale <10,7,10> }
        } 
}


#declare M_old_trim_tan = 
material{ 
    texture{ 
        pigment {C_tan *1.5} 
        finish {F_soft_plastic}
        normal {N_granite_A scale <10,7,10> }
        } 
}


#declare M_old_wall = 
material{ 
    texture{ 
        pigment {C_tan} 
        finish {F_soft_plastic}
        normal {N_granite_A scale <20,20,20> }
        } 
}

#declare M_old_wall_light_tan = 
material{ 
    texture{ 
        pigment {C_tan*2} 
        finish {F_soft_plastic}
        normal {N_granite_A scale <20,20,20> }
        } 
}

#declare M_gold_glow = 
material{ 
    texture{ 
        pigment {C_gold} 
        finish {F_glow}
        } 
}  

#declare M_white_glow = 
material{ 
    texture{ 
        pigment {C_white} 
        finish {F_glow}
        } 
}

#declare M_black_glow = 
material{ 
    texture{ 
        pigment {C_black} 
        finish {F_glow}
        } 
}


#declare M_old_floor = 
material{ 
    texture{ 
        pigment {C_tan*.4} 
        finish {F_concrete_smooth}
        normal {N_granite_A scale <50,50,50> }
        } 
}