// solder gun
// m.miller 04.10.23

#version 3.8; 
global_settings {    
    max_trace_level 7
    ambient_light <.01,.01,.01> * .1                  
}                        



// -----------------------------------------------------------------------------------------
//                      I N C L U D E S
//------------------------------------------------------------------------------------------ 
#include "camera_rigs.inc" 
#include "materials.inc"
#include "shapes3.inc"

// -----------------------------------------------------------------------------------------
//                      S K Y
//------------------------------------------------------------------------------------------ 
background { rgb <0.12, 0.11, 0.1> * .5 } 
#include "sky.inc"
bg_sphere (<5000,5000,5000>, <0,1600,0>, -150) 

// -----------------------------------------------------------------------------------------
//                      L I G H T S
//------------------------------------------------------------------------------------------ 

#declare array_count = 8    ;

// --- S K Y  L I G H T
#declare light_A =
light_source {
    <0,0,0> 
    #declare light_color = color red .05 green .05 blue .05 ;                      
    light_color * 20                  
    area_light
    <5, 0, 0> <0, 0, 5>         
    array_count, array_count                          
    adaptive 0                    
    jitter                        
    circular                      
    orient                     
    fade_distance 120
    fade_power 3     
    translate <-130, 80, 50>
}   
light_A

// --- B A C K   L I G H T
#declare light_B =
light_source {
    <0,0,0> 
    #declare light_color = color red .05 green .06 blue .06 ;                      
    light_color * 3                   
    area_light
    <5, 0, 0> <0, 0, 5>         
    array_count, array_count                          
    adaptive 0                    
    jitter                        
    circular                      
    orient                     
    fade_distance 200
    fade_power 3     
    translate <250, 100, 220>
}   
light_B

// --- U N D E R  L I G H T
#declare light_C =
light_source {
    <0,0,0> 
    #declare light_color = color red .03 green .04 blue .05 ;                      
    light_color * 7                   
    area_light
    <50, 0, 0> <0, 0, 50>         
    array_count, array_count                          
    adaptive 0                    
    jitter                        
    circular                      
    orient                        
    translate <10, -100, -150>
}   
light_C


// -----------------------------------------------------------------------------------------
//                      S O L D E R   G U N 
//------------------------------------------------------------------------------------------
#include "solder_gun.inc"
object { solder_gun translate <0,8,0> }


// -----------------------------------------------------------------------------------------
//                     U N D E R L A Y
//------------------------------------------------------------------------------------------

//object { sg_underlay material {M_sg_underlay} translate <0,1,0>}
//object { sg_underlay material {M_sg_underlay} rotate <-90,0,0> translate <0,50,50>}


// -----------------------------------------------------------------------------------------
//                      M A R K E R S
//------------------------------------------------------------------------------------------

#declare mbox = box { <-.5, 0.00, -.5>, <.5, 1.00, .5> }  ;
#declare markers =
union { 
   // object { mbox scale <5,20,5>  translate <-0,0,0> }
    object { mbox scale <2,100,2> translate <-50,0,-50> }
    object { mbox scale <2,100,2> translate <-50,0,50>  }
    object { mbox scale <2,100,2> translate <50,0,-50>  }
    object { mbox scale <2,100,2> translate <50,0,50>   }
}

//markers



// -----------------------------------------------------------------------------------------
//                      G R O U N D   P L A N E
//------------------------------------------------------------------------------------------
object { plane {<0,1,0> 0 } material {M_default_floor} translate <0,4,0> no_shadow}



// -----------------------------------------------------------------------------------------
//                      C A M E R A S
//------------------------------------------------------------------------------------------
     
#declare ortho_fov = .3;   
#declare pers_fov = 29;
  

//render_plan(ortho_fov,0,-1)      

//render_ceiling(ortho_fov,50,-1)
//render_front_elev(ortho_fov,0,50) 
//render_side_elev(ortho_fov,0,40) 
// render_top_left(pers_fov,<0,0,0>)                     
//render_bottom_left(pers_fov,<60,10,0>) 
//render_top_right(pers_fov,<10,20,0>) 
//render_ground_left(pers_fov,<0,21,0>) 

render_view_A(pers_fov,<10,0,0>)  

//render_view_B(pers_fov,<20,0,0>)   
//render_view_C(pers_fov,<6,15,0>)
//render_view_D(pers_fov,<43,5,-50>)   
