

// -----------------------------------------------------------------------------------------
//                      M A T E R I A L S
//------------------------------------------------------------------------------------------ 


//--- C O L O R S
#ifndef (Transparent) #declare Transparent = rgbt 1 ;#end
#declare C_white =          color rgb<1,1,1>  ;
#declare C_black =          color rgb<0,0,0>  ;
#declare C_red =            color rgb<1,0,0>  ;  
#declare C_red_dark =       color rgb<.5,0,0>  ; 
#declare C_maroon =         color rgb<.45,.02,.02>  ;
#declare C_green =          color rgb<0,1,0>  ;
#declare C_blue =           color rgb<0,.5,.9>  ;
#declare C_orange =         color rgb<1,1,0>  ;
#declare C_copper =         color rgb <0.40, 0.20, 0.15>;  
#declare C_silver =         color rgb <0.85, 0.85, 0.8>;   
#declare C_gold =           color red 0.82 green 0.6 blue 0.196078;
#declare C_gold_bright=     color <0.90, 0.65, 0.15>;
#declare C_light_blue =     color red 0.6 green 0.8 blue 1; 
#declare C_horizon_blue =   color red .82 green 1 blue .98; 
#declare C_light_green =    color rgb<.75,1,.9>  ;  
#declare C_gray5 =          color red 0.05 green 0.05 blue 0.05;
#declare C_gray10 =         color red 0.1 green 0.1 blue 0.1;   
#declare C_gray20 =         color red 0.2 green 0.2 blue 0.2;
#declare C_gray30 =         color red 0.3 green 0.3 blue 0.3; 
#declare C_gray40 =         color red 0.4 green 0.4 blue 0.4;
#declare C_gray50 =         color red 0.5 green 0.5 blue 0.5;
#declare C_gray60 =         color red 0.6 green 0.6 blue 0.6; 
#declare C_gray70 =         color red 0.7 green 0.7 blue 0.7;   
#declare C_gray80 =         color red 0.8 green 0.8 blue 0.8; 
#declare C_gray90 =         color red 0.9 green 0.9 blue 0.9;
#declare C_tan =            color red 0.85 green 0.66 blue 0.5;
#declare C_tan_dark =       color red 0.66 green 0.5 blue 0.4;





        
        
        
#declare F_soft_metal =
finish {
    ambient .2
    diffuse 1   
    phong 1
    phong_size 70  
    metallic
    reflection {.01, .7 fresnel}
}

#declare F_soft_plastic =
finish {
    ambient 0
    diffuse 1   
    phong .7
    phong_size 50 
    reflection {.014, .3 fresnel} 
}                      

#declare F_rubber =
finish {
    ambient .2
    diffuse 1   
    phong .5
    phong_size 20  
}


#declare F_flat =
finish {
    ambient 0
    diffuse 1   
    phong .1
    phong_size 20  
} 

#declare F_gloss =
finish {
    ambient .2
    diffuse 1   
    phong 1
    phong_size 100  
    reflection {.01, .72 fresnel}
}
      

#declare F_metal_dull  =
finish {
     reflection {.3, 1 fresnel on } 
     conserve_energy 
     brilliance 5   
     ambient 1
     diffuse 1
     phong .1    
     phong_size 60   
     metallic 1
     specular .8 
     roughness .05  
     reflection .15  
}


#declare F_metal_hard  =
finish {  
    reflection {.01, 1 fresnel on } 
    conserve_energy 
    brilliance 5
    ambient 0
    brilliance 5
    diffuse 1 
    phong 2    
    phong_size 100
    metallic
    specular 1 
    roughness 1/100
    reflection .2
} 

#declare F_metal_hard2  =
finish {  
    reflection {.01, 1 fresnel on } 
    conserve_energy 
    brilliance 5
    ambient .1
    brilliance 5
    diffuse 1 
    phong 2    
    phong_size 100
    metallic
    specular 1 
    roughness .2
    reflection .1
}


#declare F_metal_polished  =
finish {
    reflection {0, 1 fresnel on }
    conserve_energy 
    brilliance 5
    ambient 0
    diffuse .5 
    phong 5    
    phong_size 40
    metallic
    specular .4
    roughness 1/20
    reflection .5   
}


#declare F_hard_glass =
     finish {
     reflection {.2, 1 fresnel on } 
     conserve_energy
     phong 5     
     phong_size 100   
     metallic 0
     specular .25 
     roughness 1/10  
     diffuse 1
}


#declare F_glass_cover =
     finish {
     reflection {0, .5 fresnel on } 
     conserve_energy 
     ambient 0
     diffuse .5 
     phong 5     
     phong_size 100   
     metallic 0
     specular .25 
     roughness 1/10  
     diffuse 1
}


#declare F_glow =
    finish {
    ambient 0
    emission 1
    //fresnel 1
    phong 0
    diffuse albedo .5
    specular albedo 1 
    roughness 0.001
    reflection 1
    } 
    

#declare F_plastic_gloss =    
    finish {
    reflection {.3, .8 fresnel on } 
    conserve_energy 
    brilliance 6
    ambient 1
    diffuse 1 
    phong 5    
    phong_size 20
    specular .3 
    roughness .2
    reflection .2 
    }
     
#declare F_plastic_gloss2 =    
    finish {
    reflection {.03, .2 fresnel on } 
    conserve_energy 
    brilliance 1
    ambient .1
    diffuse .5 
    phong 5    
    phong_size 80
    specular .3 
    roughness .05

    }
    
     

//--- T E X T U R E S   G R A Y 
#declare T_black = texture{ pigment{ rgb C_black transmit 0 }}
#declare T_gray10 = texture{ pigment{ rgb C_gray50 transmit 0 }}
#declare T_gray20 = texture{ pigment{ rgb C_gray50 transmit 0 }}
#declare T_gray30 = texture{ pigment{ rgb C_gray50 transmit 0 }}
#declare T_gray40 = texture{ pigment{ rgb C_gray50 transmit 0 }}
#declare T_gray50 = texture{ pigment{ rgb C_gray50 transmit 0 }}
#declare T_gray60 = texture{ pigment{ rgb C_gray60 transmit 0 }}  
#declare T_gray70 = texture{ pigment{ rgb C_gray70 transmit 0 }}
#declare T_gray80 = texture{ pigment{ rgb C_gray80 transmit 0 }}
#declare T_white = texture{ pigment{ rgb C_white transmit 0 }}  
#declare T_tan = texture{ pigment{ rgb C_tan transmit 0 }}   
#declare T_tan_dark = texture{ pigment{ rgb C_tan_dark transmit 0 }}  
#declare T_red = texture{ pigment{ rgb C_red transmit 0 }}   

#declare T_gold = texture{ pigment{ rgb C_gold transmit 0 }} 
#declare T_gold_bright = texture{ pigment{ rgb C_gold_bright transmit 0 }} 

// metals
#declare M_metal_alum = material{ texture{ T_gray80   finish{F_metal_dull}}  }
#declare M_metal_steel = material{ texture{ T_gray70   finish{F_metal_hard}} } 
#declare M_metal_chrome = material{ texture{ T_gray80   finish{F_metal_polished}}  }
#declare M_metal_gold = material{ texture{ T_gold   finish{F_metal_polished}} }
#declare M_metal_gold_bright = material{ texture{ T_gold_bright   finish{F_metal_polished}}  } 



#declare M_metal_chrome = 
material{ 
    texture{ 
        pigment{ color red 0.8 green 0.8 blue 0.8 }   
        finish{ F_metal_polished }
     } 
}


#declare C_map_old_copper =
    color_map {
        [ 0.0  C_copper *.3]  
        [ 0.3  C_copper *.3]
        [ 0.5  C_gray40 *.3]
        [ 0.8  C_copper *.3] 
        [ 1    C_copper *.3]
        }
        
        
#declare M_old_copper =
material {
    texture {
        pigment {
            bozo 
            color_map {C_map_old_copper }
        } 
       finish { F_metal_dull }
    }  
}      
        
#declare M_default =
material {
    texture {
        pigment { C_gray70 }
        finish  { F_metal_dull }
   }
}

#declare M_default_floor =
material {
    texture {
        pigment { C_tan_dark *.9}
        finish  { F_soft_plastic }
   }
}



#declare T_glass =
texture {
    pigment{ rgbf <0.0, 0.0, 0,1, 0.9> }
    finish {
        reflection {0.3, 1 fresnel}
        conserve_energy
    }
} 

#declare I_glass =
interior {
    ior 1.33
}


#declare M_sg_maroon_gloss =
material {
    texture {
       pigment { C_maroon }
       finish { F_gloss }
   }
}


// -----------------------------------------------------------------------------------------
//                      M I S C   M A T E R I A L S
//------------------------------------------------------------------------------------------


#declare M_glass =
material {
    texture {T_glass}
    interior {I_glass}
}



#declare M_black_rubber =
material {
    texture {
       pigment { C_black }
       finish { F_rubber }
   }
}

#declare M_black_plastic2 =
material {
    texture {
       pigment { C_black }
       finish { F_plastic_gloss2 }
   }
}



#declare M_pc_green_gloss =
material {
    texture {
       pigment { C_green }
       finish { F_gloss }
   }
}



#declare I_red =
interior {
    ior 1.6
    fade_colour <1,0,0>
    fade_distance .5
    fade_power 2
} 
        

#declare M_white_glow = 
material{ 
    texture{ 
        pigment {C_white} 
        finish {F_glow}
        } 
}


