// pc board
// m.miller 4.04.2023 

#version 3.8; 


global_settings {    
    max_trace_level 7
    ambient_light <.01,.01,.01> * 50                  
}                        



// -----------------------------------------------------------------------------------------
//                      I N C L U D E S
//------------------------------------------------------------------------------------------ 

#include "camera_rigs.inc" 
#include "pc_board_materials.inc"
#include "pc_board.inc"




// -----------------------------------------------------------------------------------------
//                      S K Y
//------------------------------------------------------------------------------------------ 
background { rgb <0.10, 0.12, 0.13> * 5 } 
#declare show_fog = false ;
#declare world_clouds = false;


// -----------------------------------------------------------------------------------------
//                      L I G H T S
//------------------------------------------------------------------------------------------ 

#declare array_count = 16    ;

// --- S K Y  L I G H T
#declare light_A =
light_source {
    <0,0,0> 
    #declare light_color = color red .05 green .05 blue .05 ;                      
    light_color * 20                   
    area_light
    <50, 0, 0> <0, 0, 50>         
    array_count, array_count                          
    adaptive 0                    
    jitter                        
    circular                      
    orient                        
    translate <100, 200, -250>
}   
light_A

// --- B A C K   L I G H T
#declare light_B =
light_source {
    <0,0,0> 
    #declare light_color = color red .03 green .04 blue .05 ;                      
    light_color * 5                   
    area_light
    <50, 0, 0> <0, 0, 50>         
    array_count, array_count                          
    adaptive 0                    
    jitter                        
    circular                      
    orient                        
    translate <50, 40, 50>
}   
light_B



#declare light_D =
light_source {
    <0,0,0> 
    #declare light_color = color red .5 green 0 blue 0 ;                      
    light_color * 55                   
    area_light
    <1, 0, 0> <0, 0, 1>         
    array_count, array_count                          
    adaptive 0                    
    jitter                        
    circular                      
    orient 
    fade_distance 2
    fade_power 2                       
    
} 
light_source { light_D translate <20,4,-30> }




// -----------------------------------------------------------------------------------------
//                      P C   B O A R  D
//------------------------------------------------------------------------------------------
object { pc_board rotate <0,20,0> translate <0,1,-30> }
        
//ground plane
object { plane {<0,1,0> 0} material {M_default} }

       


// -----------------------------------------------------------------------------------------
//                      C A M E R A S
//------------------------------------------------------------------------------------------
     
#declare ortho_fov = .18;   
#declare pers_fov = 22;

//render_sample (M_beetle_eye, 1)      

render_plan(ortho_fov,0,-1)      
//render_ceiling(ortho_fov,50,-1)
//render_front_elev(ortho_fov,0,50) 
//render_side_elev(ortho_fov,0,40) 
//  render_top_left(pers_fov,<0,0,0>)                     
//render_bottom_left(pers_fov,<60,10,0>) 
//render_top_right(pers_fov,<10,20,0>) 
//render_ground_left(pers_fov,<0,21,0>) 

render_view_A(pers_fov,<14,-2,0>)  
//render_view_B(pers_fov,<5,15,0>)   
//render_view_C(pers_fov,<6,15,0>)
//render_view_D(pers_fov,<12,15,0>)   
