// convert x3d
// m.miller 03.09.2023

#include "eyeball.inc"


// -----------------------------------------------------------------------------------------
//                      M A T E R I A L S
//------------------------------------------------------------------------------------------ 


//--- C O L O R S
#ifndef (Transparent) #declare Transparent = rgbt 1 ;#end
#declare C_white =          color rgb<1,1,1>  ;
#declare C_black =          color rgb<0,0,0>  ;
#declare C_red =            color rgb<1,0,0>  ;  
#declare C_red_dark =       color rgb<.9,0,0>  ;
#declare C_green =          color rgb<0,1,0>  ;
#declare C_blue =           color rgb<0,.5,.9>  ;
#declare C_orange =         color rgb<1,1,0>  ;
#declare C_copper =         color rgb <0.40, 0.20, 0.15>;  
#declare C_silver =         color rgb <0.85, 0.85, 0.8>;   
#declare C_gold =           color red 0.82 green 0.6 blue 0.196078;
#declare C_gold_bright=     color <0.90, 0.65, 0.15>;
#declare C_light_blue =     color red 0.6 green 0.8 blue 1; 
#declare C_horizon_blue =   color red .82 green 1 blue .98; 
#declare C_light_green =    color rgb<.75,1,.9>  ;
#declare C_gray10 =         color red 0.1 green 0.1 blue 0.1;   
#declare C_gray20 =         color red 0.2 green 0.2 blue 0.2;
#declare C_gray30 =         color red 0.3 green 0.3 blue 0.3; 
#declare C_gray40 =         color red 0.4 green 0.4 blue 0.4;
#declare C_gray50 =         color red 0.5 green 0.5 blue 0.5;
#declare C_gray60 =         color red 0.6 green 0.6 blue 0.6; 
#declare C_gray70 =         color red 0.7 green 0.7 blue 0.7;   
#declare C_gray80 =         color red 0.8 green 0.8 blue 0.8; 
#declare C_gray90 =         color red 0.9 green 0.9 blue 0.9;
#declare C_tan =            color red 0.85 green 0.66 blue 0.5;
#declare C_tan_dark =       color red 0.66 green 0.5 blue 0.4;


#declare F_soft_metal =
finish {
    ambient 0
    diffuse 1   
    phong 1
    phong_size 70  
    metallic
    reflection {.01, .7 fresnel}
}



#declare F_gloss =
finish {
    ambient .2
    diffuse 1   
    phong 1
    phong_size 100  
    reflection {.01, .52 fresnel}
}
      
#declare F_metal_hard =
finish {
    conserve_energy 
    brilliance 5
    ambient .2
    diffuse 1 
    phong 20    
    phong_size 50
    metallic
    specular 10
    roughness 1/20
    reflection {0.01, .7 fresnel on } 
}


#declare M_default =
material {
    texture {
        pigment { C_gray70 }
        finish  { F_soft_metal }
   }
}



#declare imgDiffuse = "jack_face_diffuse.png" 
#declare imgBump = "jack_face_bump.png"

#declare M_jack_face =
material {
    texture {
       pigment { 
            image_map {
                png imgDiffuse     
                map_type 0
                interpolate 4 
                }
      }
   
     finish { 
        F_gloss
     }
     
    normal  {
        bump_map {
            png imgBump 
            map_type 0
            interpolate 4 
        } 
        bump_size .2 
    }
        
    }
    rotate y*180 
    scale <60,80,1> 
    translate <-30,0,0>  
}






#declare imgDiffuse = "Jack_cap_diffuse.png" 
#declare imgBump = "jack_cap_bump.png"

#declare M_jack_cap =
material {
    texture {
       pigment { 
            image_map {
                png imgDiffuse     
                map_type 0
                interpolate 4 
                }
      }
   
     finish { 
        F_gloss
     }
     
    normal  {
        bump_map {
            png imgBump 
            map_type 0
            interpolate 4 
        } 
        bump_size 1 
    }
        
    }
    rotate y*180 
    scale <60,80,1> 
    translate <-30,0,0>  
}




// -----------------------------------------------------------------------------------------
//                      J A C K   H E A D
//------------------------------------------------------------------------------------------ 
//--- jack head blob with ears, nose, lips 
#declare jack_head_parts = 
#declare th = 0.55 ;
#declare sf = 2.0 ;
#declare nStrenth = -1 ;
#declare nSize = 1 ;
blob {
     threshold th
     sphere{ <0,0,0>, 1, 1 scale <15.672, 16.045, 14.649> * sf  translate <0.000, 41.534, 13.211> }
     sphere{ <0,0,0>, 1, 1 scale <13.178, 14.795, 14.795> * sf  translate <0.000, 21.942, -0.083> }
     sphere{ <0,0,0>, 1, 1 scale <9.257, 9.257, 9.257> * sf  translate <4.607, 37.774, -8.114> }
     sphere{ <0,0,0>, 1, 1 scale <9.257, 9.257, 9.257> * sf  translate <-5.193, 37.774, -8.114> }
     sphere{ <0,0,0>, 1, 1 scale <7.587, 3.765, 7.579> * sf  translate <0.000, 36.421, -9.407> }
     sphere{ <0,0,0>, 1, 1 scale <1.366, 3.765, 7.579> * sf  translate <0.000, 28.638, -14.002> }
     sphere{ <0,0,0>, 1, 1 scale <2.712, 4.052, 8.155> * sf  translate <-0.000, 23.503, -16.773> }
     sphere{ <0,0,0>, 1, 1 scale <5.378, 2.457, 5.486> * sf  translate <-5.359, 37.097, -15.365> }
     sphere{ <0,0,0>, 1, 1 scale <5.378, 2.457, 5.486> * sf  translate <6.031, 37.266, -15.365> }
     sphere{ <0,0,0>, 1, 1 scale <3.962, 2.145, 8.155> * sf  translate <-0.000, 21.459, -15.482> }
     sphere{ <0,0,0>, 1, 1 scale <5.266, 5.266, 5.313> * sf  translate <-8.074, 24.494, -15.578> }
     sphere{ <0,0,0>, 1, 1 scale <6.650, 6.646, 6.705> * sf  translate <-7.725, 25.346, -5.188> }
     sphere{ <0,0,0>, 1, 1 scale <6.650, 6.646, 6.705> * sf  translate <-4.304, 17.528, -10.005> }
     sphere{ <0,0,0>, 1, 1 scale <3.265, 3.138, 3.220> * sf  translate <1.926, 8.034, -17.444> }
     sphere{ <0,0,0>, 1, 1 scale <6.650, 6.646, 6.705> * sf  translate <6.933, 25.346, -5.188> }
     sphere{ <0,0,0>, 1, 1 scale <5.266, 5.266, 5.313> * sf  translate <7.922, 24.464, -15.597> }
     sphere{ <0,0,0>, 1, 1 scale <6.650, 6.646, 6.705> * sf  translate <4.558, 17.528, -10.005> }
     sphere{ <0,0,0>, 1, 1 scale <4.199, 2.713, 3.803> * sf  translate <3.221, 10.604, -15.649> }
     sphere{ <0,0,0>, 1, 1 scale <4.199, 2.713, 3.803> * sf  translate <-2.231, 10.604, -15.649> }
     sphere{ <0,0,0>, 1, 1 scale <5.381, 2.855, 3.220> * sf  translate <0.232, 8.860, -11.793> }
     sphere{ <0,0,0>, 1, 1 scale <1.234, 1.918, 1.656> * sf  translate <0.050, 21.876, -24.829> }
     sphere{ <0,0,0>, 1, 1 scale <0.887, 1.256, 1.132> * sf  translate <-3.140, 21.235, -23.997> }
     sphere{ <0,0,0>, 1, 1 scale <0.887, 1.256, 1.132> * sf  translate <2.820, 21.235, -24.010> }
     sphere{ <0,0,0>, 1, 1 scale <4.363, 3.252, 2.346> * sf  translate <2.098, 16.566, -20.018> }
     sphere{ <0,0,0>, 1, 1 scale <4.185, 3.428, 2.473> * sf  translate <3.922, 15.524, -17.459> }
     sphere{ <0,0,0>, 1, 1 scale <4.363, 3.252, 2.346> * sf  translate <-2.015, 16.613, -20.018> }
     sphere{ <0,0,0>, 1, 1 scale <2.141, 0.921, 1.017> * sf  translate <1.748, 16.175, -22.085> }
     sphere{ <0,0,0>, 1, 1 scale <2.238, 0.887, 0.979> * sf  translate <2.334, 15.086, -19.808> }
     sphere{ <0,0,0>, 1, 1 scale <2.238, 0.887, 0.979> * sf  translate <-2.691, 15.261, -19.808> }
     sphere{ <0,0,0>, 1, 1 scale <2.141, 0.921, 1.017> * sf  translate <-1.547, 16.227, -22.096> }
     sphere{ <0,0,0>, 1, 1 scale <2.278, 1.107, 1.222> * sf  translate <-1.352, 12.880, -21.138> }
     sphere{ <0,0,0>, 1, 1 scale <2.278, 1.107, 1.222> * sf  translate <1.312, 12.875, -21.126> }
     sphere{ <0,0,0>, 1, 1 scale <3.022, 2.059, 2.272> * sf  translate <1.312, 13.284, -18.711> }
     sphere{ <0,0,0>, 1, 1 scale <3.022, 2.059, 2.272> * sf  translate <-1.352, 13.289, -18.722> }
     sphere{ <0,0,0>, 1, 1 scale <2.722, 1.171, 1.293> * sf  translate <-1.832, 13.943, -20.152> }
     sphere{ <0,0,0>, 1, 1 scale <2.722, 1.171, 1.293> * sf  translate <1.853, 13.907, -20.141> }
     sphere{ <0,0,0>, 1, 1 scale <0.598, 1.414, 0.700> * sf  translate <-0.902, 17.571, -22.535> }
     sphere{ <0,0,0>, 1, 1 scale <0.598, 1.414, 0.700> * sf  translate <1.037, 17.613, -22.524> }
     sphere{ <0,0,0>, 1, 1 scale <2.141, 0.921, 1.017> * sf  translate <-2.029, 15.762, -21.254> }
     sphere{ <0,0,0>, 1, 1 scale <2.141, 0.921, 1.017> * sf  translate <2.576, 15.757, -21.243> }
     sphere{ <0,0,0>, 1, 1 scale <3.265, 3.138, 3.220> * sf  translate <-2.087, 8.150, -17.444> }
     sphere{ <0,0,0>, 1, 1 scale <9.821, 10.055, 9.180> * sf  translate <-0.000, 23.299, 5.109> }
     sphere{ <0,0,0>, 1, 1 scale <9.821, 10.055, 9.180> * sf  translate <-0.000, 7.015, 9.432> }
     sphere{ <0,0,0>, 1, 1 scale <9.821, 10.055, 9.180> * sf  translate <-0.000, 1.185, 7.924> }
     sphere{ <0,0,0>, 1, 1 scale <9.821, 10.055, 9.180> * sf  translate <-0.000, -12.887, 7.522> }
     sphere{ <0,0,0>, 1, 1 scale <9.821, 10.055, 9.180> * sf  translate <-0.000, -11.781, 16.066> }
     sphere{ <0,0,0>, 1, 1 scale <2.487, 2.145, 3.661> * sf  translate <-0.058, 0.227, -0.241> }
     sphere{ <0,0,0>, 1, 1 scale <2.487, 2.145, 3.661> * sf  translate <5.235, -9.952, 2.550> }
     sphere{ <0,0,0>, 1, 1 scale <2.933, 4.720, 5.389> * sf  translate <7.038, -6.495, 4.507> }
     sphere{ <0,0,0>, 1, 1 scale <2.933, 4.720, 5.389> * sf  translate <8.654, -0.098, 4.748> }
     sphere{ <0,0,0>, 1, 1 scale <2.933, 4.720, 5.389> * sf  translate <-8.215, -0.098, 4.748> }
     sphere{ <0,0,0>, 1, 1 scale <2.933, 4.720, 5.389> * sf  translate <-6.922, -6.495, 4.507> }
     sphere{ <0,0,0>, 1, 1 scale <2.487, 2.145, 3.661> * sf  translate <-5.526, -9.952, 2.550> }
     sphere{ <0,0,0>, 1, 1 scale <15.672, 9.262, 11.009> * sf  translate <-0.000, -8.703, 18.484> }
     sphere{ <0,0,0>, 1, 1 scale <5.381, 2.855, 3.220> * sf  translate <0.232, 9.442, -7.188> }
     sphere{ <0,0,0>, 1, 1 scale <15.945, 15.945, 15.945> * sf  translate <0.000, 41.628, -0.502> }
     sphere{ <0,0,0>, 1, 1 scale <-4.073, -4.630, -4.060> * sf  translate <11.105, 30.082, -12.152> }
     sphere{ <0,0,0>, 1, 1 scale <-4.073, -4.630, -4.060> * sf  translate <-11.062, 30.082, -12.152> }
     sphere{ <0,0,0>, 1, 1 scale <-3.347, -3.090, -2.936> * sf  translate <-9.130, 32.522, -16.282> }
     sphere{ <0,0,0>, 1, 1 scale <-3.347, -3.090, -2.936> * sf  translate <9.130, 32.522, -16.282> }
     sphere{ <0,0,0>, 1, 1 scale <-4.190, -3.746, -2.936> * sf  translate <6.652, 33.946, -16.790> }
     sphere{ <0,0,0>, 1, 1 scale <-4.190, -3.746, -2.936> * sf  translate <-6.347, 33.946, -16.790> }
     sphere{ <0,0,0>, 1, 1 scale <7.591, 10.513, 10.513> * sf  translate <5.224, 44.199, -5.657> }
     sphere{ <0,0,0>, 1, 1 scale <7.591, 10.513, 10.513> * sf  translate <-4.510, 44.199, -5.657> }
     sphere{ <0,0,0>, 1, 1 scale <4.185, 3.428, 2.473> * sf  translate <-4.006, 15.524, -17.459> }
     
     //---eye socket
     sphere{ <0,0,0>, 1, nStrenth scale <5.847, 3.390, 3.936> * 1.2  translate <7.5, 32.522, -19> }
     sphere{ <0,0,0>, 1, nStrenth scale <5.847, 3.390, 3.936> * 1.2  translate <-7.5, 32.522, -19> }
     
     //---ear
     sphere{ <0,0,0>, 1, 1 scale <0.972, 1.261, 1.435> * sf  rotate <0,0,20> translate <-17.5, 19.632, 2.807> }
     sphere{ <0,0,0>, 1, 1 scale <0.672, 1.261, 1.435> * sf  rotate <0,0,20> translate <-17.5, 19.632, 1.453> }
     sphere{ <0,0,0>, 1, 1 scale <1.048, 1.882, 2.402> * sf  rotate <0,0,20> translate <-18.442, 21.876, 4.020> }
     sphere{ <0,0,0>, 1, 1 scale <1.041, 3.542, 4.031> * sf  rotate <0,0,20> translate <-20.147, 29.696, 5.496> }
     sphere{ <0,0,0>, 1, 1 scale <0.989, 3.542, 4.031> * sf  rotate <0,0,20> translate <-19.283, 25.080, 4.578> }
     sphere{ <0,0,0>, 1, 1 scale <1.616, 4.420, 4.031> * sf  rotate <0,0,20> translate <-16.745, 26.921, 4.479> } 
       
     sphere{ <0,0,0>, 1, -2 scale <1.710, 2.325, 2.514> * sf  translate <-22.080, 28.794, 4.964> }
     sphere{ <0,0,0>, 1, -2 scale <1.624, 2.325, 2.514> * sf  translate <-21.215, 24.178, 4.046> }
     sphere{ <0,0,0>, 1, -2 scale <2,2,2> * sf  translate <-20.215, 26.178, 3.046> }
     //---ear
     sphere{ <0,0,0>, 1, 1 scale <0.972, 1.261, 1.435> * sf  rotate <0,0,-20> translate <17.5, 19.632, 2.807> }
     sphere{ <0,0,0>, 1, 1 scale <0.672, 1.261, 1.435> * sf  rotate <0,0,-20> translate <17.5, 19.632, 1.453> }
     sphere{ <0,0,0>, 1, 1 scale <1.048, 1.882, 2.402> * sf  rotate <0,0,-20> translate <18.442, 21.876, 4.020> }
     sphere{ <0,0,0>, 1, 1 scale <1.041, 3.542, 4.031> * sf  rotate <0,0,-20> translate <20.147, 29.696, 5.496> }
     sphere{ <0,0,0>, 1, 1 scale <0.989, 3.542, 4.031> * sf  rotate <0,0,-20> translate <19.283, 25.080, 4.578> }
     sphere{ <0,0,0>, 1, 1 scale <1.616, 4.420, 4.031> * sf  rotate <0,0,-20> translate <16.745, 26.921, 4.479> } 
     
     sphere{ <0,0,0>, 1, -2 scale <1.710, 2.325, 2.514> * sf  translate <22.080, 28.794, 4.964> }
     sphere{ <0,0,0>, 1, -2 scale <1.624, 2.325, 2.514> * sf  translate <21.215, 24.178, 4.046> } 
     sphere{ <0,0,0>, 1, -2 scale <2,2,2> * sf  translate <20.215, 26.178, 3.046> }
     translate <0,10,0>
} 
    
  




//--- jack head blob for outter plate / no nose, mouth, ear, sunken jaw
#declare jack_head_metal = 
#declare th = 0.55 ;
#declare sf = 1.75 ;
#declare nStrenth = -1 ;
#declare nSize = 1 ;
blob {
     threshold th
     sphere{ <0,0,0>, 1, 1 scale <15.672, 16.045, 14.649> * sf  translate <0.000, 41.534, 13.211> }
     sphere{ <0,0,0>, 1, 1 scale <13.178, 14.795, 14.795> * sf  translate <0.000, 21.942, -0.083> }
     sphere{ <0,0,0>, 1, 1 scale <9.257, 9.257, 9.257> * sf  translate <4.607, 37.774, -8.114> }
     sphere{ <0,0,0>, 1, 1 scale <9.257, 9.257, 9.257> * sf  translate <-5.193, 37.774, -8.114> }
     sphere{ <0,0,0>, 1, 1 scale <5.266, 7.625, 5.313> * sf  translate <-8.074, 24.494, -13.608> }
     sphere{ <0,0,0>, 1, 1 scale <6.650, 6.646, 6.705> * sf  translate <-7.725, 25.346, -5.188> }
     sphere{ <0,0,0>, 1, 1 scale <6.650, 6.646, 6.705> * sf  translate <-4.304, 17.528, -10.005> }
     sphere{ <0,0,0>, 1, 1 scale <3.265, 3.138, 3.220> * sf  translate <1.926, 8.034, -17.444> }
     sphere{ <0,0,0>, 1, 1 scale <6.650, 6.646, 6.705> * sf  translate <6.933, 25.346, -5.188> }
     sphere{ <0,0,0>, 1, 1 scale <6.670, 11.176, 5.313> * sf  translate <0.000, 28.278, -14.008> }
     sphere{ <0,0,0>, 1, 1 scale <6.650, 6.646, 6.705> * sf  translate <4.558, 17.528, -10.005> }
     sphere{ <0,0,0>, 1, 1 scale <4.199, 2.713, 3.803> * sf  translate <3.221, 10.604, -15.649> }
     sphere{ <0,0,0>, 1, 1 scale <4.199, 2.713, 3.803> * sf  translate <-2.231, 10.604, -15.649> }
     sphere{ <0,0,0>, 1, 1 scale <5.381, 2.855, 3.220> * sf  translate <0.232, 8.860, -11.793> }
     sphere{ <0,0,0>, 1, 1 scale <4.185, 5.157, 2.473> * sf  translate <0.000, 15.524, -17.424> }
     sphere{ <0,0,0>, 1, 1 scale <3.265, 3.138, 3.220> * sf  translate <-2.087, 8.150, -17.444> }
     sphere{ <0,0,0>, 1, 1 scale <9.821, 10.055, 9.180> * sf  translate <-0.000, 23.299, 5.109> }
     sphere{ <0,0,0>, 1, 1 scale <9.821, 10.055, 9.180> * sf  translate <-0.000, 7.015, 9.432> }
     sphere{ <0,0,0>, 1, 1 scale <9.821, 10.055, 9.180> * sf  translate <-0.000, 1.185, 7.924> }
     sphere{ <0,0,0>, 1, 1 scale <9.821, 10.055, 9.180> * sf  translate <-0.000, -12.887, 7.522> }
     sphere{ <0,0,0>, 1, 1 scale <9.821, 10.055, 9.180> * sf  translate <-0.000, -11.781, 16.066> }
     sphere{ <0,0,0>, 1, 1 scale <2.487, 2.145, 3.661> * sf  translate <-0.058, 0.227, -0.241> }
     sphere{ <0,0,0>, 1, 1 scale <2.487, 2.145, 3.661> * sf  translate <5.235, -9.952, 2.550> }
     sphere{ <0,0,0>, 1, 1 scale <2.933, 4.720, 5.389> * sf  translate <7.038, -6.495, 4.507> }
     sphere{ <0,0,0>, 1, 1 scale <2.933, 4.720, 5.389> * sf  translate <8.654, -0.098, 4.748> }
     sphere{ <0,0,0>, 1, 1 scale <2.933, 4.720, 5.389> * sf  translate <-8.215, -0.098, 4.748> }
     sphere{ <0,0,0>, 1, 1 scale <2.933, 4.720, 5.389> * sf  translate <-6.922, -6.495, 4.507> }
     sphere{ <0,0,0>, 1, 1 scale <2.487, 2.145, 3.661> * sf  translate <-5.526, -9.952, 2.550> }
     sphere{ <0,0,0>, 1, 1 scale <15.672, 9.262, 11.009> * sf  translate <-0.000, -8.703, 18.484> }
     sphere{ <0,0,0>, 1, 1 scale <5.381, 2.855, 3.220> * sf  translate <0.232, 9.442, -7.188> }
     sphere{ <0,0,0>, 1, 1 scale <15.945, 15.945, 15.945> * sf  translate <0.000, 41.628, -0.502> }
     sphere{ <0,0,0>, 1, 1 scale <-4.073, -4.630, -4.060> * sf  translate <11.105, 30.082, -12.152> }
     sphere{ <0,0,0>, 1, 1 scale <-4.073, -4.630, -4.060> * sf  translate <-11.062, 30.082, -12.152> }
     sphere{ <0,0,0>, 1, 1 scale <7.591, 10.513, 10.513> * sf  translate <5.224, 44.199, -5.657> }
     sphere{ <0,0,0>, 1, 1 scale <7.591, 10.513, 10.513> * sf  translate <-4.510, 44.199, -5.657> }
     sphere{ <0,0,0>, 1, 1 scale <4.185, 5.157, 2.473> * sf  translate <-4.006, 15.524, -17.424> }
     sphere{ <0,0,0>, 1, 1 scale <5.266, 7.625, 5.313> * sf  translate <7.922, 24.464, -13.626> }
     sphere{ <0,0,0>, 1, 1 scale <4.185, 5.157, 2.473> * sf  translate <3.922, 14.507, -17.763> }
     translate <0,10,0>
     } 


//--- jack head blob / outter plate void
#declare jack_head_void = 
#declare th = 0.55 ;
#declare sf = 1.55 ;
#declare nStrenth = -1 ;
#declare nSize = 1 ;
blob {
     threshold th
     sphere{ <0,0,0>, 1, 1 scale <15.672, 16.045, 14.649> * sf  translate <0.000, 41.534, 13.211> }
     sphere{ <0,0,0>, 1, 1 scale <13.178, 14.795, 14.795> * sf  translate <0.000, 21.942, -0.083> }
     sphere{ <0,0,0>, 1, 1 scale <9.257, 9.257, 9.257> * sf  translate <4.607, 37.774, -8.114> }
     sphere{ <0,0,0>, 1, 1 scale <9.257, 9.257, 9.257> * sf  translate <-5.193, 37.774, -8.114> }
     sphere{ <0,0,0>, 1, 1 scale <5.266, 7.625, 5.313> * sf  translate <-8.074, 24.494, -13.608> }
     sphere{ <0,0,0>, 1, 1 scale <6.650, 6.646, 6.705> * sf  translate <-7.725, 25.346, -5.188> }
     sphere{ <0,0,0>, 1, 1 scale <6.650, 6.646, 6.705> * sf  translate <-4.304, 17.528, -10.005> }
     sphere{ <0,0,0>, 1, 1 scale <3.265, 3.138, 3.220> * sf  translate <1.926, 8.034, -17.444> }
     sphere{ <0,0,0>, 1, 1 scale <6.650, 6.646, 6.705> * sf  translate <6.933, 25.346, -5.188> }
     sphere{ <0,0,0>, 1, 1 scale <6.670, 11.176, 5.313> * sf  translate <0.000, 28.278, -14.008> }
     sphere{ <0,0,0>, 1, 1 scale <6.650, 6.646, 6.705> * sf  translate <4.558, 17.528, -10.005> }
     sphere{ <0,0,0>, 1, 1 scale <4.199, 2.713, 3.803> * sf  translate <3.221, 10.604, -15.649> }
     sphere{ <0,0,0>, 1, 1 scale <4.199, 2.713, 3.803> * sf  translate <-2.231, 10.604, -15.649> }
     sphere{ <0,0,0>, 1, 1 scale <5.381, 2.855, 3.220> * sf  translate <0.232, 8.860, -11.793> }
     sphere{ <0,0,0>, 1, 1 scale <4.185, 5.157, 2.473> * sf  translate <0.000, 15.524, -17.424> }
     sphere{ <0,0,0>, 1, 1 scale <3.265, 3.138, 3.220> * sf  translate <-2.087, 8.150, -17.444> }
     sphere{ <0,0,0>, 1, 1 scale <9.821, 10.055, 9.180> * sf  translate <-0.000, 23.299, 5.109> }
     sphere{ <0,0,0>, 1, 1 scale <9.821, 10.055, 9.180> * sf  translate <-0.000, 7.015, 9.432> }
     sphere{ <0,0,0>, 1, 1 scale <9.821, 10.055, 9.180> * sf  translate <-0.000, 1.185, 7.924> }
     sphere{ <0,0,0>, 1, 1 scale <9.821, 10.055, 9.180> * sf  translate <-0.000, -12.887, 7.522> }
     sphere{ <0,0,0>, 1, 1 scale <9.821, 10.055, 9.180> * sf  translate <-0.000, -11.781, 16.066> }
     sphere{ <0,0,0>, 1, 1 scale <2.487, 2.145, 3.661> * sf  translate <-0.058, 0.227, -0.241> }
     sphere{ <0,0,0>, 1, 1 scale <2.487, 2.145, 3.661> * sf  translate <5.235, -9.952, 2.550> }
     sphere{ <0,0,0>, 1, 1 scale <2.933, 4.720, 5.389> * sf  translate <7.038, -6.495, 4.507> }
     sphere{ <0,0,0>, 1, 1 scale <2.933, 4.720, 5.389> * sf  translate <8.654, -0.098, 4.748> }
     sphere{ <0,0,0>, 1, 1 scale <2.933, 4.720, 5.389> * sf  translate <-8.215, -0.098, 4.748> }
     sphere{ <0,0,0>, 1, 1 scale <2.933, 4.720, 5.389> * sf  translate <-6.922, -6.495, 4.507> }
     sphere{ <0,0,0>, 1, 1 scale <2.487, 2.145, 3.661> * sf  translate <-5.526, -9.952, 2.550> }
     sphere{ <0,0,0>, 1, 1 scale <15.672, 9.262, 11.009> * sf  translate <-0.000, -8.703, 18.484> }
     sphere{ <0,0,0>, 1, 1 scale <5.381, 2.855, 3.220> * sf  translate <0.232, 9.442, -7.188> }
     sphere{ <0,0,0>, 1, 1 scale <15.945, 15.945, 15.945> * sf  translate <0.000, 41.628, -0.502> }
     sphere{ <0,0,0>, 1, 1 scale <-4.073, -4.630, -4.060> * sf  translate <11.105, 30.082, -12.152> }
     sphere{ <0,0,0>, 1, 1 scale <-4.073, -4.630, -4.060> * sf  translate <-11.062, 30.082, -12.152> }
     sphere{ <0,0,0>, 1, 1 scale <7.591, 10.513, 10.513> * sf  translate <5.224, 44.199, -5.657> }
     sphere{ <0,0,0>, 1, 1 scale <7.591, 10.513, 10.513> * sf  translate <-4.510, 44.199, -5.657> }
     sphere{ <0,0,0>, 1, 1 scale <4.185, 5.157, 2.473> * sf  translate <-4.006, 15.524, -17.424> }
     sphere{ <0,0,0>, 1, 1 scale <5.266, 7.625, 5.313> * sf  translate <7.922, 24.464, -13.626> }
     sphere{ <0,0,0>, 1, 1 scale <4.185, 5.157, 2.473> * sf  translate <3.922, 14.507, -17.763> }
     translate <0,10,0>
     } 



//--- jack head blob / metal plate skin
#declare jack_head_frame_plate = 
#declare th = 0.55 ;
#declare sf = 1.69 ;
#declare nStrenth = -1 ;
#declare nSize = 1 ;
blob {
     threshold th
     sphere{ <0,0,0>, 1, 1 scale <15.672, 16.045, 14.649> * sf  translate <0.000, 41.534, 13.211> }
     sphere{ <0,0,0>, 1, 1 scale <13.178, 14.795, 14.795> * sf  translate <0.000, 21.942, -0.083> }
     sphere{ <0,0,0>, 1, 1 scale <9.257, 9.257, 9.257> * sf  translate <4.607, 37.774, -8.114> }
     sphere{ <0,0,0>, 1, 1 scale <9.257, 9.257, 9.257> * sf  translate <-5.193, 37.774, -8.114> }
     sphere{ <0,0,0>, 1, 1 scale <5.266, 7.625, 5.313> * sf  translate <-8.074, 24.494, -13.608> }
     sphere{ <0,0,0>, 1, 1 scale <6.650, 6.646, 6.705> * sf  translate <-7.725, 25.346, -5.188> }
     sphere{ <0,0,0>, 1, 1 scale <6.650, 6.646, 6.705> * sf  translate <-4.304, 17.528, -10.005> }
     sphere{ <0,0,0>, 1, 1 scale <3.265, 3.138, 3.220> * sf  translate <1.926, 8.034, -17.444> }
     sphere{ <0,0,0>, 1, 1 scale <6.650, 6.646, 6.705> * sf  translate <6.933, 25.346, -5.188> }
     sphere{ <0,0,0>, 1, 1 scale <6.670, 11.176, 5.313> * sf  translate <0.000, 28.278, -14.008> }
     sphere{ <0,0,0>, 1, 1 scale <6.650, 6.646, 6.705> * sf  translate <4.558, 17.528, -10.005> }
     sphere{ <0,0,0>, 1, 1 scale <4.199, 2.713, 3.803> * sf  translate <3.221, 10.604, -15.649> }
     sphere{ <0,0,0>, 1, 1 scale <4.199, 2.713, 3.803> * sf  translate <-2.231, 10.604, -15.649> }
     sphere{ <0,0,0>, 1, 1 scale <5.381, 2.855, 3.220> * sf  translate <0.232, 8.860, -11.793> }
     sphere{ <0,0,0>, 1, 1 scale <4.185, 5.157, 2.473> * sf  translate <0.000, 15.524, -17.424> }
     sphere{ <0,0,0>, 1, 1 scale <3.265, 3.138, 3.220> * sf  translate <-2.087, 8.150, -17.444> }
     sphere{ <0,0,0>, 1, 1 scale <9.821, 10.055, 9.180> * sf  translate <-0.000, 23.299, 5.109> }
     sphere{ <0,0,0>, 1, 1 scale <9.821, 10.055, 9.180> * sf  translate <-0.000, 7.015, 9.432> }
     sphere{ <0,0,0>, 1, 1 scale <9.821, 10.055, 9.180> * sf  translate <-0.000, 1.185, 7.924> }
     sphere{ <0,0,0>, 1, 1 scale <9.821, 10.055, 9.180> * sf  translate <-0.000, -12.887, 7.522> }
     sphere{ <0,0,0>, 1, 1 scale <9.821, 10.055, 9.180> * sf  translate <-0.000, -11.781, 16.066> }
     sphere{ <0,0,0>, 1, 1 scale <2.487, 2.145, 3.661> * sf  translate <-0.058, 0.227, -0.241> }
     sphere{ <0,0,0>, 1, 1 scale <2.487, 2.145, 3.661> * sf  translate <5.235, -9.952, 2.550> }
     sphere{ <0,0,0>, 1, 1 scale <2.933, 4.720, 5.389> * sf  translate <7.038, -6.495, 4.507> }
     sphere{ <0,0,0>, 1, 1 scale <2.933, 4.720, 5.389> * sf  translate <8.654, -0.098, 4.748> }
     sphere{ <0,0,0>, 1, 1 scale <2.933, 4.720, 5.389> * sf  translate <-8.215, -0.098, 4.748> }
     sphere{ <0,0,0>, 1, 1 scale <2.933, 4.720, 5.389> * sf  translate <-6.922, -6.495, 4.507> }
     sphere{ <0,0,0>, 1, 1 scale <2.487, 2.145, 3.661> * sf  translate <-5.526, -9.952, 2.550> }
     sphere{ <0,0,0>, 1, 1 scale <15.672, 9.262, 11.009> * sf  translate <-0.000, -8.703, 18.484> }
     sphere{ <0,0,0>, 1, 1 scale <5.381, 2.855, 3.220> * sf  translate <0.232, 9.442, -7.188> }
     sphere{ <0,0,0>, 1, 1 scale <15.945, 15.945, 15.945> * sf  translate <0.000, 41.628, -0.502> }
     sphere{ <0,0,0>, 1, 1 scale <-4.073, -4.630, -4.060> * sf  translate <11.105, 30.082, -12.152> }
     sphere{ <0,0,0>, 1, 1 scale <-4.073, -4.630, -4.060> * sf  translate <-11.062, 30.082, -12.152> }
     sphere{ <0,0,0>, 1, 1 scale <7.591, 10.513, 10.513> * sf  translate <5.224, 44.199, -5.657> }
     sphere{ <0,0,0>, 1, 1 scale <7.591, 10.513, 10.513> * sf  translate <-4.510, 44.199, -5.657> }
     sphere{ <0,0,0>, 1, 1 scale <4.185, 5.157, 2.473> * sf  translate <-4.006, 15.524, -17.424> }
     sphere{ <0,0,0>, 1, 1 scale <5.266, 7.625, 5.313> * sf  translate <7.922, 24.464, -13.626> }
     sphere{ <0,0,0>, 1, 1 scale <4.185, 5.157, 2.473> * sf  translate <3.922, 14.507, -17.763> }
     translate <0,10,0>
     } 



//--- jack head blob / metal plate skin
#declare jack_head_frame_plate_void = 
#declare th = 0.55 ;
#declare sf = 1.60 ;
#declare nStrenth = -1 ;
#declare nSize = 1 ;
blob {
     threshold th
     sphere{ <0,0,0>, 1, 1 scale <15.672, 16.045, 14.649> * sf  translate <0.000, 41.534, 13.211> }
     sphere{ <0,0,0>, 1, 1 scale <13.178, 14.795, 14.795> * sf  translate <0.000, 21.942, -0.083> }
     sphere{ <0,0,0>, 1, 1 scale <9.257, 9.257, 9.257> * sf  translate <4.607, 37.774, -8.114> }
     sphere{ <0,0,0>, 1, 1 scale <9.257, 9.257, 9.257> * sf  translate <-5.193, 37.774, -8.114> }
     sphere{ <0,0,0>, 1, 1 scale <5.266, 7.625, 5.313> * sf  translate <-8.074, 24.494, -13.608> }
     sphere{ <0,0,0>, 1, 1 scale <6.650, 6.646, 6.705> * sf  translate <-7.725, 25.346, -5.188> }
     sphere{ <0,0,0>, 1, 1 scale <6.650, 6.646, 6.705> * sf  translate <-4.304, 17.528, -10.005> }
     sphere{ <0,0,0>, 1, 1 scale <3.265, 3.138, 3.220> * sf  translate <1.926, 8.034, -17.444> }
     sphere{ <0,0,0>, 1, 1 scale <6.650, 6.646, 6.705> * sf  translate <6.933, 25.346, -5.188> }
     sphere{ <0,0,0>, 1, 1 scale <6.670, 11.176, 5.313> * sf  translate <0.000, 28.278, -14.008> }
     sphere{ <0,0,0>, 1, 1 scale <6.650, 6.646, 6.705> * sf  translate <4.558, 17.528, -10.005> }
     sphere{ <0,0,0>, 1, 1 scale <4.199, 2.713, 3.803> * sf  translate <3.221, 10.604, -15.649> }
     sphere{ <0,0,0>, 1, 1 scale <4.199, 2.713, 3.803> * sf  translate <-2.231, 10.604, -15.649> }
     sphere{ <0,0,0>, 1, 1 scale <5.381, 2.855, 3.220> * sf  translate <0.232, 8.860, -11.793> }
     sphere{ <0,0,0>, 1, 1 scale <4.185, 5.157, 2.473> * sf  translate <0.000, 15.524, -17.424> }
     sphere{ <0,0,0>, 1, 1 scale <3.265, 3.138, 3.220> * sf  translate <-2.087, 8.150, -17.444> }
     sphere{ <0,0,0>, 1, 1 scale <9.821, 10.055, 9.180> * sf  translate <-0.000, 23.299, 5.109> }
     sphere{ <0,0,0>, 1, 1 scale <9.821, 10.055, 9.180> * sf  translate <-0.000, 7.015, 9.432> }
     sphere{ <0,0,0>, 1, 1 scale <9.821, 10.055, 9.180> * sf  translate <-0.000, 1.185, 7.924> }
     sphere{ <0,0,0>, 1, 1 scale <9.821, 10.055, 9.180> * sf  translate <-0.000, -12.887, 7.522> }
     sphere{ <0,0,0>, 1, 1 scale <9.821, 10.055, 9.180> * sf  translate <-0.000, -11.781, 16.066> }
     sphere{ <0,0,0>, 1, 1 scale <2.487, 2.145, 3.661> * sf  translate <-0.058, 0.227, -0.241> }
     sphere{ <0,0,0>, 1, 1 scale <2.487, 2.145, 3.661> * sf  translate <5.235, -9.952, 2.550> }
     sphere{ <0,0,0>, 1, 1 scale <2.933, 4.720, 5.389> * sf  translate <7.038, -6.495, 4.507> }
     sphere{ <0,0,0>, 1, 1 scale <2.933, 4.720, 5.389> * sf  translate <8.654, -0.098, 4.748> }
     sphere{ <0,0,0>, 1, 1 scale <2.933, 4.720, 5.389> * sf  translate <-8.215, -0.098, 4.748> }
     sphere{ <0,0,0>, 1, 1 scale <2.933, 4.720, 5.389> * sf  translate <-6.922, -6.495, 4.507> }
     sphere{ <0,0,0>, 1, 1 scale <2.487, 2.145, 3.661> * sf  translate <-5.526, -9.952, 2.550> }
     sphere{ <0,0,0>, 1, 1 scale <15.672, 9.262, 11.009> * sf  translate <-0.000, -8.703, 18.484> }
     sphere{ <0,0,0>, 1, 1 scale <5.381, 2.855, 3.220> * sf  translate <0.232, 9.442, -7.188> }
     sphere{ <0,0,0>, 1, 1 scale <15.945, 15.945, 15.945> * sf  translate <0.000, 41.628, -0.502> }
     sphere{ <0,0,0>, 1, 1 scale <-4.073, -4.630, -4.060> * sf  translate <11.105, 30.082, -12.152> }
     sphere{ <0,0,0>, 1, 1 scale <-4.073, -4.630, -4.060> * sf  translate <-11.062, 30.082, -12.152> }
     sphere{ <0,0,0>, 1, 1 scale <7.591, 10.513, 10.513> * sf  translate <5.224, 44.199, -5.657> }
     sphere{ <0,0,0>, 1, 1 scale <7.591, 10.513, 10.513> * sf  translate <-4.510, 44.199, -5.657> }
     sphere{ <0,0,0>, 1, 1 scale <4.185, 5.157, 2.473> * sf  translate <-4.006, 15.524, -17.424> }
     sphere{ <0,0,0>, 1, 1 scale <5.266, 7.625, 5.313> * sf  translate <7.922, 24.464, -13.626> }
     sphere{ <0,0,0>, 1, 1 scale <4.185, 5.157, 2.473> * sf  translate <3.922, 14.507, -17.763> }
     translate <0,10,0>
     }



  
// -----------------------------------------------------------------------------------------
//                      S K U L L   C A P 
//------------------------------------------------------------------------------------------ 
//--- jack head blob expanded for skull cap
#declare head_expand =
#declare th = 0.5 ;
#declare sf = 2.05 ;
#declare nStrenth = -5 ;
#declare nSize = 1 ;
blob {
     threshold th
     sphere{ <0,0,0>, 1, 1 scale <15.672, 16.045, 14.649> * sf  translate <0.000, 41.534, 13.211> }
     sphere{ <0,0,0>, 1, 1 scale <13.178, 14.795, 14.795> * sf  translate <0.000, 21.942, -0.083> }
     sphere{ <0,0,0>, 1, 1 scale <9.257, 9.257, 9.257> * sf  translate <4.607, 37.774, -8.114> }
     sphere{ <0,0,0>, 1, 1 scale <9.257, 9.257, 9.257> * sf  translate <-5.193, 37.774, -8.114> }
     sphere{ <0,0,0>, 1, 1 scale <7.587, 3.765, 7.579> * sf  translate <0.000, 36.421, -9.407> }
     sphere{ <0,0,0>, 1, 1 scale <2.149, 3.765, 7.579> * sf  translate <0.000, 28.638, -14.002> }
     sphere{ <0,0,0>, 1, 1 scale <5.378, 2.457, 5.486> * sf  translate <-5.359, 37.097, -15.365> }
     sphere{ <0,0,0>, 1, 1 scale <5.378, 2.457, 5.486> * sf  translate <6.031, 37.266, -15.365> }
     sphere{ <0,0,0>, 1, 1 scale <5.266, 5.266, 5.313> * sf  translate <-8.074, 24.494, -15.578> }
     sphere{ <0,0,0>, 1, 1 scale <6.650, 6.646, 6.705> * sf  translate <-7.725, 25.346, -5.188> }
     sphere{ <0,0,0>, 1, 1 scale <6.650, 6.646, 6.705> * sf  translate <6.933, 25.346, -5.188> }
     sphere{ <0,0,0>, 1, 1 scale <5.266, 5.266, 5.313> * sf  translate <7.922, 24.464, -15.597> }
     sphere{ <0,0,0>, 1, 1 scale <9.821, 10.055, 9.180> * sf  translate <-0.000, 23.299, 5.109> }
     sphere{ <0,0,0>, 1, 1 scale <15.945, 15.945, 15.945> * sf  translate <0.000, 41.628, -0.502> }
     sphere{ <0,0,0>, 1, 1 scale <-4.073, -4.630, -4.060> * sf  translate <11.105, 30.082, -12.152> }
     sphere{ <0,0,0>, 1, 1 scale <-4.073, -4.630, -4.060> * sf  translate <-11.062, 30.082, -12.152> }
     sphere{ <0,0,0>, 1, 1 scale <-3.347, -3.090, -2.936> * sf  translate <-9.130, 32.522, -16.282> }
     sphere{ <0,0,0>, 1, 1 scale <-3.347, -3.090, -2.936> * sf  translate <9.130, 32.522, -16.282> }
     sphere{ <0,0,0>, 1, 1 scale <-4.190, -3.746, -2.936> * sf  translate <6.652, 33.946, -16.790> }
     sphere{ <0,0,0>, 1, 1 scale <-4.190, -3.746, -2.936> * sf  translate <-6.347, 33.946, -16.790> }
     sphere{ <0,0,0>, 1, 1 scale <7.591, 10.513, 10.513> * sf  translate <5.224, 44.199, -5.657> }
     sphere{ <0,0,0>, 1, 1 scale <7.591, 10.513, 10.513> * sf  translate <-4.510, 44.199, -5.657> } 
     translate <0,10,0>
     }
     
     
        
        
//--- cutter for cap forehead arch
#declare hair_cut =
union {
    cylinder { <0,0,0>,<0,0,1.00>,1 
         scale <11,21,50> rotate<0,0,0> translate<-8.5,40,-50>
         } 
    cylinder { <0,0,0>,<0,0,1.00>,1
         scale <11,21,50> rotate<0,0,0> translate<8.5,40,-50>
         } 
}         

#declare headcap =
difference {
    object {head_expand}
    object {hair_cut}
} 
     


#declare hairedge = 
union {
    sphere_sweep {
         cubic_spline
         12,
         <0.000, 43.198, -22.233> , 1.000
         <0.000, 43.198, -22.233> , 1.000
         <-1.986, 46.680, -21.641> , 1.000
         <-4.806, 49.411, -20.352> , 1.000
         <-9.220, 50.849, -18.464> , 1.000
         <-13.208, 49.230, -16.556> , 1.000
         <-16.527, 44.429, -14.139> , 1.000
         <-18.711, 37.514, -10.772> , 1.000
         <-18.675, 32.358, -7.696> , 1.000
         <-18.675, 30.454, -3.157> , 1.000
         <-18.675, 30.013, -0.361> , 1.000
         <-18.675, 30.013, -0.361> , 1.000
         translate <0,10,0>
         }
     sphere_sweep {
         cubic_spline
         12,
         <0.000, 43.198, -22.233> , 1.000
         <0.000, 43.198, -22.233> , 1.000
         <1.986, 46.680, -21.641> , 1.000
         <4.806, 49.411, -20.352> , 1.000
         <9.220, 50.849, -18.464> , 1.000
         <13.208, 49.230, -16.556> , 1.000
         <16.527, 44.429, -14.139> , 1.000
         <18.711, 37.514, -10.772> , 1.000
         <18.675, 32.358, -7.696> , 1.000
         <18.675, 30.454, -3.157> , 1.000
         <18.675, 30.013, -0.361> , 1.000
         <18.675, 30.013, -0.361> , 1.000
         translate <0,10,0>
         }    
}


// -----------------------------------------------------------------------------------------
//                      E Y E B A L L S
//------------------------------------------------------------------------------------------
#declare eyelid = 
union {
    difference {
        object { 
            sphere { <0,0,0> .5 }
            scale <8.6, 8.6, 8.6>
            
            }
        object { 
            sphere { <0,0,0> .5 }
            scale <9, 4, 20>
            translate <0,-.5,0> 
            }
    } 
  

    difference {
        object { 
            sphere { <0,0,0> .5 }
            scale <8.6, 8.6, 8.6>
            
            }
        object { 
            sphere { <0,0,0> .5 }
            scale <9, 6, 20>
            translate <0,1,0> 
            }
    } 
}


#declare eyelids = 
union {
    object {eyelid translate <-7.75, 42, -17.5> } 
    object {eyelid translate <7.75, 42, -17.5> }  
}
 

#declare eyes =
union {
    object { 
        eyeball2 // smaller eyeball for mechanical side
        scale <8, 8, 8> 
        rotate <-5,0,0>
        translate <-7.75, 42, -17.5> 
        }
    object { 
        eyeball
        scale <8, 8, 8>  
        rotate <-5,0,0>
        translate <7.75, 42, -17.5> 
        } 
    no_shadow           
}       
       
   
     

// -----------------------------------------------------------------------------------------
//                      R I G H T   S I D E   H E A D   (facing viewer)
//------------------------------------------------------------------------------------------   

#declare dowel_hole = 
object {
    cylinder { <-50,0,0>,<0,0,0>, 1 } 
}   



#declare head =
union {
    object {
        difference {  
            object { jack_head_parts }
            object { plane { <0,1,0>, 0 } }  
            } 
             
    }
    object {eyelids} 
    material {M_jack_face}
}    


   
#declare jack_head_right =  
union { 
    
    difference {
        union{
           object {head} 
           difference {
                union {
                object {headcap}
                object {hairedge}  
                }
                sphere {<0,0,0> 10 scale <1,1.2,1> translate <20.5,28,3>} //trim cap around ear 
                material {M_jack_cap}
           }
        }
        plane { <1,0,0> 0 }
        object { jack_head_void }
        object { dowel_hole translate <3, 70.5, 0>}   
        object { dowel_hole translate <3, 70, 15>}
        object { dowel_hole translate <3, 65.5, -15>} 
        
    }
}   



// -----------------------------------------------------------------------------------------
//                      M E C H A N I C A L    S I D E
//------------------------------------------------------------------------------------------ 

//---eye verital slot void cutter
#declare slot_1 =
sphere_sweep {
     cubic_spline
     5,
     <-7.750, 42.966, 0.000> , .794
     <-7.750, 42.966, 0.000> , .794
     <-7.750, 31.908, 0.000> , .794
     <-7.750, 24, 0.000> , .794
     <-.750,  24, 0.000> , .794
     tolerance 0.000001 
     scale <1,1,20> 
     translate <0,10,-10>
     }

//---temple void cutter
#declare slot_2 =
sphere_sweep {
     cubic_spline
     4,
     <-16.841, 43.929, 0.000> , 6.294
     <-16.841, 43.929, 0.000> , 6.294
     <-16.841, 59.305, 0.000> , 6.294
     <-16.841, 59.305, 0.000> , 6.294
     tolerance 0.000001 
     scale <1,1,30> 
     translate <0,10,0>
     }


//---nose void cutter
#declare slot_3 =
sphere_sweep {
     cubic_spline
     4,
     <0.000, 22.325, 0.000> , 3.5
     <0.000, 22.325, 0.000> , 3.5
     <0.000, 27.520, 0.000> , 1.5
     <0.000, 27.520, 0.000> , 1.5 
     tolerance 0.000001
     scale <1,1,10> 
     translate <0,10,-20>
     }               
     
     
//---mouth void cutter
#declare slot_4 =
sphere_sweep {
     cubic_spline
     4,
     < 3,  0, 0> , 0.3
     < 3,  0, 0> , 0.3
     <-3,  0, 0> , 0.3
     <-3,  0, 0> , 0.3
     tolerance 0.000001 
     scale <1,1,10> 
     translate <0,10,-20>
     
     }
     
     
     
//---inner mech temple
#declare jack_temple_plate =  
object {
    difference { 
        object {jack_head_frame_plate}
        object {jack_head_frame_plate_void}
        plane { <0,0,1>, 0 translate <0,0,-17>} 
        plane { <0,0,-1>, 0 translate <0,0,-5> } 
        plane { <0,1,0>, 42 }    
        cylinder { <0,0,-20>,<0,0,10>, .4 scale <13, 13, 1> translate <-7.75, 42, -17.5> } 
    }
}

//---inner mech temple
#declare jack_jaw_plate =  
object {
    difference { 
        object {jack_head_frame_plate}
        object {jack_head_frame_plate_void}
        plane { <0,1,0>, 24 }
        box { <-1, 0, -1>,< 1, 1, 1> scale <50,50,50> translate <0,27,0>}  
    }
}


#declare screw_pos_A = <-7.75, 55.5, -18> ;
#declare screw_pos_B = <-7.75, 33, -19> ;

 
//---flats for screws
#declare screw_spot_A =  
object { cylinder { <0,0,0>,<0,0,-10>, 1.7 translate screw_pos_A }}

#declare screw_spot_B = 
object { cylinder { <0,0,0>,<0,0,-10>, 1.7 translate screw_pos_B }}




#declare screw_head =  
object { 
difference {
    sphere { <0,0,0>, 1.1 scale <1,1,.7>} 
    box { <-.7, .15, 0>,< .7, -.15, -1> translate <0,0,-.5>} 
    box { <-.15, .7, 0>,< .15, -.7, -1> translate <0,0,-.5>}
    }
}






//---inner mechanical head
#declare jack_head_left =  
union {
    object {eyes}  
    object {jack_temple_plate} 
    object {jack_jaw_plate} 
    
    sphere { <0,0,0>, 3.5 translate <-1,18,-17> } //chin

    
    union { //neck 
        union {
            cylinder { <0,0,0>,  <0,22,0>, .75 } 
            cylinder { <0,0,0>,  <0,4,0>,  1.25 } 
            cylinder { <0,14,0>, <0,22,0>, 1.25 }
            rotate <0,0,-10> translate <-10,0,5>
        }
         union {
            cylinder { <0,0,0>,  <0,22,0>, .75 } 
            cylinder { <0,0,0>,  <0,4,0>,  1.25 } 
            cylinder { <0,14,0>, <0,22,0>, 1.25 }
            rotate <0,0,10> translate <10,0,5>
        }
        difference { 
            sphere { <0,0,0>, 6 translate <0,0,5> } 
            plane { <0,1,0>, 0 translate <0,0,0> }
        }    
        sphere { <0,0,0>, 4 translate <0,16,5> }
        cylinder { <0,0,0>,<0,16,0>, 2 translate <0,0,5>}
        difference {
            union {
                sphere { <0,0,0>, 8 translate <0,22,5> } 
                torus { 7.9, .8 rotate <0,0,0> translate <0,22,5> } 
            }   
            plane { <0,1,0>, 0 translate <0,17,0> }
            sphere { <0,0,0>, 4.5 translate <0,16,5> }
        }
    }

    
    union {
        difference { //mouth 
            union {
                cylinder { <0,0,-5>,<0,0,0>, 1  scale <6,2.5,1>      translate <0, 25, -16.5> }  
                torus { 1,.3 rotate<90,0,0>     scale <5.2,2.5,2.5>  translate <0, 25, -20> }
                torus { 9, 1.25 rotate<135,0,0>  scale <1,1,1>       translate <0, 25, -10> } 
            }
            object { slot_4 translate <0,14,0>} 
            object { slot_4 translate <0,15,0>}
            object { slot_4 translate <0,16,0>} 
            plane { <-1,0,0>, 0 }
        }  
        translate <0,-1,0>
    }
   
    //brain area
    torus { 13, .35 rotate<90,0,0>  scale <1,1,1> translate <2, 50, 15> } 
    torus { 13, .35 rotate<90,0,0>  scale <1,1,1> translate <2, 50, 13> }
    torus { 13, .35 rotate<90,0,0>  scale <1,1,1> translate <2, 50, 11> }
    torus { 13, .35 rotate<90,0,0>  scale <1,1,1> translate <2, 50, 9> }
    torus { 13, .35 rotate<90,0,0>  scale <1,1,1> translate <2, 50, 7> }
     
    difference {  //ear
        sphere {<0,0,0> 6.5 scale <.3,1,1> rotate <0,0,8> translate <-15.5,38.5,0>} 
        sphere {<0,0,0> 5 scale <1,1,1> translate <-20.5,38,0>}
        sphere {<0,0,0> 2 scale <10,1,1> translate <-20.5,38,0>}
        }
    
    //torus and pin around eye
    torus { 4, .3 rotate<90,0,0> translate <-7.75, 42, -17.5> } 
    cylinder { <-15,0,0>,<10,0,0>, 0.5 rotate<0,0,0> translate<0,42,-17.5> }
    cylinder { <-2,0,0>,<0,0,0>, 1 translate<-12,42,-17.5> }
    //tube around eye
    difference { 
        cylinder { <0,0,-2.5>,<0,0,10>, 6  translate <-7.75, 42, -18> } 
        cylinder { <0,0,-20>,<0,0,10>,  5  translate <-7.75, 42, -17.5> } 
        plane {<0,0,1>,0 rotate <0,15,0> translate <-7.5, 0, -20.5>}
    }
    
    //screws
    object { screw_head translate screw_pos_A}
    object { screw_head translate screw_pos_B}
    

    

    difference {
        object {jack_head_metal} 
        object { jack_head_void }
        cylinder { <0,0,-20>,<0,0,0>, 6  translate <-7.75, 42, -10> }
        object { slot_1 }   
        object { slot_2 } 
        object { slot_3 }
        plane { <0,1,0>, 27 } 
        sphere {<0,0,0> 7.5 translate <-18,38,0>}   //ear hole   
        sphere {<0,0,0> 1.5 scale <5,1,1> translate <-15,29.5,0>}   //ear hole 
        object { screw_spot_A } 
        object { screw_spot_B } 
        cylinder { <-20,0,0>,<0,0,0>, 2 translate <-9.8,65.5,0>} 
        cylinder { <-20,0,0>,<0,0,0>, .5 translate <-5,65.5,0>}
    } 
    

} 






// -----------------------------------------------------------------------------------------
//                      1/2  M E C H  -  1/2  P A I N T   J O B 
//------------------------------------------------------------------------------------------ 
#declare jack_head =  
union {
    object { jack_head_right }
    object { jack_head_left  material {M_default}} 
}                 