// jack in-the-box head
// m.miller 4.02.2023 

#version 3.8; 

global_settings {    
    max_trace_level 7
    ambient_light <.01,.01,.01> * 20
}                        


// -----------------------------------------------------------------------------------------
//                      I N C L U D E S
//------------------------------------------------------------------------------------------ 

#include "camera_rigs.inc" 
 

// -----------------------------------------------------------------------------------------
//                      S K Y
//------------------------------------------------------------------------------------------ 
background { rgb <0.10, 0.12, 0.13> } 
#declare show_fog = false ;
#declare world_clouds = false;


// -----------------------------------------------------------------------------------------
//                      L I G H T S
//------------------------------------------------------------------------------------------ 

#declare array_count = 8;

// --- S K Y  L I G H T
#declare light_A =
light_source {
    <0,0,0> 
    #declare light_color = color red .05 green .05 blue .05 ;                      
    light_color * 15                   
    area_light
    <50, 0, 0> <0, 0, 50>         
    array_count, array_count                          
    adaptive 0                    
    jitter                        
    circular                      
    orient                        
    translate <100, 200, -150>
}   
light_A

// --- B A C K   L I G H T
#declare light_B =
light_source {
    <0,0,0> 
    #declare light_color = color red .05 green .05 blue .05 ;                      
    light_color * 10                   
    area_light
    <50, 0, 0> <0, 0, 50>         
    array_count, array_count                          
    adaptive 0                    
    jitter                        
    circular                      
    orient                        
    translate <-200, 200, 30>
}   
light_B

// --- U N D E R  L I G H T
#declare light_C =
light_source {
    <0,0,0> 
    #declare light_color = color red .03 green .04 blue .05 ;                      
    light_color * 2                   
    area_light
    <50, 0, 0> <0, 0, 50>         
    array_count, array_count                          
    adaptive 0                    
    jitter                        
    circular                      
    orient                        
    translate <-100, -100, -100>
}   
light_C






// -----------------------------------------------------------------------------------------
//                      J A C K 
//------------------------------------------------------------------------------------------
#include "jack_head.inc"

object { jack_head rotate <0,0,0> }
//object { jack_head rotate <30,-40,0> }

#declare ref_plane =
object {
    box { <-30.00, 0.00, 20.00>,< 30.00, 80, 21> }  
}

//ref_plane   //---image map bounds
//object { eyeball scale <50,50,50> rotate <0,0,0>}


// -----------------------------------------------------------------------------------------
//                      C A M E R A S
//------------------------------------------------------------------------------------------
     
#declare ortho_fov = 1.6;   
#declare pers_fov = 30;

//render_sample (M_beetle_eye, 1)      

//render_plan(ortho_fov,0,-1)      
//render_ceiling(ortho_fov,50,-1)
render_front_elev(ortho_fov,0,36) 
//render_side_elev(ortho_fov,0,40) 
//render_top_left(pers_fov,<0,0,0>)                     
//render_bottom_left(pers_fov,<60,10,0>) 
//render_top_right(pers_fov,<10,20,0>) 
//render_ground_left(pers_fov,<0,21,0>) 

//render_view_A(pers_fov,<0,30,0>)  
//render_view_B(pers_fov,<5,15,0>)   
//render_view_C(pers_fov,<6,15,0>)
//render_view_D(pers_fov,<12,15,0>)   
