//--- requires predefined vars from scene file

// based on original Reorient() macro by John VanSickle
#macro Reorient_Trans(Axis1, Axis2)
   #local vX1 = vnormalize(Axis1);
   #local vX2 = vnormalize(Axis2);
   #local Y = vcross(vX1, vX2);
   #if(vlength(Y) > 0)
      #local vY = vnormalize(Y);
      #local vZ1 = vnormalize(vcross(vX1, vY));
      #local vZ2 = vnormalize(vcross(vX2, vY));
      transform {
         matrix < vX1.x, vY.x,vZ1.x, vX1.y,vY.y,vZ1.y, vX1.z,vY.z, vZ1.z, 0,0,0 >
         matrix < vX2.x,vX2.y,vX2.z,  vY.x,vY.y, vY.z, vZ2.x,vZ2.y,vZ2.z, 0,0,0 >
      }
   #else
      #if (vlength(vX1-vX2)=0)
         transform {}
      #else
         #local vZ = VPerp_To_Vector(vX2);
         transform { Axis_Rotate_Trans(vZ,180) }
      #end
   #end
#end

// Similar to Reorient_Trans(), points y axis along Axis.
#macro Point_At_Trans(YAxis)
   #local Y = vnormalize(YAxis);
   #local X = VPerp_To_Vector(Y);
   #local Z = vcross(X, Y);
   Shear_Trans(X, Y, Z)
#end



#macro pop_object ()
    //--- softcut
    #declare f_x = field_size.x;
    #declare f_y = start_height;
    #declare f_z = field_size.x;
    
    #declare x_offset = field_size.x/2;
    #declare z_offset = field_size.z/2;
    
    #declare Norm = <0,0,0>;
    #declare c = 0 ;


    union{ 
    // plant sphere -y
    #while (c < plant_count)                
    
           
            // create random point in space based on blob size
            #declare plant_pos = <f_x * rand(plant_seed), f_y, f_z * rand(plant_seed)>  ;
            
            // shift random points to match a centered field
            #declare start_pos =  < plant_pos.x - x_offset, plant_pos.y, plant_pos.z - z_offset> ; 
     
            // trace a ray for the random point -y and return norm data
            #declare ray = trace(plant_topo, start_pos, -y, Norm);
            
            #if ( Norm.gray!=0 & (vdot(Norm, y) > plant_maxSlope) & (ray.y > plant_minY) )
                // increment plant_current
                #declare c = c + 1;
                #declare new_pos =  <start_pos.x, ray.y+plant_offset ,start_pos.z> ;

                object { plant_object 
                
                    #if (random_size > 0) 
                        #declare i = 0;
                        #declare f = 0;
                        #while (f=0) 
                            #declare i = i + 1;
                            #declare r = rand(plant_seed);
                            //#debug concat ("> ", Str(i), "  -  ", Str(r), "\n") 
                            #if (r < random_size) #declare f = 1; #end  
                            //#if (i>100) #declare f = 1; #end  
                        #end 
                        scale plant_size*r
                    #else
                        scale  plant_size
                    #end
                    
                 
                    rotate y*(rand(plant_seed)*360) 
                    #if (rotate_to_normal = true) Reorient_Trans(y, Norm) #end
                    translate new_pos 
                    }
            #end
    #end    
    
   } 
#end







#macro pop_blob ()
    //--- softcut
    #declare f_x = field_size.x;
    #declare f_y = start_height;
    #declare f_z = field_size.x;
    
    #declare x_offset = field_size.x/2;
    #declare z_offset = field_size.z/2;
    
    #declare Norm = <0,0,0>;
    #declare c = 0 ;
blob {
    threshold blob_threshold 
    #while (c < plant_count)                
    
           
            // create random point in space based on blob size
            #declare plant_pos = <f_x * rand(plant_seed), f_y, f_z * rand(plant_seed)>  ;
            
            // shift random points to match a centered field
            #declare start_pos =  < plant_pos.x - x_offset, plant_pos.y, plant_pos.z - z_offset> ; 
     
            // trace a ray for the random point -y and return norm data
            #declare ray = trace(plant_topo, start_pos, -y, Norm);
            
            #if ( Norm.gray!=0 & (vdot(Norm, y) > plant_maxSlope) & (ray.y > plant_minY) )
                // increment plant_current
                #declare c = c + 1;
                #declare new_pos =  <start_pos.x, ray.y+plant_offset ,start_pos.z> ;
                #declare new_scale = blob_size ;
                
                #if (random_size > 0) 
                    #declare i = 0;
                    #declare f = 0;
                    #while (f=0) 
                        #declare i = i + 1;
                        #declare r = rand(plant_seed);
                        //#debug concat ("> ", Str(i), "  -  ", Str(r), "\n") 
                        #if (r < random_size) #declare f = 1; #end  
                        //#if (i>100) #declare f = 1; #end  
                    #end 
                    #declare new_scale = blob_size*r ;
                #end 
                sphere { <0,0,0>, 1 , 1  scale <new_scale, new_scale*blob_scaleY, new_scale> translate new_pos }
            #end
    #end    
} 
#end
 


#macro plant_random_spheres (sz, cnt, array_width, array_height, y_shift, rand_seed, r, mat, mat_scale) 
    #declare plant_current = 0 ;
    #while (plant_current < cnt) 
    
            #declare plant_object = object { 
                #if (r=1)
                    sphere { 
                        <0,0,0>, 
                        sz + (sz*rand(rand_seed))  
                        material { mat scale mat_scale} 
                        }
                #else
                    sphere { 
                        <0,0,0>, 
                        sz 
                        material { mat scale mat_scale} 
                        }
                #end
                } 
            // increment plant_current
            #declare plant_current = plant_current + 1;
            // create random point in space based on blob size
            #declare plant_pos = <array_width * rand(rand_seed), array_height*rand(rand_seed) , array_width * rand(rand_seed)>  ;
            // shift blob array to match position
            #declare start_pos =  < plant_pos.x-(array_width/2), plant_pos.y + y_shift, plant_pos.z-(array_width/2)> ;

            object { 
                plant_object 
                //no_shadow  
                rotate <360*rand(rand_seed),360*rand(rand_seed),360*rand(rand_seed) > 
                translate start_pos
                }

    #end    
#end