// beetle with blob plants
// m.miller 3.11.2023 

#version 3.8; 


global_settings {    
    max_trace_level 5
    ambient_light <.1,.02,.05> * 1
}                        

 

// -----------------------------------------------------------------------------------------
//                      I N C L U D E S
//------------------------------------------------------------------------------------------ 

#include "beetle_materials.inc"
#include "materials.inc"
#include "populate.inc" 
#include "dataPoints.inc"
#include "plant.inc"
#include "beetle.inc"
#include "tools.inc" 
#include "camera_rigs.inc" 

// -----------------------------------------------------------------------------------------
//                      S K Y
//------------------------------------------------------------------------------------------ 
background { rgb <0.10, 0.12, 0.13> } 
#declare show_fog = true ;
#declare world_clouds = false;
#include "sky.inc"
object { skydome no_shadow }



// -----------------------------------------------------------------------------------------
//                      L I G H T S
//------------------------------------------------------------------------------------------ 

#declare array_count = 16;

// --- S K Y  L I G H T
#macro light_A ()
light_source {
    <0,0,0> 
    #declare light_color = color red .05 green .05 blue .02 ;                      
    light_color * 7                   
    area_light
    <100, 0, 0> <0, 0, 100>         
    array_count, array_count                          
    adaptive 0                    
    jitter                        
    circular                      
    orient                        
    translate <100, 10, -50>
}   
#end
light_A()




//--- blown out point with short distance
#declare bud_light =
light_source {
    <0, 0, 0>      
    color rgb <.15,.3,.05> *500     
    fade_distance .2 
    fade_power 2
    translate y+1
    shadowless
}

#declare bug_light =
light_source {
    <0, 0, 0>      
    color rgb <.1,.3,.1> *100     
    fade_distance 1 
    fade_power 2
}  

//--- bug detail lighting
union { bug_light   translate <-44,10,62>   }
union { bug_light   translate <7,19,-15>    } 
union { bug_light   translate <-2,7,-37>    }  
union { bug_light   translate <10,9,-40>    } 
union { bug_light   translate <15,14,-30>   }  

// -----------------------------------------------------------------------------------------
//                      P L A N T S
//------------------------------------------------------------------------------------------ 


#declare eggPlant = sphere { <0,0,0> 1 material {bud_material scale 2 } scale <1.2,1.6,1.2> translate y+.4} ;
#declare mat = material { M_spotted_shroom scale .5} ;



#declare large_plants =
    union{
    #declare p = <0,-2,0>; 
    #declare r = 30;  
    union {
        object {plant material {mat}}
        plant_with_pointData(eggPlant,  0)  
        plant_with_pointData(bud_light, 1) 
        rotate <0,r,0> 
        translate p
    }
    
    
    #declare p = <60,0,10>; 
    #declare r = 140;  
    union {
        object {plant material {mat}}
        plant_with_pointData(eggPlant, 0)
        plant_with_pointData(bud_light, 1) 
        rotate <0,r,0>
        translate p 
    }
    
    
    #declare p = <-40,0,200>; 
    #declare r = 160;  
    union {
        object {plant material {mat}}
        plant_with_pointData(eggPlant, 0)
        plant_with_pointData(bud_light, 1)
        scale 1.5 
        rotate <0,r,0>
        translate p 
    }
    
    
    #declare p = <170,20,300>; 
    #declare r = 120;  
    union {
        object {plant material {mat}}
        plant_with_pointData(eggPlant, 0)
        plant_with_pointData(bud_light, 1)
        scale 3 
        rotate <0,r,0>
        translate p 
    } 
    
    
    #declare p = <-120,10,430>; 
    #declare r = 120;  
    union {
        object {plant material {mat}}
        plant_with_pointData(eggPlant,0)
        plant_with_pointData(bud_light, 1)
        scale 2 
        rotate <0,r,0>
        translate p 
    }
}

large_plants


// -----------------------------------------------------------------------------------------
//                      T O P O - dup front blobs for populating other objects
//------------------------------------------------------------------------------------------ 
#declare topo =
    union{
    #declare p = <0,-2,0>; 
    #declare r = 30;  
    union {
        object {plant material {mat}}
        rotate <0,r,0> 
        translate p
    }

    #declare p = <60,0,10>; 
    #declare r = 140;  
    union {
        object {plant material {mat}}
        rotate <0,r,0>
        translate p 
    }

}


// -----------------------------------------------------------------------------------------
//                      E G G 
//------------------------------------------------------------------------------------------ 

object { eggPlant rotate <0,0,40> scale 1.3 translate <-4,1,-35> }

    
       

// -----------------------------------------------------------------------------------------
//                      B E E T L E
//------------------------------------------------------------------------------------------ 

  
// --- front beetle
object { beetle scale <.4,.42,.4> rotate <-16,-38,15> translate <-3,.5,-36> }  


// --- back left beetle     
object { beetle scale <.6,.7,.6> rotate <0,-140,0> translate <-42,1,61> }       
            
// --- climbing beetle                
object { beetle scale <.4,.55,.4> rotate <-10,-58,-15> translate <7,20,-15> } 

 
 

// -----------------------------------------------------------------------------------------
//                      F L O O R
//------------------------------------------------------------------------------------------ 
#declare floor_plane = object{ plane{y,2} material{M_water_A scale 2} no_shadow} 
floor_plane



// -----------------------------------------------------------------------------------------
//                      U N D E R L A Y
//------------------------------------------------------------------------------------------

#declare img_scale = <100,100,.1> ; 
#declare img_rot = <90,0,0> ;
#declare img_pos = <0,0,-34> ;  
#declare mat = underlay_material;
//object { image_underlay() translate <0,.1,0>}      



// -----------------------------------------------------------------------------------------
//                      S M A L L   B E A D S
//------------------------------------------------------------------------------------------   
#declare mat = material { M_spotted_shroom scale .5} ;

//--- populate 
#declare plant_object = sphere{ <0,0,0> 1 scale <.7,.6,.7> } ;  
#declare plant_size = 2;
#declare random_size = .2 ; 
#declare field_size = <200,1,200>;
#declare plant_topo =  topo ;
#declare plant_count = 100000 ;     
#declare start_height = 25 ; 
#declare plant_randomY = true; 
#declare plant_offset = 0;
#declare plant_minY = 0 ;             
#declare plant_maxY = start_height ;  
#declare plant_maxSlope = .45 ;         // Max Y Slope (Norm Angle) on topo for planting.  
#declare plant_seed=seed(344) ;
#declare rotate_to_normal = true; 



//--- small beads
object { pop_object() material{mat} }






// -----------------------------------------------------------------------------------------
//                      C A M E R A S
//------------------------------------------------------------------------------------------
     
#declare ortho_fov = 8.5;   
#declare pers_fov = 70;

//render_sample (M_beetle_eye, 1)      

render_plan(ortho_fov,50,-1)      
//render_ceiling(ortho_fov,50,-1)
//render_front_elev(ortho_fov,0,50) 
//render_side_elev(ortho_fov,60,10) 

//render_top_left(pers_fov,<50,2,0>)                     
//render_bottom_left(pers_fov,<60,10,0>) 
//render_top_right(pers_fov,<60,2,0>) 
//render_ground_left(pers_fov,<30,50,0>) 

//render_view_A(pers_fov,<0,40,0>)  
//render_view_B(pers_fov,<5,15,0>)   
//render_view_C(pers_fov,<6,15,0>)

render_view_D(pers_fov,<12,15,0>)