// blob topo
// m.miller 1.3.2023 
// skydome  stage
#version 3.8; 
                                                    
           
#declare quality = 0;    
#declare use_area_lights = 1;    
#declare light_adaptive = 1; 
#declare Norm = <0,0,0>;

#include "fish_pipe_materials.inc"  
#include "plants.inc"
#include "populate.inc" 
#include "tools.inc"


global_settings {    
    max_trace_level 5
    ambient_light <.01,.05,.1> * 1.2
}                        


#declare default_material =  
material{ 
    texture {
        pigment{ rgb <0.6, 0.6, 0.5> } 
        finish {
            diffuse .9
            ambient .2
            reflection .05
        } 
    }    
} 


//---------------------------------------------------------------------------------   
//                               L I G H T S            
//--------------------------------------------------------------------------------- 

#declare use_lights = true;   
#declare light_array_count = 4;


//--- back right
#macro light()
    light_source {
      <0,0,0>                
      color rgb <.10,.16,.15> * 30      
      spotlight               
      translate <80,  40, -20> 
      point_at  < 0,  10, 20>   
      radius 20                
      tightness 10             
      falloff 14
      fade_distance 20
      fade_power 2               
    }
#end                    
#if (use_lights = true) light() #end 

   



// --- underlight
#macro light ()
    #declare light_color = color red .10 green .15 blue .13 ; 
    light_source {
        <0,0,0> 
        light_color * 2                   
        area_light
        <20, 0, 0> <0, 0, 20>         
        light_array_count, light_array_count                          
        adaptive 1                    
        jitter                        
        circular                      
        orient                        
        translate <-1, .3, -32> 
        fade_distance 3
        fade_power 2
    }   
#end
#if (use_lights = true) light() #end 



//--- main spot
#macro light()
    light_source {
      <0,0,0>                
      color rgb <.14,.16,.14> * 10      
      spotlight               
      translate <-30, 40, -30> 
      point_at <-4,5,-22>   
      radius 3                
      tightness 2             
      falloff 14
      //fade_distance 20
      //fade_power 2               
    }
#end
#if (use_lights = true) light() #end 


//---------------------------------------------------------------------------------   
//                               F O G            
//--------------------------------------------------------------------------------- 
#declare fog_color_tan = rgbft<0.35, 0.3, 0.25, 0.0, 0.0> ; 
#declare fog_color_gray = rgbft<0.17, 0.17, 0.17, 0.0, 0.0> ;
#declare fog_color_blue = rgbft<0.10, 0.27, 0.4, 0.0, 0.0>;
 

#declare show_fog = true;
#declare fog_color = fog_color_blue * .4; 
#declare fog_distance = 35;
#declare fog_turb = 2;
#declare fog_depth = 100; 
#declare fog_octaves = 100;
#declare fog_os = 5;

#if (show_fog = true) 
    fog {
        distance fog_distance
        color fog_color
        turbulence fog_turb  
        turb_depth fog_depth
        octaves fog_octaves   
        fog_offset fog_os  
        }
#end



camera {
    up <0, 1, 0>
    angle 75    
    location <-4.1, 2.2, -37>
    look_at <8 , 6.0, 0> 
} 


  
//---------------------------------------------------------------------------------   
//                               T O P O            
//--------------------------------------------------------------------------------- 
#declare topo_size = <100, 120, 100>;
#declare topo_pos = <-50, 0, -50>;
#declare topo_file =  "ground_displace_fish_14.png" ;
#declare topo_mat = material{M_ground_B scale .06}  

#macro make_topo()
    height_field{ 
       png  topo_file 
       smooth 
       scale topo_size 
    }   
#end
#declare topo = object {make_topo() translate topo_pos material{topo_mat scale 2} no_shadow} ;
topo  




//---------------------------------------------------------------------------------   
//                               F I S H            
//--------------------------------------------------------------------------------- 
#include "fish_14.inc"
object { fish14() scale <.8,1,1>  rotate <0,-115,0> translate <-1.9,2.1,-31.0> } 

object { fish14() scale <.8,1,1>  rotate <0,40,0> translate <7,4,-22.0> } 

    
    
   
//---------------------------------------------------------------------------------   
//                               P I P E S            
//--------------------------------------------------------------------------------- 
#include "pipe.inc" 

#declare crack =  
    difference{
        lathe{
            linear_spline  
            //bezier_spline
            12,
            <0.05, 0.01 >, 
            <0.02, 0.10 >, 
            <0.04, 0.22 >, 
            <0.02, 0.27 >, 
            <0.01, 0.57 >, 
            <0.04, 0.69 >, 
            <0.04, 1.03 >, 
            <0.09, 0.59 >, 
            <0.14, 0.53 >, 
            <0.07, 0.19 >, 
            <0.10, 0.10 >, 
            <0.05, 0.01 >
            }
    paper_Cut_Z
    }
    
#declare cracked_pipe =
object { 
difference {
      object { pipe_with_flange() material{M_rust_dent scale <3,3,3>}}
      object{ crack scale <2,3,500> translate <0,1,-1> texture {T_rust scale 2} }
      }
}


#declare pipes_in_water = 
union {
    object { cracked_pipe scale 2 rotate y*30 rotate x*70 translate <4,-1.5,-32>}
    object { cracked_pipe scale 2 rotate y+60 rotate x*-5 translate <-2,-6.8,-16> }   
}
pipes_in_water







//---------------------------------------------------------------------------------   
//                               W A T E R            
//--------------------------------------------------------------------------------- 
#declare water = object { plane{ <0,1,0>, .39} material{M_water_A scale .3} no_shadow} ;  
water







//--------------------------------------------------------------------------------------------
//                              T O P O  P O P U L A T E  
//--------------------------------------------------------------------------------------------

#declare use_populate = true;
#declare use_scatter = 0;

#if (use_populate = true)

    //--- random water bubbles
    #declare rand_seed = seed(187);
    //plant_random_spheres (.4, 1000, 100, 100, 5, rand_seed , 1, M_glass, 4) 



//--------------------------------------------------------------------------------------------
//                              B U B B L E   S T R E A M 
//--------------------------------------------------------------------------------------------
    //--- populate 
    #declare plant_object = object{ sphere{ <0,0,0>, 1.3 scale <.5,.5,.5>} material {M_glass}} ;  
    #declare plant_size = 1;
    #declare random_size = .85 ; 
    #declare field_size = <100,1,100>;
    #declare plant_topo =  topo ;
    #declare plant_count = 4000 ;     
    #declare start_height = 10 ; 
    #declare plant_randomY = true; 
    #declare plant_offset = -.2;
    #declare plant_minY = 1 ;             // Min Y elevation for planting. 0 = no restriction 
    #declare plant_maxY = start_height ;  // Max Y elevation for planting. 0 = no restriction  
    #declare plant_maxSlope = .2 ;         // Max Y Slope (Norm Angle) on topo for planting.  
    #declare plant_seed=seed(411) ;
    #declare rotate_to_normal = false; 

    object { pop_object() scale .5 translate <1,20,-10>}
    
    
//--------------------------------------------------------------------------------------------
//                              M U D 
//--------------------------------------------------------------------------------------------
    #declare blob_threshold = .6; 
    #declare blob_size = 1.5;
    #declare blob_scaleY = .69;
    #declare random_size = .75 ; 
    #declare field_size = <100,1,100>;
    #declare plant_topo =  topo ;
    #declare plant_count = 50000 ;     
    #declare start_height = 50 ; 
    #declare plant_randomY = true; 
    #declare plant_offset = -.1;
    #declare plant_minY = 5 ;             // Min Y elevation for planting. 0 = no restriction 
    #declare plant_maxY = start_height ;  // Max Y elevation for planting. 0 = no restriction  
    #declare plant_maxSlope = 0 ;         // Max Y Slope (Norm Angle) on topo for planting.  
    #declare plant_seed=seed(444) ;
    #declare rotate_to_normal = true; 

    #declare mud = object { pop_blob() material{M_ground_A scale .08}}  ;  
    mud
    
    //--- low mud 
    #declare blob_threshold = .3; 
    #declare blob_size = 1.5;
    #declare blob_scaleY = .65;
    #declare random_size = .75 ; 
    #declare field_size = <100,1,100>;
    #declare plant_topo =  topo ;
    #declare plant_count = 8000 ;     
    #declare start_height = 8 ; 
    #declare plant_randomY = true; 
    #declare plant_offset = -.1;
    #declare plant_minY = -2 ;             // Min Y elevation for planting. 0 = no restriction 
    #declare plant_maxY = start_height ;  // Max Y elevation for planting. 0 = no restriction  
    #declare plant_maxSlope = 0 ;         // Max Y Slope (Norm Angle) on topo for planting.  
    #declare plant_seed=seed(444) ;
    #declare rotate_to_normal = true; 

    #declare mud = object { pop_blob() material{M_ground_A scale .08}}  ;  
    mud       
          
//--------------------------------------------------------------------------------------------
//                              S H R O O M S 
//--------------------------------------------------------------------------------------------
    #declare shroomA = object {shroom }
    
    //--- populate
    #declare small_shroom = object {shroomA scale <.9,1.2,.9> } ; 
    #declare plant_object = small_shroom ;  
    #declare plant_size = 10;
    #declare random_size = .2 ; 
    #declare field_size = <100,1,100>;
    #declare plant_topo =  mud ;
    #declare plant_count = 9000 ;     
    #declare start_height = 30 ; 
    #declare plant_randomY = true; 
    #declare plant_offset = -.15;
    #declare plant_minY = .55 ;             // Min Y elevation for planting. 0 = no restriction 
    #declare plant_maxY = start_height ;  // Max Y elevation for planting. 0 = no restriction  
    #declare plant_maxSlope = .8 ;         // Max Y Slope (Norm Angle) on topo for planting.  
    #declare plant_seed=seed(149) ;
    #declare rotate_to_normal = true; 
    
    //--- shrooms
    object { pop_object() material{M_spotted_shroom scale .025} }
    
             
             
//--------------------------------------------------------------------------------------------
//                              W E E D S
//-------------------------------------------------------------------------------------------- 

    //--- populate 
    #declare plant_object = weed3 ;  
    #declare plant_size = 10;
    #declare random_size = .2 ; 
    #declare field_size = <100,1,100>;
    #declare plant_topo =  topo ;
    #declare plant_count = 15000 ;     
    #declare start_height = 30 ; 
    #declare plant_randomY = true; 
    #declare plant_offset = -.1;
    #declare plant_minY = 1.55 ;             
    #declare plant_maxY = start_height ;  
    #declare plant_maxSlope = .2 ;         // Max Y Slope (Norm Angle) on topo for planting.  
    #declare plant_seed=seed(344) ;
    #declare rotate_to_normal = true; 
    

    //--- weeds
    object { pop_object() material{M_spotted_weed scale .03 } }
           
    
//--------------------------------------------------------------------------------------------
//                              B E A D S 
//--------------------------------------------------------------------------------------------
    //--- populate 
    #declare plant_object = sphere{ <0,0,0> 1 scale <1.2,1.14,1.2> } ;  
    #declare plant_size = 2.5;
    #declare random_size = .2 ; 
    #declare field_size = <80,1,80>;
    #declare plant_topo =  topo ;
    #declare plant_count = 2000 ;     
    #declare start_height = 20 ; 
    #declare plant_randomY = true; 
    #declare plant_offset = 0;
    #declare plant_minY = 0 ;             
    #declare plant_maxY = start_height ;  
    #declare plant_maxSlope = .2 ;         // Max Y Slope (Norm Angle) on topo for planting.  
    #declare plant_seed=seed(344) ;
    #declare rotate_to_normal = true; 
    

    //--- large beads
    object { pop_object() material{topo_mat} }
      

    //--- populate 
    #declare plant_object = sphere{ <0,0,0> 1 scale <.2,.14,.2> } ;  
    #declare plant_size = 2.5;
    #declare random_size = .2 ; 
    #declare field_size = <80,1,80>;
    #declare plant_topo =  topo ;
    #declare plant_count = 100000 ;     
    #declare start_height = 5 ; 
    #declare plant_randomY = true; 
    #declare plant_offset = 0;
    #declare plant_minY = 0 ;             
    #declare plant_maxY = start_height ;  
    #declare plant_maxSlope = .5 ;         // Max Y Slope (Norm Angle) on topo for planting.  
    #declare plant_seed=seed(344) ;
    #declare rotate_to_normal = true; 
    
    

    //--- small beads
    object { pop_object() material{topo_mat} }
         
    //--- populate 
    #declare plant_object = sphere{ <0,0,0> 1 scale <.2,.14,.2> } ;  
    #declare plant_size = 2.5;
    #declare random_size = .2 ; 
    #declare field_size = <80,1,80>;
    #declare plant_topo =  mud ;
    #declare plant_count = 100000 ;     
    #declare start_height = 15 ; 
    #declare plant_randomY = true; 
    #declare plant_offset = 0;
    #declare plant_minY = 0 ;             
    #declare plant_maxY = start_height ;  
    #declare plant_maxSlope = .5 ;         // Max Y Slope (Norm Angle) on topo for planting.  
    #declare plant_seed=seed(344) ;
    #declare rotate_to_normal = true; 
    
    

    //--- small beads
    object { pop_object() material{topo_mat} }
     
//--------------------------------------------------------------------------------------------
//                              B U B B L E   C R A C K S 
//--------------------------------------------------------------------------------------------
    
    #declare cone_topo =
    cone { 
        <0,0,0>, .5,
        <0,7,0>, .01
    }
    
    
    //--- populate 
    #declare plant_object = object{ sphere{ <0,0,0>, 1 scale <.2,.2,.2>} material {M_glass}} ;  
    #declare plant_size = 1;
    #declare random_size = .95 ; 
    #declare field_size = <10,1,10>;
    #declare plant_topo =  cone_topo ;
    #declare plant_count = 30 ;     
    #declare start_height = 20 ; 
    #declare plant_randomY = true; 
    #declare plant_offset = -.2;
    #declare plant_minY = 0 ;             // Min Y elevation for planting. 0 = no restriction 
    #declare plant_maxY = start_height ;  // Max Y elevation for planting. 0 = no restriction  
    #declare plant_maxSlope = 0 ;         // Max Y Slope (Norm Angle) on topo for planting.  
    #declare plant_seed=seed(411) ;
    #declare rotate_to_normal = false; 
    

    #declare crack_bubble = object { pop_object() rotate z*180 translate <3,7.5,-29> } ;
    crack_bubble
    

    #declare cone_topo =
    cone { 
        <0,0,0>, .28,
        <0,9,0>, .005
    }
    
    
    //--- populate 
    #declare plant_object = object{ sphere{ <0,0,0>, 1 scale <.05,.05,.05>} material {M_glass}} ;  
    #declare plant_size = 1;
    #declare random_size = .85 ; 
    #declare field_size = <10,1,10>;
    #declare plant_topo =  cone_topo ;
    #declare plant_count = 600 ;     
    #declare start_height = 20 ; 
    #declare plant_randomY = true; 
    #declare plant_offset = -.2;
    #declare plant_minY = 0 ;             // Min Y elevation for planting. 0 = no restriction 
    #declare plant_maxY = start_height ;  // Max Y elevation for planting. 0 = no restriction  
    #declare plant_maxSlope = 0 ;         // Max Y Slope (Norm Angle) on topo for planting.  
    #declare plant_seed=seed(411) ;
    #declare rotate_to_normal = false; 
    
    #declare crack_bubble = object { pop_object() rotate z*180 translate <3,8,-29> } ;
    crack_bubble


//--------------------------------------------------------------------------------------------
//                              B U B B L E S   O N   P I P E 
//--------------------------------------------------------------------------------------------
    //--- populate 
    #declare plant_object = object{ sphere{ <0,0,0>, 1 scale <.15,.15,.15> } material {M_glass}} ;  
    #declare plant_size = 1;
    #declare random_size = .995 ; 
    #declare field_size = <100,1,100>;
    #declare plant_topo =  pipes_in_water ;
    #declare plant_count = 200 ;     
    #declare start_height = 20 ; 
    #declare plant_randomY = true; 
    #declare plant_offset = .1;
    #declare plant_minY = 0 ;             // Min Y elevation for planting. 0 = no restriction 
    #declare plant_maxY = start_height ;  // Max Y elevation for planting. 0 = no restriction  
    #declare plant_maxSlope = .1 ;         // Max Y Slope (Norm Angle) on topo for planting.  
    #declare plant_seed=seed(411) ;
    #declare rotate_to_normal = false; 
    
    #declare crack_bubble = object { pop_object() } ;
    crack_bubble
    
    

#end  //-------   END POPULATE










// -----------------------------------------------------------------------------------------
//                      S A M P L E    M A T E R I A L
//------------------------------------------------------------------------------------------  


#declare render_samples = false;
#declare mat1 = material {M_rust_paint scale 1.5}
#declare mat2 = material {M_rust_brush scale 1}
#declare mat3 = material {M_rust_dent scale 1}


#if (render_samples = true)
     
    camera {
        up <0, 1, 0>
        angle 65    
        location <0, 2, -5>
        look_at <0 , 0, 0> 
    } 

    light_source {
      <0,0,0>                
      color rgb <.14,.16,.14> * 7      
      spotlight               
      translate <-20, 20, -20> 
      point_at <0,0,0>   
      radius 3                
      tightness 2             
      falloff 14
      }

    light_source {
      <0,0,0>                
      color rgb <.14,.16,.14> * 3      
      spotlight               
      translate <20, -20, -10> 
      point_at <0,0,0>   
      radius 3                
      tightness 2             
      falloff 14
      }
      
      
    object { sphere { <-2,0,0> 1 }  material {mat1} hollow } 
    object { sphere { <0,0,0> 1 }   material {mat2} hollow }
    object { sphere { <2,0,0> 1 }   material {mat3} hollow } 
    
#end








