/* toa_lib.inc
 *
 * provides macros + constant data for the 'toa' demo scene/animation.
 *
 * Persistence of Vision Raytracer version 3.8 or later.
 *
 * version: 202109.2
 */

#ifndef (toal__include_temp)

#declare toal__include_temp = version;

#version 3.8;

#ifdef (View_POV_Include_Stack)
#debug "including 'toa_lib.inc'\n"
#end

/* -----[constants etc]------------------------------------------------------ *
 * colours  - blue, green, cyan, red, yellow, white (~dead), black.
 * compass  - nesw.
 * files    - state, log.  (edit)
 * rrand    - modified 'rand.inc:RRand()'.
 */

#declare toal__data_colours_ = array [7] {
  <0,0,1>, <0,1,0>, <0,1,1>, <1,0,0>, <1,1,0>, <1,1,1>, <0,0,0>
};

#declare toal__data_cnames_ = array [7] {
  "blue", "green", "cyan", "red", "yellow", "white", "black"
};

#declare toal__data_compass_ = array [4] {
  "north", "east", "south", "west"
};

#declare toal__data_files_ = array [2] {"toa_state.txt", "toa_run.log"};

#macro toal__rrand(lo_,hi_,rng_) int(rand(rng_)*(hi_-lo_) + lo_) #end

/* cannot, apparently, preserve RNG state between frames.
 * cannot even access '[global.]rng_', when declared!  </sigh>
 */
#macro toal__wind2frame(rng_)
  #for (i_,0,frame_number) #local v_ = rand(rng_); #end
#end

/* test whether max "damage" ("black") */
#macro toal__maxDamage(v_) (!(6 > v_)) #end

/* test whether both objs occupy same pos */
#macro toal__chkCollide(p1_,p2_)
  (p1_.x = p2_.x & p1_.y = p2_.y)
#end

#macro toal__chkPos(i_,sd_,ld_)
  #if (toal__chkCollide(sd_.Data[0][0],sd_.Data[1][0]))
    #local ld_.Data[dimension_size(ld_.Data,1)] =
        concat("obj [",str(i_,0,0),"] collided.");
    #local sd_.Data[i_][2] = sd_.Data[i_][2] + 1;
  #end
#end

/* test for existence of both, or neither, state and log files,
 * depending on flag.
 */
#macro toal__chkFilesExist(exist_)
  #local fs_ = file_exists(concat(fild_workingDir,toal__data_files_[0]));
  #local fl_ = file_exists(concat(fild_workingDir,toal__data_files_[1]));
  #if (exist_)
    #local r_ = (fs_ & fl_);
  #else
    #local r_ = (!(fs_ | fl_));
  #end
  r_
#end

/* add a log entry */
#macro toal__addLog(sd_,ld_)
  #local t_ = concat("[",str(frame_number,-4,0),"]");
  #for (i_,0,1)
    #local s_ = concat(t_, "[", str(i_,0,0), "] <",
        vstr(2,sd_.Data[i_][0],",",0,0), "> ",
        toal__data_compass_[sd_.Data[i_][1]], " ",
        toal__data_cnames_[sd_.Data[i_][2]], "");
    #local ld_.Data[dimension_size(ld_.Data,1)] = s_;
  #end
#end

/* three types of move: MM, ML, and MR, move two squares in facing
 * direction, or move one square and turn either left or right.
 */
#macro toal__doMove(pos_,df_)
  #local x_ = pos_.x;  #local y_ = pos_.y;
  #switch (df_)
    #case (0) #local y_ = mod((1 + y_),area_.y);           #break
    #case (1) #local x_ = mod((1 + x_),area_.x);           #break
    #case (2) #local y_ = mod((area_.y + y_ - 1),area_.y); #break
    #case (3) #local x_ = mod((area_.x + x_ - 1),area_.x); #break
    #else
      #error "oops, \"cannot happen\" error in '__doMove()'."
  #end
  <x_,y_>
#end

#macro toal__doTurn(df_,left_)
  #if (left_)
    #local n_ = mod((4 + df_ - 1),4);
  #else
    #local n_ = mod((df_ + 1),4);
  #end
  n_
#end

#macro toal__moveMM(p_,df_)
  #local a_ = toal__doMove(p_,df_);
  #local a_ = toal__doMove(a_,df_);
  (a_,df_)
#end

#macro toal__moveML(p_,df_)
  #local a_ = toal__doMove(p_,df_);
  #local b_ = toal__doTurn(df_,true);
  (a_,b_)
#end

#macro toal__moveMR(p_,df_)
  #local a_ = toal__doMove(p_,df_);
  #local b_ = toal__doTurn(df_,false);
  (a_,b_)
#end

/* the "robots".  use separate RNGs and methods to select move.
 * both log choice.  uncomment lines in 'obj1' to bias choice.
 */
#macro toal__obj0(self_,ld_)
  #local rng_ = seed(self_[3]);
  toal__wind2frame(rng_)
  #local r_ = 1 + mod(toal__rrand(1,100,rng_),3);
  #if (3 = r_)
    #local (self_[0],self_[1]) = toal__moveML(self_[0],self_[1]);
    #local s_ = "turn left";
  #elseif (2 = r_)
    #local (self_[0],self_[1]) = toal__moveMR(self_[0],self_[1]);
    #local s_ = "turn right";
  #else
    #local (self_[0],self_[1]) = toal__moveMM(self_[0],self_[1]);
    #local s_ = "move";
  #end
  #local ld_.Data[dimension_size(ld_.Data,1)] = concat("[0] - move + ",s_);
#end

#macro toal__obj1(self_,ld_)
  #local r_ = 1 + mod(frame_number,3);
//#if (2 = r_)
//  #local rng_ = seed(self_[3]);
//  toal__wind2frame(rng_)
//  #local r_ = 1 + mod(toal__rrand(1,100,rng_),3);
//#end
  #if (3 = r_)
    #local (self_[0],self_[1]) = toal__moveML(self_[0],self_[1]);
    #local s_ = "turn left";
  #elseif (2 = r_)
    #local (self_[0],self_[1]) = toal__moveMR(self_[0],self_[1]);
    #local s_ = "turn right";
  #else
    #local (self_[0],self_[1]) = toal__moveMM(self_[0],self_[1]);
    #local s_ = "move";
  #end
  #local ld_.Data[dimension_size(ld_.Data,1)] = concat("[1] - move + ",s_);
#end

#version toal__include_temp;

#end

/* -------------------------------------------------------------------- *
  * the content above is covered by the GNU General Public License v3+ * 
  * copyright (c) 2021 jr <creature.eternal@gmail.com>.                * 
  * all rights reserved.                                               * 
 * -------------------------------------------------------------------- */
