// ex3.pov - 1D array of array mixed.
// +w800 +h600 +am3 +a0.01 +ac0.975 -j +q11

#version 3.8;

global_settings {assumed_gamma 1}

/* the example data file was designed to show all "types" of field
 * in use.  only two of the four vector types are included, the
 * smallest and largest.  the "data" facilitates a visual check.
 * uncomment the range to "filter" the records.
 * since the same (format) record is used everywhere, declare it once.
 */
#declare record_ = array [6] {"B","V20","I","S","F1","V52"};

#include "filed.inc"

#declare DR = dictionary {
  .File     : "ex3.txt",
  .Access   : "read",
  .Fields   : record_,
  .hasNames : true,
//.Range    : array [2] {2,5},
  .Verbose  : true
};

Filed(DR)

/* if you do have 'tabulated.inc' installed, edit the '#if' guard to
 * read '1' and the file data will be shown as a table, otherwise,
 * again sorry to say, it is just "boring" text-only output.
 */

#if (0)

  #include "tabulated.inc"

  #declare DT = dictionary {
    .DataColumns : record_,
    .DataTable   : DR.Data,
    .ColLabels   : DR.Names,
    .Emissive    : true,
    .Verbose     : true
  };

  object {
    Tabulated(DT)
    scale .25
    translate <-2.9,1.75,0>
  }

  camera {
    location <0,0,-5>
    right x * (4/3)
    up y
    look_at <0,0,0>
  }

#else

  box {0,1}  /* dummy object suppresses warning */

  #macro m_rcd(i_,a_)
    #local s_ = concat("#",str(i_,0,0)," bool '",str(a_[0],0,0),"' ",
            "v2 <",vstr(2,a_[1],",",0,0),"> int ",str(a_[2],0,0));
    #local s_ = concat(s_," str '",a_[3],"' flt ",str(a_[4],0,1),
            " v5 <",vstr(5,a_[5],",",0,2),">\n");
    #debug s_
  #end

  /* ideal for 'Foreach()'.  ;-) */
  #for (i_,0,dimension_size(DR.Data,1)-1)
    m_rcd(i_,DR.Data[i_])
  #end

#end

/* set the '#if' for this section to '1' to enable writing of the data
 * read, that is, to allow a test comparing the data files.
 * remember to adjust the working directory, if used.
 */

#if (0)

//#declare fild_workingDir = "/tmp/";

  #declare DW = dictionary {
    .File     : concat("new_",DR.File),
    .Access   : "write",
    .Fields   : record_,
    .Data     : DR.Data,
    .hasNames : true,
    .Names    : DR.Names,
    .Verbose  : true
  };

  Filed(DW)

#end

