// flowers.pov - Planting red and yellow flowers on an asteroid
// showing the use of writing and appending data to a
// dictionary file
// +w800 +h600 +am2 +a0.1 +r2 -j +q11

#version 3.8;

global_settings {assumed_gamma 1}

#include "transforms.inc"
#include "rand.inc"
#include "filed.inc"

camera { 
   location  <0, 0, -7> 
   look_at <0, 0, 0> 
   angle 50   
   right x*image_width/image_height
}

//-----------------------------------------------Garden Stuff

#declare Target = blob {  //asteroid
  threshold 0.3
  sphere { <0.75, 0, 0>, 1, 1 }
  sphere { <-0.375, 0.64952, 0>, 1, 1 }
  sphere { <-0.375, -0.64952, 0>, 1, 1 }
  scale 1
  rotate 25
  pigment {rgb <0.4, 0.3, 0.1>}
  finish {diffuse 0.7 emission 0.1}
  normal {granite 0.5 scale 0.3}
};

#declare Flower1 = union {  //red flower
  cylinder {
    <0.0, 0.0, 0.0>, <0.0, 0.01, 0.0>, 0.05
    pigment {rgb <0.5, 0.1, 0>}
    finish {diffuse 0.7 emission 0.1}
    normal {granite 0.2 scale 0.001}
    translate 0.3*y
  }
  cylinder {
    <0.0, 0.0, 0.0>, <0.0, 0.3, 0.0>, 0.01
    pigment {rgb <0.1, 0.5, 0>}
    finish {diffuse 0.7 emission 0.1}
    normal {granite 0.2 scale 0.001}
  }
};

#declare Flower2 = union {  //yellow flower
  cylinder {
    <0.0, 0.0, 0.0>, <0.0, 0.01, 0.0>, 0.05
    pigment {rgb <0.5, 0.5, 0>}
    finish {diffuse 0.7 emission 0.1}
    normal {granite 0.2 scale 0.001}
    translate 0.25*y
  }
  cylinder {
    <0.0, 0.0, 0.0>, <0.0, 0.25, 0.0>, 0.01
    pigment {rgb <0.1, 0.5, 0>}
    finish {diffuse 0.7 emission 0.1}
    normal {granite 0.2 scale 0.001}
  }
};

#declare Flower3 = union {  //blue flower

  cylinder {
    <0.0, 0.0, 0.0>, <0.0, 0.01, 0.0>, 0.05
    pigment {rgb <0, 0, 0.5>}
    finish {diffuse 0.7 emission 0.1}
    normal {granite 0.2 scale 0.001}
    translate 0.2*y
  }
  cylinder {
    <0.0, 0.0, 0.0>, <0.0, 0.2, 0.0>, 0.01
    pigment {rgb <0.1, 0.5, 0>}
    finish {diffuse 0.7 emission 0.1}
    normal {granite 0.2 scale 0.001}
  }
};

//-----------------------------------------------Red flower planting
/*
 * 'Write' 'red' flowers to a new data set
 */

#declare R           = seed(2943);
#declare RedFlowers  = 400;
#declare RedData_    = array [RedFlowers];
#declare RedDebug    = off;

#declare Hits1 = union {
  #for(Nr, 0, RedFlowers-1, 1)
    #declare Planter = VRand_On_Sphere(R)*2;
    #declare Norm = <0, 0, 0>; 
    #declare Hit  = trace(Target, Planter, <0.0, 0.0, 0.0>-Planter, Norm);
    object {Flower1 Reorient_Trans(y,Norm) translate Hit }
    #if (RedDebug)
      #debug concat ("\nNr: ", str(Nr, 2, 0), "\n")
      #debug concat ("Planter: <", vstr(3, Planter, ", ", 3, 3), ">\n")
      #debug concat ("Norm: <", vstr(3, Norm, ", ", 3, 3), ">\n")
      #debug concat ("Hit: <", vstr(3, Hit, ", ", 3, 3), ">\n") 
    #end
    #declare RedData_ [Nr] = array mixed [5] {Nr,Planter,Hit,Norm,"Red"};
  #end
};

//Writing dictionary:
#declare DW = dictionary {
  .File    : "flowers.txt",
  .Access  : "w",
  .Strict  : true,
  .Fields  : array [5] {"I","V33","V33","V33","S"},
  .hasNames: true,
  .Names   : array [5] {"Count","Planter","Hit","Norm","Colour"},
  .Data    : RedData_,
  .Verbose : true
};

Filed(DW)

//-----------------------------------------------Table of red flowers data
/*
 * if you do have 'tabulated.inc' installed, edit the '#if' guard to
 * read '1' and the file data will be shown as a table, otherwise,
 * sorry to say, it is just a "boring" black background.
 */

#if (0)

  #include "tabulated.inc"

  //Tabulating dictionary:
  #declare DT = dictionary {
    .DataColumns : DW.Fields,
    .DataTable   : DW.Data,
    .ColLabels   : DW.Names,
    .Emissive    : false,
    .Verbose     : true
  };

  object {
    Tabulated(DT)
    scale 0.3
    translate <-5.35, 4.0, 5>
  }

#end

//-----------------------------------------------Yellow flower planting
/*
 * 'Append' 'yellow' flowers to the data for 'red' flowers
 */
 
#declare R             = seed(4385);
#declare YellowFlowers = 300;
#declare YellowData_   = array [YellowFlowers];
#declare YellowDebug   = off;

#declare Hits2 = union {
  #for(Nr, 0, YellowFlowers-1, 1)
    #declare Planter = VRand_On_Sphere(R)*2;
    #declare Norm = <0, 0, 0>; 
    #declare Hit  = trace(Target, Planter, <0.0, 0.0, 0.0>-Planter, Norm);
    object {Flower2 Reorient_Trans(y,Norm) translate Hit }
    #if (YellowDebug)
      #debug concat ("\nNr: ", str(Nr, 2, 0), "\n")
      #debug concat ("Planter: <", vstr(3, Planter, ", ", 3, 3), ">\n")
      #debug concat ("Norm: <", vstr(3, Norm, ", ", 3, 3), ">\n")
      #debug concat ("Hit: <", vstr(3, Hit, ", ", 3, 3), ">\n") 
    #end
    #declare YellowData_ [Nr] = array mixed [5] {Nr+RedFlowers,Planter,Hit,Norm,"Yellow"};
  #end
};

//Appending dictionary:
#declare DA = dictionary {
  .File    : DW.File,
  .Access  : "a",
  .Strict  : true,
  .Fields  : DW.Fields,
  .hasNames: true,
  .Names   : DW.Names,
  .Data    : YellowData_,
  .Verbose : true
};

Filed(DA)

//-----------------------------------------------Blue flower planting
/*
 * Obviously, you can generate multiple 'appends' to your file, you 
 * need however, to add a 'blue' flower object, and change accordingly
 * some of the lines. By editing the '#if' guard to read '1', you
 * can add the 'blue' flowers. By comparing the code below with those
 * for the 'red' and the 'yellow' flowers, you have a template for
 * adding as many different flowers as you want.
 */

#if (0)

  #declare R           = seed(9012);
  #declare BlueFlowers = 100;
  #declare BlueData_   = array [BlueFlowers];
  #declare BlueDebug   = off;

  #declare Hits3 = union {
    #for(Nr, 0, BlueFlowers-1, 1)
      #declare Planter = VRand_On_Sphere(R)*2;
      #declare Norm = <0, 0, 0>; 
      #declare Hit  = trace(Target, Planter, <0.0, 0.0, 0.0>-Planter, Norm);
      object {Flower3 Reorient_Trans(y,Norm) translate Hit }
      #if (BlueDebug)
        #debug concat ("\nNr: ", str(Nr, 2, 0), "\n")
        #debug concat ("Planter: <", vstr(3, Planter, ", ", 3, 3), ">\n")
        #debug concat ("Norm: <", vstr(3, Norm, ", ", 3, 3), ">\n")
        #debug concat ("Hit: <", vstr(3, Hit, ", ", 3, 3), ">\n") 
      #end
      #declare BlueData_ [Nr] = array mixed [5] {Nr+RedFlowers+YellowFlowers,Planter,Hit,Norm,"Blue"};
    #end
  };

  //Appending dictionary:
  #declare DA = dictionary {
    .File    : DW.File,
    .Access  : "a",
    .Strict  : true,
    .Fields  : DW.Fields,
    .hasNames: true,
    .Names   : DW.Names,
    .Data    : BlueData_,
    .Verbose : true
  };

  Filed(DA)

#end

//-----------------------------------------------Reading flower data
/*
 * Reading and using the data saved by the 'write' and 'append'
 * dictionaries can be experimented with in the scene file flowers_read.pov.
 */

//-----------------------------------------------Show hits on target
light_group {
  light_source {<15, 25, -25> color 1.0*2}
  Target
  Hits1
  Hits2
}

