// ex1.pov - single column 1D array.
// +w800 +h600 +am3 +a0.01 +ac0.975 -j +q11

#version 3.8;

global_settings {assumed_gamma 1}

/* the example data file lists words, one per line/record.
 * it has no column label row.  given that '.Verbose' is optional,
 * the macro only needs the info you have to have anyway.
 * after the call, the data becomes available in '.Data[]'.
 * since the same (format) record is used everywhere, declare it once.
 */
#declare record_ = array [1] {"S"};

#include "filed.inc"

#declare DR = dictionary {
  .File    : "ex1.txt",
  .Access  : "read",
  .Fields  : record_,
  .Verbose : true
};

Filed(DR)

/* if you do have 'tabulated.inc' installed, edit the '#if' guard to
 * read '1' and the file data will be shown as a table, otherwise,
 * sorry to say, it is just "boring" text-only output.
 */

#if (0)

  #include "tabulated.inc"

  #declare DT = dictionary {
    .DataColumns : record_,
    .DataTable   : DR.Data,
    .Emissive    : true,
    .Verbose     : true
  };

  object {
    Tabulated(DT)
    scale .5
    translate <-1.5,1.75,0>
  }

  camera {
    location <0,0,-5>
    right x * (4/3)
    up y
    look_at <0,0,0>
  }

#else

  box {0,1}  /* dummy object suppresses warning */

  #for (i_,0,dimension_size(DR.Data,1)-1)
    #debug concat("line ",str((1+i_),0,0)," = '",DR.Data[i_],"'.\n")
  #end

#end

/* set the '#if' for this section to '1' to enable writing of the data
 * read, that is, to allow a test comparing the data files.
 * remember to adjust the working directory, if used.
 */

#if (0)

//#declare fild_workingDir = "/tmp/";

  #declare DW = dictionary {
    .File    : concat("new_",DR.File),
    .Access  : "write",
    .Fields  : record_,
    .Data    : DR.Data,
    .Verbose : true
  };

  Filed(DW)

#end

