// toa - two objects animated demo.
// +w960 +h600 +am3 +a0.01 +ac0.975 -j +q11

#version 3.8;

global_settings {assumed_gamma 1}

/* may need adjusting along with 'area' */
camera {
  location <0,5,-10>
  right x * (16/10)
  up y
  angle 40
  look_at <2,0,2>
}

light_source {<-1,1,-1> * 1e3 color srgb 1 parallel}
light_source {<1,1,-1> * 1e3 color srgb 1 parallel}

/* ideally use a RAM disk.  want same path in .ini file */
//#declare fild_workingDir = "/tmp/toa/";

/* size of arena: <cols, rows> */
#declare area_ = <5,3>;

/* initial positions of objects: <col, row> */
#declare init_pos_ = array [2] {<1,2>,<4,1>};

/* per object rng seeds */
#declare init_seeds_ = array [2] {54321,45678};

/* the code below is a large-ish '#if() ... #else ... #end' followed
 * by the bits that render.  the condition is whether the current frame
 * is the very first ('0'), in which case basically "setup" happens, or
 * not, in which case each object gets one move in turn.  the "state"
 * is stored to file between frames, and everything (almost) is logged
 * to file.  the render places the objects in the arena.
 */
#include "filed.inc"
#include "ruled.inc"
#include "toa_lib.inc"

/* state, per object: {pos, face, color, rng} */
#declare record_ = array [4] {"V20","I","I","I"};

/* logging */
#declare logd_ = dictionary {
  .Fields  : array [1] {"S"},
  .File    : toal__data_files_[1],
  .Access  : "a",
  .Data    : array,
  .Verbose : true
};

#if (frame_number)
  #if (!toal__chkFilesExist(true))
    #error concat("oops, missing file(s) in frame #",str(frame_number,0,0),".")
  #end
  /* read state */
  #declare sttd_ = dictionary {
    .Fields  : record_,
    .File    : toal__data_files_[0],
    .Access  : "r",
    .Verbose : true
  };
  Filed(sttd_)
  /* "dead"? */
  #if (toal__maxDamage(sttd_.Data[0][2]) | toal__maxDamage(sttd_.Data[1][2]))
    #error "oops, one object has .. expired."
  #end
  /* tick objects */
  toal__obj0(sttd_.Data[0],logd_)
  toal__chkPos(0,sttd_,logd_)
  toal__obj1(sttd_.Data[1],logd_)
  toal__chkPos(1,sttd_,logd_)
  /* overwrite state. */
  #declare sttd_.Access = "w";
  #declare sttd_.Strict = false;
  Filed(sttd_)
  /* log */
  toal__addLog(sttd_,logd_)
  Filed(logd_)
#else  // frame #0.
  #if (!toal__chkFilesExist(false))
    #error "oops, found existing file(s) in frame #0."
  #end
  /* start logging */
  #local logd_.Access = "w";
  #local logd_.Data[0] = concat("toa run @ ",datetime(now));
  /* init two objects.  both face south + colour index '0' */
  #declare state_ = array [2] {
    array mixed [4] {init_pos_[0],2,0,init_seeds_[0]},
    array mixed [4] {init_pos_[1],2,0,init_seeds_[1]}
  };
  /* write state */
  #declare sttd_ = dictionary {
    .Fields  : record_,
    .File    : toal__data_files_[0],
    .Access  : "w",
    .Data    : state_,
    .Verbose : true
  };
  Filed(sttd_)
  /* write log */
  toal__addLog(sttd_,logd_)
  Filed(logd_)
#end

/* render the "arena" grid, place objects "0" and "1" */
#declare tobjs_ = array [2] {
  merge {
    difference {
      cylinder {<0,0,0>,<0,1.25,0>,.30}
      text {ttf "arial.ttf","0",1.5,0 scale <.9,.9,1.5> translate <-.2,.2,-.5>}
    }
    cone {<0,.95,0>,.25,<0,.85,.65>,0 scale <.5,1,1>}
  },
  merge {
    difference {
      cylinder {<0,0,0>,<0,1.25,0>,.30}
      text {
        ttf "arial.ttf","1",1.5,0
        scale <.9,.9,1.5>
        translate <-.125,.2,-.5>
      }
      scale <-1,1,1>
    }
    cone {<0,.95,0>,.25,<0,.85,.65>,0 scale <.5,1,1>}
  }
};

#declare trots_ = array [4] {0,90,180,270};

Ruled(dictionary {
  .norm : <0,1,0>,
  .offs : -.05,
  .divs : 1,
  .bg   : pigment {color rgbt .975},
  .from : <0,0>,
  .to   : area_,
  .dim  : false
})

#for (i_,0,1)
  object {
    tobjs_[i_]
    pigment {color rgb toal__data_colours_[sttd_.Data[i_][2]]}
    rotate <0,trots_[sttd_.Data[i_][1]],0>
    translate <(sttd_.Data[i_][0].x+.5),0,(sttd_.Data[i_][0].y+.5)>
  }
#end

