// flowers_read.pov - Planting red and yellow flowers on an asteroid
// showing the use of reading data from a dictionary file
// +w800 +h600 +am3 +a0.01 +ac0.975 -j +q11

#version 3.8;

global_settings {assumed_gamma 1}

#include "transforms.inc"
#include "rand.inc"
#include "filed.inc"
#include "tabulated.inc"

camera { 
   location  <0, 0, -7> 
   look_at <0, 0, 0> 
   angle 50   
   right x*image_width/image_height
}

//-----------------------------------------------
// Garden Stuff

#declare Target = blob {
  threshold 0.3
  sphere { <0.75, 0, 0>, 1, 1 }
  sphere { <-0.375, 0.64952, 0>, 1, 1 }
  sphere { <-0.375, -0.64952, 0>, 1, 1 }
  scale 1
  rotate 25
  pigment {rgb <0.4, 0.3, 0.1>}
  finish {diffuse 0.7 emission 0.1}
  normal {granite 0.5 scale 0.3}
};

#declare Flower1 = union {
  cylinder {
    <0.0, 0.0, 0.0>, <0.0, 0.01, 0.0>, 0.05
    pigment {rgb <0.5, 0.1, 0>}
    finish {diffuse 0.7 emission 0.1}
    normal {granite 0.2 scale 0.001}
    translate 0.3*y
  }
  cylinder {
    <0.0, 0.0, 0.0>, <0.0, 0.3, 0.0>, 0.01
    pigment {rgb <0.1, 0.5, 0>}
    finish {diffuse 0.7 emission 0.1}
    normal {granite 0.2 scale 0.001}
  }
};

#declare Flower2 = union {
  cylinder {
    <0.0, 0.0, 0.0>, <0.0, 0.01, 0.0>, 0.05
    pigment {rgb <0.5, 0.5, 0>}
    finish {diffuse 0.7 emission 0.1}
    normal {granite 0.2 scale 0.001}
    translate 0.25*y
  }
  cylinder {
    <0.0, 0.0, 0.0>, <0.0, 0.25, 0.0>, 0.01
    pigment {rgb <0.1, 0.5, 0>}
    finish {diffuse 0.7 emission 0.1}
    normal {granite 0.2 scale 0.001}
  }
};

//-----------------------------------------------
// Reading flower data

#declare DR = dictionary {
  .File    : "flowers.txt",
  .Access  : "r",
  .Strict  : false,
  .Fields  : array [5] {"I","V33","V33","V33","S"},
  .hasNames: true,
  .Verbose : true
};

#if (defined(iniUsed))
  #local DR.Range = array [2] {1,(1 + frame_number)};
#end

Filed(DR)

light_group {
  light_source {<15, 25, -25> color 1.0*2}
  union {
    object {Target}
    #for (i_,0,dimension_size(DR.Data,1)-1)
      #if ("R" = substr(DR.Data[i_][4],1,1))
        object {
          Flower1
          Reorient_Trans(y,DR.Data[i_][3])
          translate DR.Data[i_][2]
        }
      #elseif ("Y" = substr(DR.Data[i_][4],1,1))
        object {
          Flower2
          Reorient_Trans(y,DR.Data[i_][3])
          translate DR.Data[i_][2]
        }
      #else
        #debug concat("blue flowers.","\n")
      #end
    #end
//  rotate (-x-y+2*z)*clock*360
    rotate -y*clock*360
  }
}

// Tabulating dictionary:
#undef DR.Names
#undef DR.Data
#local DR.Range = array [2] {391,410};
Filed(DR)

#declare DT = dictionary {
  .DataColumns : DR.Fields,
  .DataTable   : DR.Data,
  .ColLabels   : DR.Names,
  .Emissive    : false,
  .Verbose     : true
};

object {
  Tabulated(DT)
  scale 0.3
  translate <-5.35, 4.0, 5>
}


