// ex2.pov - three columns 2D array.
// +w800 +h600 +am3 +a0.01 +ac0.975 -j +q11

#version 3.8;

global_settings {assumed_gamma 1}

/* magic square means same sum for all rows, columns, and diagonals.
 */
#macro m_isMagic(a_)
  #local s1_ = a_[0][0] + a_[0][1] + a_[0][2]; 
  #local s2_ = a_[1][0] + a_[1][1] + a_[1][2]; 
  #local s3_ = a_[2][0] + a_[2][1] + a_[2][2]; 
  #local s4_ = a_[0][0] + a_[1][0] + a_[2][0]; 
  #local s5_ = a_[0][1] + a_[1][1] + a_[2][1]; 
  #local s6_ = a_[0][2] + a_[1][2] + a_[2][2]; 
  #local s7_ = a_[0][0] + a_[1][1] + a_[2][2]; 
  #local s8_ = a_[0][2] + a_[1][1] + a_[2][0]; 
  (s1_ = s2_ & s1_ = s3_ & s1_ = s4_ & s1_ = s5_
      & s1_ = s6_ & s1_ = s7_ & s1_ = s8_)
#end

/* you can select a file (from ten) at run-time, the example data files
 * contain various 3x3 magic squares.  files 'ex27' to 'ex29' can (should?)
 * be created by you, to test sets of nine small integers (1,..,99) without
 * editing any code.
 */
#include "filed.inc"

#ifndef (N)
  #declare N = 0;
#elseif (!fild__isInt(N) | 0 > N | 9 < N)
  #error "oops, range for integer N is '0,..,9'."
#end

#declare file_ = concat("ex2",str(N,0,0),".txt");

#if (!file_exists(file_))
  #error concat("oops, file '",file_,"' not found.")
#end

/* after reading the data, both array (#rows) and content are checked to
 * ensure .. magicness.  :-)  again, 'record_' is re-used throughout.
 */
#declare record_ = array [3] {"I","I","I"};

#declare DR = dictionary {
  .File    : file_,
  .Access  : "read",
  .Fields  : record_,
  .Verbose : true
};

Filed(DR)

#if (3 != dimension_size(DR.Data,1))
  #error concat("oops, wrong #rows in file '",file_,"'.")
#end

#if (m_isMagic(DR.Data))
  #declare sum_ = DR.Data[0][0] + DR.Data[1][1] + DR.Data[2][2];
#else
  #error concat("oops, square in '",file_,"' is not magic.")
#end

/* if you do have 'tabulated.inc' installed, edit the '#if' guard
 * to true to see a small table rendered, otherwise, sorry to say,
 * it is just "boring" text-only output.
 */

#if (0)

  #include "tabulated.inc"

  #declare DT = dictionary {
    .DataColumns : record_,
    .DataTable   : DR.Data,
    .Emissive    : true,
    .Caption     : array mixed [3] {str(sum_,0,0),0,false},
    .Verbose     : true
  };

  object {
    Tabulated(DT)
    scale .5
    translate <-1.5,1.75,0>
  }

  camera {
    location <0,0,-5>
    right x * (4/3)
    up y
    look_at <0,0,0>
  }

#else

  box {0,1}  /* dummy object suppresses warning */

  #declare r_ = "+----+----+----+\n";
  #declare s_ = r_;
  #for (j_,0,2)
    #declare s_ = concat(s_,"|");
    #for (i_,0,2)
      #declare s_ = concat(s_," ",str(DR.Data[j_][i_],2,0)," |");
    #end
    #declare s_ = concat(s_,"\n",r_);
  #end

  #debug concat(s_,"sum := ",str(sum_,0,0),"\n")

#end

/* edit the '#if' for this section to true to enable writing of the data
 * read, that is, to allow a test comparing the data files.
 * remember to adjust the working directory, if used.
 */

#if (0)

//#declare fild_workingDir = "/tmp/";

  #declare DW = dictionary {
    .File    : concat("new_",file_),
    .Access  : "write",
    .Fields  : record_,
    .Data    : DR.Data,
    .Verbose : true
  };

  Filed(DW)

#end

