// view_verdana_ttf.pov
// generated 03.07.2021 0038h, by 'mkfntview.sh'.
// +w600 +h800 +a0.1

#version 3.8;

global_settings {assumed_gamma 1}

light_source {<-1,1,-1> * 1e3 color srgb 1 parallel}
light_source {<1,1,-1> * 1e3 color srgb 1 parallel}

camera {
  location <2.5,1,-15.25>
  right x * (3/4)
  up y
  angle 60
  look_at <2.5,1,0>
}

#declare fonts_ = array [3] {"timrom.ttf","verdana.ttf","timrom.ttf"};

#include "tabulated.inc"

/* many fonts have 4 * 256 glyphs, or more.
 * use page to select from (first) four.
 */
#ifndef (global.page)
  #declare pg_ = 0;
#elseif (0 > page | 3 < page | page != int(page))
  #error "oops, 'page' must be integer in range 0,..,3."
#else
  #declare pg_ = page;
#end

#declare n_    = 16;
#declare offs_ = n_ * n_ * pg_;
#declare cs_   = concat("font: ", fonts_[1],
        "  (",str(offs_,0,0),",..,",str(255 + offs_,0,0),")");

/* make the various arrays.
 * '.DataColumns', '.ColAlign', '.ColLabels', '.RowLabels',
 * and '.DataTable'.
 * when 'pg_ = 0' overwrite asc(0) with space.
 */
#declare dddc_ = array [n_];
#declare ddca_ = array [n_];
#declare clbl_ = array [n_];
#declare rlbl_ = array [n_];
#declare data_ = array [n_][n_];
#for (i_, 0, n_-1)
  #local dddc_[i_] = "S";
  #local ddca_[i_] = 0;
  #local clbl_[i_] = str(i_,0,0);
  #local rlbl_[i_] = str(offs_ + n_ * i_,0,0);
  #for (j_, 0, n_-1)
    #local data_[i_][j_] = chr(offs_ + n_ * i_ + j_);
  #end
#end
#if (!offs_)
  #local data_[0][0] = chr(32);
#end

#declare dict_glyphs_ = dictionary {
  .DataColumns: dddc_,
  .DataTable  : data_,
  .ColAlign   : ddca_,
  .ColLabels  : clbl_,
  .RowLabels  : rlbl_,
  .Fonts      : fonts_,
  .Lines      : array [2] {.025,0},
  .Fg         : array [3] {3,6,0},
  .Bg         : array [3] {
                  pigment {color rgb .1},
                  pigment {color rgb .2},
                  pigment {color rgb .2}
                },
  .Caption    : array mixed [4] {cs_,0,true,3}
};
object {Tabulated(dict_glyphs_) scale .5 translate <-4.80,10,0>}

/* the "sampler" */
#declare dict_phrase_ = dictionary {
  .DataColumns: array [1] {"S"},
  .DataTable  : array [3]
          {"The quick brown fox","jumped","over the lazy dog."},
  .ColAlign   : array [1] {0},
  .Padding    : <.4, .3>,
  .Fonts      : fonts_,
  .Fg         : array [3] {3,6,0},
  .Bg         : array [3] {
                  pigment {color rgb .1},
                  pigment {color rgb .2},
                  pigment {color rgb .2}
                },
  .Borders    : off
};
object {Tabulated(dict_phrase_) scale .75 translate <-1.5,-4.5,0>}

