// example 2, collection with bg image.
// +w800 +h500 +a0.1

#version 3.8;

global_settings {assumed_gamma 1}

light_source {<1,1,-1> * 1e3 colour srgb 1 parallel}
light_source {<-1,1,-1> * 1e3 colour srgb 1 parallel}

camera {
  location <0,2.5,-5>
  right x * (16/10)
  up y
  angle 70
  look_at <0,2.5,0>
}

#include "tabulated.inc"

/* round dims for "nicer looking" numbers */
#macro m_sz(obj_)
  #local v_ = (max_extent(obj_) - min_extent(obj_));
  <tabu__roundup(v_.x),tabu__roundup(v_.y),tabu__roundup(v_.z)>
#end

/* the object collection.
 * data_ {file size, obj dims, #vertices, inside_vector, normals}
 */
#declare objid_ = array [4] {
  "space_shuttle2_mesh", "space_station2_mesh", "tie2_mesh", "x_wing2_mesh"
};

#for (i_,0,dimension_size(objid_,1)-1)
  #include concat(objid_[i_],".inc")
#end

#declare data_ = array [4] {
  array mixed [5] {145045,(m_sz(space_shuttle2_mesh)),2376,true,false},
  array mixed [5] {384265,(m_sz(space_station2_mesh)),5749,true,false},
  array mixed [5] {126899,(m_sz(tie2_mesh)),2014,true,false},
  array mixed [5] {207477,(m_sz(x_wing2_mesh)),3099,true,false}
};

#declare clbls_ = array [5] {
  "file size","obj dimensions","vertices","inside","smooth"
};

#declare legend_ = concat("sci-fi object collection #2  ",
        "(object dims rounded up)");

#declare D = dictionary {
  .DataColumns: array [5] {"I","V33","I","B","B"},
  .DataTable  : data_,
//.ColLabels  : clbls_,
//.RowLabels  : objid_,
//.Caption    : array mixed [4] {legend_,-1,false,6},
//.ColWidths  : array [5] {5,15,5,5,5},
//.Lines      : array [2] {.025,6},
//.Fg         : array [3] {6,0,0},
//.Bg         : array [3] {
//                pigment {color srgbt .810},
//                pigment {color srgbt .975},
//                pigment {color srgbt .920}
//              },
//.Ledger     : yes
};
object {
  Tabulated(D)
  scale .15
//translate <-3.25,1.75,0>
  translate <-2.50,1.75,0>
}

plane {
  z, 5
  pigment {image_map {png "ex2bg.png" once}}
  scale <20,15,1>
  translate <-10,-5,0>
}

object {
  space_shuttle2_mesh
  no_shadow
  rotate <255,45,345>
  scale .015
  translate <-.95,2,0>
}

object {
  space_station2_mesh
  no_shadow
  rotate <270,300,0>
  scale .1
  translate <-.4,3.3,0>
}

object {
  tie2_mesh
  no_shadow
  rotate <270,345,0>
  scale .01
  translate <.9,2.5,0>
}

object {
  x_wing2_mesh
  no_shadow
  rotate <280,210,45>
  scale .05
  translate <2.25,3.5,0>
}

