// example 3, random triangle.
// +w800 +h500 +a0.1

#version 3.8;

global_settings {assumed_gamma 1}

light_source {<1,1,-1> * 1e3 colour srgb 1 parallel}
light_source {<-1,1,-1> * 1e3 colour srgb 1 parallel}

camera {
  location <-.20,.5,-5>
  right x * (16/10)
  up y
  angle 35
  look_at <-.20,.5,0>
}

#if (!defined(global.Seed))
  #declare seed_ = (now-int(now))*(1e9+1);
#elseif (Seed != int(Seed) | 0 > Seed)
  #error "oops, expected positive integer 'Seed' value."
#else
  #declare seed_ = Seed;
#end

#include "tabulated.inc"

/* the "wireframe" box */
#declare corners_ = array [8] {
  <0,0,0>, <1,0,0>, <0,1,0>, <1,1,0>,
  <0,0,1>, <1,0,1>, <0,1,1>, <1,1,1>
};

#declare r_ = .0025;

union {
  cylinder {corners_[0], corners_[1], r_}
  cylinder {corners_[0], corners_[2], r_}
  cylinder {corners_[0], corners_[4], r_}
  cylinder {corners_[3], corners_[1], r_}
  cylinder {corners_[3], corners_[2], r_}
  cylinder {corners_[4], corners_[5], r_}
  cylinder {corners_[4], corners_[6], r_}
  cylinder {corners_[5], corners_[1], r_}
  cylinder {corners_[6], corners_[7], r_}
  cylinder {corners_[6], corners_[2], r_}
  cylinder {corners_[7], corners_[3], r_}
  cylinder {corners_[7], corners_[5], r_}
  #for (i_,0,7) sphere {corners_[i_], r_} #end
  texture {
    pigment {color rgb <1,0,0>}
    finish {ambient .1 specular .8}
  }
}

/* random points/corners, round for "tidy" look */
#declare rng_ = seed(seed_);

#declare pts_ = array [3];

#declare pts_[0] = <tabu__roundup(rand(rng_)),
                    tabu__roundup(rand(rng_)),
                    tabu__roundup(rand(rng_))>;
#declare pts_[1] = <tabu__roundup(rand(rng_)),
                    tabu__roundup(rand(rng_)),
                    tabu__roundup(rand(rng_))>;
#declare pts_[2] = <tabu__roundup(rand(rng_)),
                    tabu__roundup(rand(rng_)),
                    tabu__roundup(rand(rng_))>;

triangle {
  pts_[0], pts_[1], pts_[2]
  texture {
    pigment {color rgb <1,0,1>}
    normal {dents .05}
    finish {ambient .1 diffuse .5 specular .2}
  }
}

/* display corners + seed */
#declare table_ = dictionary {
  .DataColumns: array [1] {"V34"},
  .DataTable  : pts_,
//.ColLabels  : array [1] {"triangle points"},
//.Caption    : array mixed [4]
//        {concat("random seed(",str(seed_,0,0),")"), 0, false,7},
//.Lines      : array [2] {.02,7},
//.Fg         : array [3] {7,7,0},
//.Bg         : array [3] {
//        pigment {color rgbt .65},
//        pigment {checker color rgbt .3, color rgbt .6 scale .125},
//        pigment {checker color rgbt .3, color rgbt .6 scale .125}
//              },
  .Verbose    : on
};
object {
  Tabulated(table_)
  scale .125
  translate <-1.60,0.85,0>
}

