/* example 1, superellipsoids */
// +w480 +h640 +a0.1

#version 3.8;

global_settings {assumed_gamma 1}

light_source {<1,1,-1> * 1e3 colour srgb 1 parallel}
light_source {<-1,1,-1> * 1e3 colour srgb 1 parallel}

camera {
  location <0,2.5,-5>
  right x * (3/4)
  up y
  angle 60
  look_at <0,2.5,0>
}

/* object colours */
#declare cv_ = array [6] {
  <0,0,1>, <0,1,0>, <0,1,1>, <1,0,0>, <1,0,1>, <1,1,0>
};
#declare cn_ = array [6] {
  "blue", "green", "cyan", "red", "magenta", "yellow"
};

/* "Value_E" + "Value_N" */
#declare en_ = array [6][2] {
  {.50,.16}, {.50,.32}, {.50,.48}, {.50,.64}, {.50,.80}, {.50,.96}
};

/* the table dimensions change with labels and caption commented out,
 * use a different x offset and scale for display.
 */
#include "tabulated.inc"

#declare D = dictionary {
  .DataColumns: array [2] {"F3", "F3"},
  .DataTable  : en_,
//.ColLabels  : array [2] {"east", "north"},
//.RowLabels  : cn_,
//.Ledger     : yes,
//.Caption    : array mixed [3] {"superellipsoids", 0, false}
};
object {Tabulated(D) scale .325 translate <-2.5,4.4,0>}
//object {Tabulated(D) scale .35 translate <-1.5,4.4,0>}

/* make the superellipsoids.
 * if you do not want to download/install the include,
 * you can write a loop calling the macro; supply the
 * loop counter and a dummy value (as the second,
 * unused argument) as parameters.
 */
#include "foreach.inc"

#macro m_se(i_,elem_)
  superellipsoid {
    <en_[i_][0],en_[i_][1]>
    texture {
      pigment {color rgb cv_[i_]}
      normal {dents .005}
      finish {ambient .1 specular .4}
    }
    rotate y * 90
    scale (1/3)
    translate <1.85,(5.5 - i_ * 1.2),0>
  }
#end
Foreach(cn_, dictionary {.Macro: "m_se"})

