/* fore_demo.pov
 * the code is organised in blocks, each of which can be enabled/disabled
 * separately.  each block demonstrates some aspects/features of 'Forach()'
 * and has comments - in lieu of the "man page", which isn't ready yet.
 * enable one at a time.
 */

#version 3.8;

global_settings {assumed_gamma 1}


#include "foreach.inc"

//#declare fore_debug = on;

/* -------------------------------------------------------------------------- *
 * 'Boolean' + 'Strict'.
 * by default 'Foreach()' expects your macro to return nothing ('void').
 * the 'Boolean' flag indicates that the macro does return a 
 * true/false (ie non-zero/zero) status value.  unless the 'Strict' flag
 * is given, a false return is simply reported[*] and execution continues,
 * with 'Strict' the 'Foreach()' macro terminates.
 * [*] requires 'Verbose' on.
 */
#if (1)
/* avoid 'no objects in scene' warning */
box {0,1}

#declare A = array [2][2][3] {
  {{1, 2, 3}, {4, 5, 6}}, {{7, 8, 9}, {10, 11, 12}}
};

#macro m_void(i_, elem_)
  #local n_ = elem_ * elem_;
  #debug concat("m_void i = ",str(i_,0,0),", elem = ",str(elem_,0,0),
          "  sqr = ",str(n_,0,0),".\n")
#end

#macro m_bool(i_, elem_)
  #local n_ = elem_ * elem_;
  #debug concat("m_bool i = ",str(i_,0,0),", elem = ",str(elem_,0,0),
          "  sqr = ",str(n_,0,0),".\n")
  #if (n_ < 30)
    #local r_ = 0;
  #else
    #local r_ = 1;
  #end
  r_
#end

#declare D1 = dictionary {
  .Macro: "m_void",
  .Walk:  2,
  .Nth:   3
};

Foreach(A, D1)

#debug concat("\n")

#declare D2 = dictionary {
  .Macro:   "m_bool",
  .Boolean: on,
  .Walk:    2,
  .Nth:     3,
  .Verbose: on
};

Foreach(A, D2)

#debug concat("\n")

/* break on false */
#declare D2.Strict = on;
#declare D2.Verbose = off;

Foreach(A, D2)

/* calling a void-type macro with 'bool' flag, or bool-type and no flag,
 * results, predictably, in error(s).  ;-)
 */
//Foreach(A, dictionary {.Macro: "m_void", .Boolean: true})
//Foreach(A, dictionary {.Macro: "m_bool"})

#end


/* -------------------------------------------------------------------------- *
 * walk modes.
 * the primary/first dimension of any given array is always "walked" for each
 * element.  different 'Walk' settings can access additional elements.
 * when 'Walk' is '1' elements of the 'Nth' dimension, too, are visited.
 * for walk set to '2', all elements through all dims, up to and including
 * the 'Nth' are visited.  eg for array 'X[2][2][2][2]', Nth = 3:
 *
 *   Walk = 0       Walk = 1       Walk = 2
 *  ------------   ------------   ------------
 *  [0][0][0][0]   [0][0][0][0]   [0][0][0][0]
 *  [1][0][0][0]   [0][0][1][0]   [0][0][1][0]
 *                 [1][0][0][0]   [0][1][0][0]
 *                 [1][0][1][0]   [0][1][1][0]
 *                                [1][0][0][0]
 *                                [1][0][1][0]
 *                                [1][1][0][0]
 *                                [1][1][1][0]
 */
#if (0)
box {0,1}

#declare A = array [2][2][3] {
  {{1, 2, 3}, {4, 5, 6}}, {{7, 8, 9}, {10, 11, 12}}
};

#macro m_walk(i_, elem_)
  #local n_ = elem_ * elem_;
  #debug concat("m_walk i = ",str(i_,0,0),", elem = ",str(elem_,0,0),
          "  sqr = ",str(n_,0,0),".\n")
#end

#declare D = dictionary {
  .Macro:   "m_walk",
  .Walk:    1,
  .Nth:     3,
  .Verbose: on
};

Foreach(A, D)

#declare D.Walk = 2;

Foreach(A, D)

/* no (additional) walk means dimension is forced to '1' */
//#declare D.Walk = 0;
//Foreach(A, D)

#end


/* -------------------------------------------------------------------------- *
 * 'Extra'.
 * this flag is only permitted when 'Walk' is not zero.  it changes the
 * payload macro's interface from two to three arguments.  the added argument
 * provides the current index of the given Nth dimension.
 *
 *  without 'Extra':  foo(i, elem)
 *     with 'Extra':  foo(i, j, elem)
 */
#if (0)
box {0,1}

#declare A = array [2][2][3] {
  {{1, 2, 3}, {4, 5, 6}}, {{7, 8, 9}, {10, 11, 12}}
};

#macro m_3arg(i_, j_, elem_)
  #local n_ = elem_ * elem_;
  #debug concat("m_3arg i = ",str(i_,0,0),", j = ",str(j_,0,0),
          ", elem = ",str(elem_,0,0),"  sqr = ",str(n_,0,0),".\n")
#end

#declare D = dictionary {
  .Macro:   "m_3arg",
  .Walk:    1,
  .Nth:     3,
  .Extra:   on,
  .Verbose: on
};

Foreach(A, D)

#declare D.Walk = 2;

Foreach(A, D)

/* error if no walk */
//#declare D.Walk = 0;
//Foreach(A, D)

#end


/* -------------------------------------------------------------------------- *
 * a real contrived example.
 */
#if (0)

camera {
  location <4,-1,-5>
  direction z
  right x * (4/3)
  up y
  angle 40
  look_at <1,0,0>
}

background {color rgb .65}

#declare colours_ = array [8] {
  color rgb <0, 0, 0>, color rgb <1, 0, 0>,
  color rgb <0, 1, 0>, color rgb <0, 0, 1>,
  color rgb <1, 1, 0>, color rgb <0, 1, 1>,
  color rgb <1, 0, 1>, color rgb <1, 1, 1>
};

#declare positions_ = array [8] {
  <0, 0, 0>, <1, 0, 0>, <0, 1, 0>, <1, 1, 0>,
  <0, 0, 1>, <1, 0, 1>, <0, 1, 1>, <1, 1, 1>
};

#declare stuff_ = array {
  array mixed {0, 0, "one",   7},
  array mixed {2, 1, "two",   6},
  array mixed {4, 2, "three", 5},
  array mixed {6, 3, "four",  3},
  array mixed {1, 4, "five",  2},
  array mixed {3, 5, "six",   4},
  array mixed {5, 6, "seven", 1},
  array mixed {7, 7, "eight", 0}
};

#macro mkSphere(p_,d_,c_)
  sphere {
    p_, d_
    texture {
      pigment {colours_[c_]}
      finish {ambient 0 emission 1}
    }
  }
#end

#macro bigSphere(i_, elem_)
  mkSphere(positions_[elem_[1]], .25, elem_[0])
#end

#macro littleSphere(i_, elem_)
  #local tp_ = positions_[elem_[1]];
  #local ta_ = array [6];
  #local ta_[0] = <tp_.x - .5, tp_.y, tp_.z>;
  #local ta_[1] = <tp_.x + .5, tp_.y, tp_.z>;
  #local ta_[2] = <tp_.x, tp_.y - .5, tp_.z>;
  #local ta_[3] = <tp_.x, tp_.y + .5, tp_.z>;
  #local ta_[4] = <tp_.x, tp_.y, tp_.z - .5>;
  #local ta_[5] = <tp_.x, tp_.y, tp_.z + .5>;
  #for (i_,0,5)
    mkSphere(ta_[i_], .05, elem_[3])
  #end
#end

#declare D = dictionary {
  .Macro:   "bigSphere",
  .Walk:    1,
  .Verbose: on
};

#declare little_ = dictionary {
  .Macro:   "littleSphere",
  .Walk:    1,
  .Verbose: on
};

Foreach(stuff_, D)

#declare D.Macro = "littleSphere";

Foreach(stuff_, D)

#end

