/* flimg.pov
 * cf FL's "squared background" image.
 */

#version 3.8;

global_settings {assumed_gamma 1}

light_source {<.5,.5,-1>*1e3 color rgb 1 parallel}

camera {
  location <4.5,4,-5>
  right x * (4/3)
  up y
  angle 80
  look_at <0,0,0>
}

merge {
  cylinder {<-4,0,0>, <3,0,0>, .035}
  cylinder {<0,-1,0>, <0,3,0>, .035}
  cylinder {<0,0,-4>, <0,0,3>, .035}
  cone {<3,0,0>, .08, <3.25,0,0>, 0}
  cone {<0,3,0>, .08, <0,3.25,0>, 0}
  cone {<0,0,3>, .08, <0,0,3.25>, 0}
  texture {pigment {checker color rgb <1,.839844,0>, color rgb <1,1,1>}}
}

#include "ruled.inc"

#declare xP = dictionary {
  .norm: <1,0,0>,
  .offs: -3,
  .divs: 4,
  .bg:   pigment {color rgb <.976562,.976562,.820312>},
  .fg:   1,
  .dim:  1,
  .from: <0,-3>,
  .to:   <3,3>
};

#declare yP = dictionary {
  .norm: <0,1,0>,
  .offs: 0,
  .divs: 5,
  .bg:   pigment {color rgb <.9375,.96875,1>},
  .fg:   2,
  .dim:  1,
  .from: <-3,-3>,
  .to:   <3,3>
};

#declare zP = dictionary {
  .norm: <0,0,1>,
  .offs: 3,
  .fg:   3,
  .dim:  1,
  .from: <-3,0>,
  .to:   <3,3>
};

Ruled(xP)
Ruled(yP)
Ruled(zP)

