#include "triangulation.inc"

#macro rascension(eye)
  #local rad = abs(atan2(eye.z,eye.x));
  #if (eye.z < 0.0) #local rad = pi*2 - rad; #end
  #local rad = rad / (pi / 12);
  #local rad = (rad * 360 / 24);
  rad
#end

#macro declination(eye)
  #local _v = <eye.x, 0.0,eye.z>;
  #local dec = degrees(radang2(eye,_v));
  #if (eye.y < 0.0) #local dec = dec * -1; #end
  dec
#end
#macro declinationright()
 #local eye = <cameramatrix[0],cameramatrix[1],cameramatrix[2]>;
  #local _v = <cameramatrix[0], 0.0, cameramatrix[2]>;
  #local dec = degrees(radang2(eye,_v));
  #if (cameramatrix[1] < 0.0) #local dec = dec * -1; #end
  dec
#end   
#macro _rascension()
 rascension(Eye)
#end
#macro _declination()
  declination(Eye)
#end
/*
right=up.eye
eye=right.up
up=eye.right
*/
/*
#declare campos = <0,80,-250>;
#declare cameye = vnormalize(<20,12,0>-campos);
#declare camup = <-1,1,0>;
#declare camright = vnormalize(vcross(camup,cameye));
#declare camup = vnormalize(vcross(cameye,camright));
#declare FontSize = 1.0;
#declare camang = 30;

camera {
  location campos
  right camright
  up camup *(image_height/image_width)
  direction cameye*(image_height/image_width)
  angle camang
} */
//#include "transforms.inc"
#declare FontSize = 1;
#macro label(Text,objv,r,col,top,center,ydeg)

  #local uup = Up;
  #local eye = Eye*;
  #local cp = campos;
  
  #if (Camera = 2)
    #local uup = Up2;
    #local eye = Eye2;
    #local cp = campos2; 
  #end
  
  #local fl = 1/tan(radians(camang/2));
  #local vl = vlength(objv-cp)/(fl*20);
  #if (top) #local pnt = uup*(r*1.05)+objv;
  #else #local pnt = -uup*(vl*FontSize+r)+objv; 
  #end
  #local eye = vnormalize(pnt-cp);

object {                       
  text {
    ttf "Arial.ttf" Text 1 0
    texture {  pigment { rgb col }  finish { ambient 1 diffuse 0 } }
  }                     
  #if (center) translate -x*((strlen(Text)/2) * FontSize / (2*FontSize)) #end
  scale vl*FontSize
 #if (ydeg) rotate y* ydeg #end
  //Matrix_Trans(vnormalize(vcross(camup,eye)),camup,eye,pnt)
  popmatrix(vnormalize(vcross(uup,eye)),uup,eye,pnt)
  no_shadow
}                                  
#end

#macro InfoDisplay(txt,Y)
  #local pnt = rotation(radians(camang/2.04),Up,Eye)*10+campos;
  #local d = 1;
  #local rowh = camang * 0.005;
  label(txt,pnt,rowh * Y,1,1,0,d)
#end

#macro InfoDisplay2(txt,Y)
  #local uup = Up;
  #local eye = Eye*;
  #local cp = campos;
  
  #if (Camera = 2)
    #local uup = Up2;
    #local eye = Eye2;
    #local cp = campos2; 
  #end
  
  #local pnt = rotation(radians(camang/2.04),uup,eye)*10+cp;
  #local d = 1;
  #local rowh = camang * 0.005;
  label(txt,pnt,rowh * Y,1,1,0,d)
#end

/** example heads up
 InfoDisplay2(concat("Frame: ",str(frame,0,0)),2)
 InfoDisplay2(concat("Az ",str(360 - _rascension(),0,2)),1)
 InfoDisplay2(concat("Dec ",str(declination(campos - lastpos),0,2)),0)
 InfoDisplay2(concat("Roll ",str(roll,0,2)),-1)
 InfoDisplay2(concat("Alt ",str(campos.y,0,2)),-2)
 InfoDisplay2(concat("Cam ",str(Camera,0,0)),-3)
 */