/* queues.inc
 *
 * FIFO and LIFO type queues.
 *
 * documentation see 'queues.html'.
 *
 */

#ifndef (queues_include_temp)

#declare queues_include_temp = version;

#version 3.8;

/* ------------------------------------------------------------------------- */
#ifdef (QQ_MAXQUEUE)
#declare qqMaxLen = QQ_MAXQUEUE;
#else
#declare qqMaxLen = 10000;
#end

#macro qqCreate(qlen_,optional strict_)
  #if ((2 > qlen_) | (qqMaxLen < qlen_))
    #error concat("oops, require 2 <= len <= ",str(qqMaxLen,0,0),".\n")
  #end
  #ifndef (local.strict_)
    #local strict_ = 1;
  #elseif (!((1 = strict_) | (0 = strict_)))
    #error concat("oops, require boolean, ie '0' or '1' flag.\n")
  #end
  dictionary {
    .maxLength: qlen_,
    .length: 0,
    .eexit: strict_,
    .arr: array mixed
  }
#end

#macro qqDestroy(q_)
  #for (I_,0,q_.length-1)
    #undef q_.arr[I_]
  #end
  #declare q_.length = 0;
#end

#macro qqGet(q_)
  #if (!(q_.length))
    #if ((q_.eexit))
      #error concat("oops, queue empty.")
    #end
    #local T_ = "";
  #else
    #local T_ = q_.arr[0];
    #for (I_,1,q_.length-1)
      #declare q_.arr[I_-1] = q_.arr[I_];
    #end
    #undef q_.arr[q_.length-1]
    #declare q_.length = q_.length - 1;
  #end
  T_
#end

#macro qqLength(q_) q_.length #end

#macro qqPut(q_,el_)
  #if (q_.maxLength <= (q_.length+1))
    #if ((q_.eexit))
      #error concat("oops, queue full.")
    #end
  #else
    #declare q_.arr[q_.length] = el_;
    #declare q_.length = q_.length + 1;
  #end
#end

/* ------------------------------------------------------------------------- */
#ifdef (QS_MAXSTACK)
#declare qsMaxElem = QS_MAXSTACK;
#else
#declare qsMaxElem = 10000;
#end

#macro qsCreate(ssz_,optional strict_)
  #if ((2 > ssz_) | (qsMaxElem < ssz_))
    #error concat("oops, require 2 <= len <= ",str(qsMaxElem,0,0),".\n")
  #end
  #ifndef (local.strict_)
    #local strict_ = 1;
  #elseif (!((1 = strict_) | (0 = strict_)))
    #error concat("oops, require boolean, ie '0' or '1' flag.\n")
  #end
  dictionary {
    .maxElems: ssz_,
    .elems: 0,
    .eexit: strict_,
    .arr: array
  }
#end

#macro qsDestroy(s_)
  #for (I_,0,s_.elems-1)
    #undef s_.arr[I_]
  #end
  #declare s_.elems = 0;
#end

#macro qsPop(s_)
  #if (!(s_.elems))
    #if ((s_.eexit))
      #error concat("oops, stack empty.")
    #end
    #local T_ = "";
  #else
    #local T_ = s_.arr[s_.elems-1];
    #undef s_.arr[s_.elems-1]
    #declare s_.elems = s_.elems - 1;
  #end
  T_
#end

#macro qsPush(s_,el_)
  #if (s_.maxElems <= (s_.elems+1))
    #if ((s_.eexit))
      #error concat("oops, stack full.")
    #end
  #else
    #declare s_.arr[s_.elems] = el_;
    #declare s_.elems = s_.elems + 1;
  #end
#end

#macro qsSize(s_) s_.elems #end

#version queues_include_temp;

#end

/* ---------------------------------------------------- *
 *  the content above is covered by the GPLv3+.         *
 *  copyright (c) 2018 jr <creature.eternal@gmail.com>  *
 *  all rights reserved.                                *
 * ---------------------------------------------------- */
