/* notes.pov
 * uses Microsoft 'arial.ttf' and 'webdings.ttf' fonts.
 */

#version 3.8;

global_settings {
  assumed_gamma 1.0
  charset utf8
}

background {srgb .1}

/* unit + width  */
#declare U = 1;
#declare W = 20;

/* X increment per frame */
#declare Xi = U;

/* staves are a union of 5 thin cylinders, parallel, spaced evenly.
 * Y - baseline, R - radius, O - offset, O2 - O/2.
 */
#declare SY = array[3] {5, 9, 13};

#declare SR = .045;
#declare SO = .5;
#declare SO2 = (SO / 2);
#declare SLine = cylinder {<0,0,0>, <W,0,0>, SR hollow no_reflection no_shadow};

#macro mkSMat(ac_)
  material {
    texture {
      pigment {srgbt <1,1,1,1>}
      finish {
        phong      0
        reflection 0
        specular   0
      }
    }
    interior {
      ior 1.1
      media {
        method    3
        intervals 1
        samples   10
        emission  rgb <ac_.red,ac_.green,ac_.blue> * 2
      }
    }
  }
#end

#macro mkStave(ao_, ac_)
  union {
    #for(I_, 0, 4)
      object {SLine mkSMat(ac_) translate <0,ao_+I_*SO,0>}
    #end
  }
#end

/* the hidden object: headphones */
#declare FGH = function {
  pattern {
    object {
      text {
        ttf "webdings.ttf" chr(178) U, 0
        scale 10
        translate <6.5,7,.1>
      }
    }
  }
};

/* two note glyphs from 'arial' font to reveal.
 * {glyph,  stave, pos, x,  size,  colour, dscale}
 */
#declare TTF = "arial.ttf";

#declare NN = 15;
#declare Note = array [NN][7] {
  {9834,  0, 3, 2.1,   1.5,  2, 1},
  {9835,  0, 0, 2.6,   1.5,  0, 1},
  {9834,  0, 5, 3.7,   1.5,  4, 1},
  {9834,  0, 2, 4.2,   1.5,  1, 1},
  {9835,  0, 3, 4.95,  1.5,  3, 1},

  {9834,  1, 3, 3.1,   1.5,  4, 1},
  {9835,  1, 0, 3.6,   1.5,  3, 1},
  {9834,  1, 5, 4.7,   1.5,  2, 1},
  {9834,  1, 2, 5.2,   1.5,  0, 1},
  {9835,  1, 3, 5.95,  1.5,  1, 1},

  {9834,  2, 3, 2.1,   1.5,  0, 1},
  {9835,  2, 0, 2.6,   1.5,  1, 1},
  {9834,  2, 5, 3.7,   1.5,  2, 1},
  {9834,  2, 2, 4.2,   1.5,  3, 1},
  {9835,  2, 3, 4.95,  1.5,  4, 1}
};

// TODO more colours.
#declare CN = 5;
#declare Colour = array [CN] {
  rgb <1,0,0>,
  rgb <0,1,0>,
  rgb <1,1,0>,
  rgb <1,0,1>,
  rgb <0,1,1>
};

#macro mkG(an_, am_)
  text {ttf TTF chr(an_) U, 0 hollow material {am_} no_shadow}
#end

/* visible note materials are the same, except for
 * colour + scale + density.
 */
#macro mkMat(ac_, as_)
  material {
    texture {
      pigment {srgbt <1,1,1,1>}
      finish {
        phong      0
        reflection 0
        specular   0
      }
    }
    interior {
      ior 1.1
      media {
        method    3
        intervals 1
        samples   10
        emission  rgb <ac_.red,ac_.green,ac_.blue> * as_
      }
    }
  }
#end

#macro mkDMat(ac_, as_, ad_)
  material {
    texture {
      pigment {srgbt <1,1,1,1>}
      finish {
        phong      0
        reflection 0
        specular   0
      }
    }
    interior {
      ior 1.1
      media {
        method    3
        intervals 1
        samples   10
        emission  rgb <ac_.red,ac_.green,ac_.blue> * as_
//        emission rgb <1,1,1>
        density   {ad_}
      }
    }
  }
#end

/* for each note displayed create corresponding "reveal" shape in situ,
 * and its function, and a density.
 */
#declare TRS = array [NN];
#declare FGR = array [NN];
#declare TRD = array [NN];

#for (I, 0, NN-1)
  #local X_ = Note[I][3] + Xi * frame_number;
  #declare TRS[I] = text {
    ttf TTF chr(Note[I][0]) U, 0
    no_reflection
    no_shadow
    scale Note[I][4]
    translate <X_, (SY[Note[I][1]] + Note[I][2] * SO2), -.1>
  };
  #declare FGR[I] = function {pattern {object {TRS[I]}}};
  #declare TRD[I] = density {
    user_defined {
      function {FGR[I](x,y,z)},
//    function {0},
      function {FGR[I](x,y,z)},
      function {FGH(x,y,z) * FGR[I](x,y,z)},,
    }
  };
#end

/* orthographic hides thicknesses */
camera {
  orthographic
  location <10,10,-8>
  look_at <10,10,0>
  right x*(image_width/image_height)
  up <0,1,0>
  angle 90
}

mkStave(SY[2], <1,0,0>)
mkStave(SY[1], <1,1,0>)
mkStave(SY[0], <0,1,0>)

#for (I, 0, NN-1)
  object {
    mkG(Note[I][0], mkMat(Colour[Note[I][5]], Note[I][6]))
//    mkG(Note[I][0], mkDMat(Colour[Note[I][5]], Note[I][6], TRD[I]))
    scale Note[I][4]
    translate <Note[I][3]+Xi*frame_number,SY[Note[I][1]]+Note[I][2]*SO2,-.1>
  }
#end

