#!/usr/bin/env tclsh

# rxorincdata.tcl
# read data from urandom + write it formatted for 'rxor.inc', to stdout.

if {$argc} {
  puts stderr [format {%s: oops, unexpected argument(s).} \
          [file rootname [file tail $argv0]]]
  exit 1
} \
else {
  set fp [open /dev/urandom r]
  chan configure $fp -encoding binary
  set raw [read $fp 256]
  close $fp
}

set s ""
for {set i 0} {8 != $i} {incr i} {
  set offs [expr {32 * $i}]
  append s "  " \{
  for {set j 0} {2 != $j} {incr j} {
    for {set k 0} {16 != $k} {incr k} {
      binary scan [string index $raw [expr {$offs + 8 * $j + $k}]] c x
      set x [expr {$x & 0xff}]
      if {15 == $k  &&  1 == $j} {append s [format %d $x]} \
      elseif {15 == $k} {append s [format "%d,\n" $x]} \
      elseif {!($k || $j)} {append s [format "%d," $x]} \
      elseif {!$k} {append s [format "   %d," $x]} \
      else {append s [format "%d," $x]}
    }
  }
  if {7 == $i} {append s \}} else {append s \} ",\n"}
}
puts $s

exit 0

# ---------------------------------------------------- #
#  the content above is covered by the GPLv3+.         #
#  copyright (c) 2018 jr <creature.eternal@gmail.com>  #
#  all rights reserved.                                #
# ---------------------------------------------------- #
