// PoVRay 3.6/3.7 Scene File "composition_guides.inc"
// desc: Composition grids for photographic composition
// author:  B. Gimeno
// date:    March, 2012
// website: http://www.persistencia.org

#include "screen.inc"
#include "math.inc"

#macro Composition_Guides (grid,th,pgmnt)

 #local Y = 1 ;
 #local X = Y*(image_width/image_height) ;
 #local phi = 1.6180339887498948 ;
 #local phi_1 = phi-1 ;
 #local d = X*sind(atand(Y/X))*cosd(atand(Y/X));

 #declare Frame =
   union {
      cylinder {<0,0,0>,<X,0,0>,th}
      cylinder {<X,0,0>,<X,Y,0>,th}
      cylinder {<X,Y,0>,<0,Y,0>,th}
      cylinder {<0,Y,0>,<0,0,0>,th}
      }
// ---
    #macro Box_arc (l,th,trns,mode)
      union {          
           cylinder{<0,0,0>,<l,0,0>,th}
           cylinder{<l,0,0>,<l,l,0>,th}
           cylinder{<l,l,0>,<0,l,0>,th}
           cylinder{<0,l,0>,<0,0,0>,th} 
           #local C = 20 ; #local c_r = 0 ;
           #while (c_r<C)
             sphere {<cosd((90/C)*c_r)*l,sind((90/C)*c_r)*l,0>,th}
             cylinder {<cosd((90/C)*c_r)*l,sind((90/C)*c_r)*l,0>,<cosd((90/C)*(c_r+1))*l,sind((90/C)*(c_r+1))*l,0>,th}
             #local c_r = c_r+1;
           #end                
           #switch (mode)
            #case (2)
             rotate z*-90 translate y*l
            #break
            #case (3)
             rotate z*-180 translate <l,l,0>
            #break
            #case (4)
             rotate z*-270 translate <l,0,0>
            #break
            #end
            translate trns
            }
     #end  // end box_arc
// ---   
 #declare GRID = 
  union {
   #switch (grid)
    #case (1) // thirds
     union
        {
        object {Frame}
        cylinder {<X*(1/3),0,0>,<X*(1/3),Y,0>,th*(2/3) }
        cylinder {<X*(2/3),0,0>,<X*(2/3),Y,0>,th*(2/3) }

        cylinder {<0,Y*(1/3),0>,<X,Y*(1/3),0>,th*(2/3) }
        cylinder {<0,Y*(2/3),0>,<X,Y*(2/3),0>,th*(2/3) }
        }
   #break
   #case (2) // golden thirds
     union
        {
        object {Frame}
        cylinder {<X*(1-phi_1),0,0>,<X*(1-phi_1),Y,0>,th*(2/3) }
        cylinder {<X*phi_1,0,0>,<X*phi_1,Y,0>,th*(2/3) }
        cylinder {<0,Y*(1-phi_1),0>,<X,Y*(1-phi_1),0>,th*(2/3) }
        cylinder {<0,Y*phi_1,0>,<X,Y*phi_1,0>,th*(2/3) }
        }
   #break
   #case (3) // diagonals
     union
        {
        object {Frame}
        cylinder {<0,0,0>,<X,Y,0>,th*(2/3) }
        cylinder {<0,Y,0>,<X,0,0>,th*(2/3) }
        }
   #break
   #case (4) // Humble A triangle 
     union
        {
        object {Frame}
        cylinder {<0,0,0>,<X/2,Y,0>,th*(2/3) }
        cylinder {<X,0,0>,<X/2,Y ,0>,th*(2/3)}
        }
   #break
   #case (5) // golden diagonal A
     union
        {
        object {Frame}
        cylinder {<0,0,0>,<X,Y,0>,th*(2/3) }
        cylinder {<X,0,0>,<X*d,Y*d ,0>,th*(2/3)}
        cylinder {<0,Y,0>,<X*(1-d),Y*(1-d),0>,th*(2/3)}
        }
   #break
   #case (6) // golden diagonal B
     union
        {
        object {Frame}
        cylinder {<0,0,0>,<X,Y,0>,th*(2/3) }
        cylinder {<X,0,0>,<X*d,Y*d ,0>,th*(2/3) }
        cylinder {<0,Y,0>,<X*(1-d),Y*(1-d),0>,th*(2/3) }
        rotate x*180 translate y*Y 
        }
   #break
   #case (7) // Harmonic Triangles A 
     union
        {
        object {Frame}
        cylinder {<0,0,0>,<X,Y,0>,th*(2/3) }
        cylinder {<X,0,0>,<X*phi_1,Y ,0>,th*(2/3)}
        cylinder {<0,Y,0>,<X*(1-phi_1),0,0>,th*(2/3)}
        }
   #break
   #case (8) // Harmonic Triangles B 
     union
        {
        object {Frame}
        cylinder {<0,0,0>,<X,Y,0>,th*(2/3) }
        cylinder {<X,0,0>,<X*phi_1,Y ,0>,th*(2/3)}
        cylinder {<0,Y,0>,<X*(1-phi_1),0,0>,th*(2/3)}
        rotate x*180 translate y*Y
        }
   #break
   #range (9,12) // golden spiral sin pigment_map horizontal
     #switch ((image_width/image_height))
      #range (0,phi)
         object {Frame}
         
         #local level_0 = (1-(X/Y)*(phi_1))*.5 ;
         
         union {       
            Box_arc((X/Y)*phi_1,th*(2/3),<0,level_0,0>,4)
            Box_arc((X/Y)*pow(phi_1,2),th*(2/3),<(X/Y)*phi_1,level_0+((X/Y)*pow(phi_1,3)),0>,1)
            Box_arc((X/Y)*pow(phi_1,3),th*(2/3),<((X/Y)*phi_1)+((X/Y)*pow(phi_1,4)),level_0,0>,2)
            Box_arc((X/Y)*pow(phi_1,4),th*(2/3),<((X/Y)*pow(phi_1,2))+((X/Y)*pow(phi_1,3)),level_0,0>,3)
            Box_arc((X/Y)*pow(phi_1,5),th*(2/3),<((X/Y)*pow(phi_1,2))+((X/Y)*pow(phi_1,3)),level_0+((X/Y)*pow(phi_1,4)),0>,4)
            Box_arc((X/Y)*pow(phi_1,6),th*(2/3),<((X/Y)*pow(phi_1,2))+((X/Y)*pow(phi_1,3))+((X/Y)*pow(phi_1,5)),level_0+((X/Y)*pow(phi_1,4))+((X/Y)*pow(phi_1,7)),0>,1)
            Box_arc((X/Y)*pow(phi_1,7),th*(2/3),<((X/Y)*pow(phi_1,2))+((X/Y)*pow(phi_1,3))+((X/Y)*pow(phi_1,5))+((X/Y)*pow(phi_1,8)),level_0+((X/Y)*pow(phi_1,4)),0>,2)
            Box_arc((X/Y)*pow(phi_1,8),th*(2/3),<((X/Y)*pow(phi_1,2))+((X/Y)*pow(phi_1,3))+((X/Y)*pow(phi_1,5)),level_0+((X/Y)*pow(phi_1,4)),0>,3)
            Box_arc((X/Y)*pow(phi_1,9),th*(2/3),<((X/Y)*pow(phi_1,2))+((X/Y)*pow(phi_1,3))+((X/Y)*pow(phi_1,5)),level_0+((X/Y)*pow(phi_1,4))+((X/Y)*pow(phi_1,8)),0>,4)
               
               #switch (grid)
                 #case (9)
                   // void
                 #break
                 #case (10) 
                  rotate y*180
                  translate x*(X/Y)
                 #break
                 #case (11)
                   rotate x*180
                   translate y*Y
                 #break
                 #case (12)
                  rotate y*180 translate x*(X/Y)
                  rotate x*180 translate y*Y
                 #break
                 #end
                }
      #break
      #range (phi+0.000001,999999999)
         object {Frame}
         
         #local level_0 = ((X/Y)-phi)*.5 ;         
         union {        
            Box_arc(1,th*(2/3),<level_0,0,0>,4)
            Box_arc(phi_1,th*(2/3),<level_0+1,pow(phi_1,2),0>,1)
            Box_arc(pow(phi_1,2),th*(2/3),<level_0+1+(pow(phi_1,3)),0,0>,2)
            Box_arc(pow(phi_1,3),th*(2/3),<level_0+1,0,0>,3)
            Box_arc(pow(phi_1,4),th*(2/3),<level_0+1,pow(phi_1,3),0>,4)
            Box_arc(pow(phi_1,5),th*(2/3),<level_0+1+pow(phi_1,4),pow(phi_1,3)+pow(phi_1,6),0>,1)
            Box_arc(pow(phi_1,6),th*(2/3),<level_0+1+pow(phi_1,4)+pow(phi_1,7),pow(phi_1,3),0>,2)
            Box_arc(pow(phi_1,7),th*(2/3),<level_0+1+pow(phi_1,4),pow(phi_1,3),0>,3)
            Box_arc(pow(phi_1,8),th*(2/3),<level_0+1+pow(phi_1,4),pow(phi_1,3)+pow(phi_1,7),0>,4)
 
                #switch (grid)
                 #case (9)
                   // void
                 #break
                 #case (10) 
                  rotate y*180
                  translate x*(X/Y)
                 #break
                 #case (11)
                   rotate x*180
                   translate y*Y
                 #break
                 #case (12)
                  rotate y*180 translate x*(X/Y)
                  rotate x*180 translate y*Y
                 #break
                 #end
                }
      #break
      #end // switch 9,12
     #break
     #range (13,16)
// abc copia switch 9.12
     #switch ((image_height/image_width))
      #range (0,phi)
         object {Frame}         
         
         #local level_0 = ((X/Y)-phi_1)*.5;         
         
         union {
                Box_arc(phi_1,th*(2/3),<level_0,0,0>,3)
                Box_arc(pow(phi_1,2),th*(2/3),<level_0,phi_1,0>,4)       
                Box_arc(pow(phi_1,3),th*(2/3),<level_0+pow(phi_1,2),phi_1+pow(phi_1,4),0>,1)       
                Box_arc(pow(phi_1,4),th*(2/3),<level_0+pow(phi_1,2)+pow(phi_1,5),phi_1,0>,2)       
                Box_arc(pow(phi_1,5),th*(2/3),<level_0+pow(phi_1,2),phi_1,0>,3)       
                Box_arc(pow(phi_1,6),th*(2/3),<level_0+pow(phi_1,2),phi_1+pow(phi_1,5),0>,4)       
                Box_arc(pow(phi_1,7),th*(2/3),<level_0+pow(phi_1,2)+pow(phi_1,6),phi_1+pow(phi_1,5)+pow(phi_1,8),0>,1)       
                Box_arc(pow(phi_1,8),th*(2/3),<level_0+pow(phi_1,2)+pow(phi_1,6)+pow(phi_1,9),phi_1+pow(phi_1,5),0>,2)       
                Box_arc(pow(phi_1,9),th*(2/3),<level_0+pow(phi_1,2)+pow(phi_1,6),phi_1+pow(phi_1,5),0>,3)       
                #switch (grid)
                 #case (13)
                   // void
                 #break
                 #case (14) 
                  rotate y*180
                  translate x*(X/Y)
                 #break
                 #case (15)
                   rotate x*180
                   translate y*Y
                 #break
                 #case (16)
                  rotate y*180 translate x*(X/Y)
                  rotate x*180 translate y*Y
                 #break
                 #end
                }
      #break
      #range (phi+0.000001,999999999)
         object {Frame}
         
         #local level_0 = 0 ;         
         union {        
             Box_arc((X/Y),th*(2/3),<0,level_0,0>,3)
             Box_arc((X/Y)*pow(phi_1,1),th*(2/3),<0,level_0+(X/Y),0>,4)
             Box_arc((X/Y)*pow(phi_1,2),th*(2/3),<(X/Y)*pow(phi_1,1),level_0+(X/Y)+((X/Y)*pow(phi_1,3)),0>,1)
             Box_arc((X/Y)*pow(phi_1,3),th*(2/3),<(X/Y)*pow(phi_1,1)+((X/Y)*pow(phi_1,4)),level_0+(X/Y),0>,2)
             Box_arc((X/Y)*pow(phi_1,4),th*(2/3),<(X/Y)*pow(phi_1,1),level_0+(X/Y),0>,3)
             Box_arc((X/Y)*pow(phi_1,5),th*(2/3),<(X/Y)*pow(phi_1,1),level_0+(X/Y)+((X/Y)*pow(phi_1,4)),0>,4)
             Box_arc((X/Y)*pow(phi_1,6),th*(2/3),<(X/Y)*pow(phi_1,1)+((X/Y)*pow(phi_1,5)),level_0+(X/Y)+((X/Y)*pow(phi_1,4))+((X/Y)*pow(phi_1,7)),0>,1)     
             Box_arc((X/Y)*pow(phi_1,7),th*(2/3),<(X/Y)*pow(phi_1,1)+((X/Y)*pow(phi_1,5))+((X/Y)*pow(phi_1,8)),level_0+(X/Y)+((X/Y)*pow(phi_1,4)),0>,2)     
             Box_arc((X/Y)*pow(phi_1,8),th*(2/3),<(X/Y)*pow(phi_1,1)+((X/Y)*pow(phi_1,5)),level_0+(X/Y)+((X/Y)*pow(phi_1,4)),0>,3)     
 
                #switch (grid)
                 #case (13)
                   // void
                 #break
                 #case (14) 
                  rotate y*180
                  translate x*(X/Y)
                 #break
                 #case (15)
                   rotate x*180
                   translate y*Y
                 #break
                 #case (16)
                  rotate y*180 translate x*(X/Y)
                  rotate x*180 translate y*Y
                 #break
                 #end
                }
      #break
      #end // switch 13,12

// abc fin copia switch 9.12
     #break

   #break

   #end // end grid switch.
    
      // ...object grid

      texture {
              pigment {pgmnt}
              finish {ambient 1 diffuse 0}
              } 

        } // end union object grid

  Screen_Object (GRID,<.5,.5>,0,true,0)


#end