// PoVRay 3.7 Scene File "composition_guides_demo.pov"
// author: B.Gimeno
// date: March, 2012
// website: http://www.persistencia.org
//--------------------------------------------------------------------------
#version 3.7;
global_settings{ assumed_gamma 1.0 }
#default{ finish{ ambient 0.1 diffuse 0.9 }} 
//--------------------------------------------------------------------------
#include "colors.inc"
#include "textures.inc"
#include "glass.inc"
#include "metals.inc"
#include "golds.inc"
#include "stones.inc"
#include "woods.inc"
#include "shapes.inc"
#include "shapes2.inc"
#include "functions.inc"
#include "math.inc"
#include "transforms.inc"
//--------------------------------------------------------------------------
// sun ----------------------------------------------------------------------
light_source{< 3000,3000,-3000> color White}

// sky ----------------------------------------------------------------------
sky_sphere { pigment { gradient <0,1,0>
                       color_map { [0.00 rgb <0.6,0.7,1.0>]
                                   [0.35 rgb <0.1,0.0,0.8>]
                                   [0.65 rgb <0.1,0.0,0.8>]
                                   [1.00 rgb <0.6,0.7,1.0>] 
                                 } 
                       scale 2         
                     } // end of pigment
           } //end of skysphere
// ground -------------------------------------------------------------------
plane{ <0,1,0>, 0 
       texture{ pigment{ checker color rgb<1,1,1>*1.2 color rgb<0.25,0.15,0.1>*0}
              //normal { bumps 0.75 scale 0.025}
                finish { phong 0.1}
              } // end of texture
     } // end of plane
//---------------------------------------------------------------------------
//---------------------------- objects in scene ----------------------------

#include "composition_guides.inc"

Set_Camera(<2,5,-20>, <-1.7,3.5,0>, 40) // set location, look_at and angle
Set_Camera_Aspect(8,6) // set width in relation to height
Set_Camera_Sky(<0,1,0>) // set the sky vector

Composition_Guides (1,.005,Red)



// ground -------------------------------------------------------------------
plane{ <0,1,0>, 0 
       texture{ pigment{ checker color rgb<1,1,1>*1.2 color rgb<0.25,0.15,0.1>*0}
              //normal { bumps 0.75 scale 0.025}
                finish { phong 0.1}
              } // end of texture
     } // end of plane
//---------------------------------------------------------------------------
//---------------------------- objects in scene ----------------------------
//---------------------------------------------------------------------------

// sample sphere
difference {
sphere { <0,.5,0>, 1.5 }
cylinder {<0,.5,-2>,<0,.5,2>,1}
         texture { Polished_Chrome
                   //pigment{ color Red } // rgb< 1, 0.0, 0.0>}
                   //finish { phong 1 reflection {0.40 metallic 0.5}}
                 } // end of texture 

          scale<1,1,1>  rotate<0,20,0>  translate<.75,1.35,0>  
       }  // end of sphere ----------------------------------- 

