#include "screen.inc"
#include "math.inc"

#macro Composition_Guides (grid,th,pgmnt)

 #local Y = 1 ;
 #local X = Y*(image_width/image_height) ;
 #local phi = 1.6180339887498948 ;
 #local phi_1 = phi-1 ;
 #local alfa = atand(Y/X);
 #local c = X*sind(alfa);
 #local b = c*sind(alfa);
 #local d = c*cosd(alfa);
 #local a = d/tand(alfa);
 #declare Frame =
   union {
      cylinder {<0,0,0>,<X,0,0>,th}
      cylinder {<X,0,0>,<X,Y,0>,th}
      cylinder {<X,Y,0>,<0,Y,0>,th}
      cylinder {<0,Y,0>,<0,0,0>,th}
      }
 #declare GRID = 
  union {
   #switch (grid)
    #case (1) // thirds
     union
        {
        object {Frame}
        cylinder {<X*(1/3),0,0>,<X*(1/3),Y,0>,th*(2/3) }
        cylinder {<X*(2/3),0,0>,<X*(2/3),Y,0>,th*(2/3) }

        cylinder {<0,Y*(1/3),0>,<X,Y*(1/3),0>,th*(2/3) }
        cylinder {<0,Y*(2/3),0>,<X,Y*(2/3),0>,th*(2/3) }
        }
   #break
   #case (2) // golden thirds
     union
        {
        object {Frame}
        cylinder {<X*(1-phi_1),0,0>,<X*(1-phi_1),Y,0>,th*(2/3) }
        cylinder {<X*phi_1,0,0>,<X*phi_1,Y,0>,th*(2/3) }
        cylinder {<0,Y*(1-phi_1),0>,<X,Y*(1-phi_1),0>,th*(2/3) }
        cylinder {<0,Y*phi_1,0>,<X,Y*phi_1,0>,th*(2/3) }
        }
   #break
   #case (3) // diagonals
     union
        {
        object {Frame}
        cylinder {<0,0,0>,<X,Y,0>,th*(2/3) }
        cylinder {<0,Y,0>,<X,0,0>,th*(2/3) }
        }
   #break
   #case (4) // Humble A triangle 
     union
        {
        object {Frame}
        cylinder {<0,0,0>,<X/2,Y,0>,th*(2/3) }
        cylinder {<X,0,0>,<X/2,Y ,0>,th*(2/3)}
        }
   #break
   #case (5) // golden diagonal A
     union
        {
        object {Frame}
        cylinder {<0,0,0>,<X,Y,0>,th*(2/3) }
        cylinder {<X,0,0>,<X*d,Y*d ,0>,th*(2/3)}
        cylinder {<0,Y,0>,<X*(1-d),Y*(1-d),0>,th*(2/3)}
        }
   #break
   #case (6) // golden diagonal B
     union
        {
        object {Frame}
        cylinder {<0,0,0>,<X,Y,0>,th*(2/3) }
        cylinder {<X,0,0>,<X*d,Y*d ,0>,th*(2/3) }
        cylinder {<0,Y,0>,<X*(1-d),Y*(1-d),0>,th*(2/3) }
        rotate x*180 translate y*Y 
        }
   #break
   #case (7) // Harmonic Triangles A 
     union
        {
        object {Frame}
        cylinder {<0,0,0>,<X,Y,0>,th*(2/3) }
        cylinder {<X,0,0>,<X*phi_1,Y ,0>,th*(2/3)}
        cylinder {<0,Y,0>,<X*(1-phi_1),0,0>,th*(2/3)}
        }
   #break
   #case (8) // Harmonic Triangles B 
     union
        {
        object {Frame}
        cylinder {<0,0,0>,<X,Y,0>,th*(2/3) }
        cylinder {<X,0,0>,<X*phi_1,Y ,0>,th*(2/3)}
        cylinder {<0,Y,0>,<X*(1-phi_1),0,0>,th*(2/3)}
        rotate x*180 translate y*Y
        }
   #break
   #case (9) // Golden Spiral A
        box { <0,0,0>,<X,Y,0> 
              texture {
                pigment {
                   image_map {
                        png "golden_spiral.png" once
                        filter 1,1
                        }
                  scale <image_width/image_height,1,1>
                  }
               }
            }
   #break 
   #case (10) // Golden Spiral A flipped vertically
        box { <0,0,0>,<X,Y,0> 
               texture {
                pigment {
                   image_map {
                        png "golden_spiral.png" once
                        filter 1,1
                        }
                  scale <image_width/image_height,1,1>
                  }
               scale <-1,-1,1> translate <X,Y,0>
               }
            }
   #break
   #case (11) // Golden Spiral 
        box { <0,0,0>,<X,Y,0> 
               texture {
                pigment {
                   image_map {
                        png "golden_spiral.png" once
                        filter 1,1
                        }
                  scale <image_width/image_height,1,1>
                  }
               scale <1,-1,1> translate <0,Y,0>
               }
            }
   #break
   #case (12) // Golden Spiral 
        box { <0,0,0>,<X,Y,0> 
               texture {
                pigment {
                   image_map {
                        png "golden_spiral.png" once
                        filter 1,1
                        }
                  scale <image_width/image_height,1,1>
                  }
               scale <-1,1,1> translate <X,0,0>
               }
            }
   #break
   #case (13) // Golden Spiral 
        box { <0,0,0>,<X,Y,0> 
              texture {
                pigment {
                   image_map {
                        png "golden_spiral.png" once
                        filter 1,1
                        }
                  rotate z*90  translate <1,0,0>
                  scale <image_width/image_height,1,1>
                  }
               }
            }
   #break 
   #case (14) // Golden Spiral 
        box { <0,0,0>,<X,Y,0> 
               texture {
                pigment {
                   image_map {
                        png "golden_spiral.png" once
                        filter 1,1
                        }
                  rotate z*90  translate <1,0,0>
                  scale <image_width/image_height,1,1>
                  }
               scale <-1,-1,1> translate <X,Y,0>
               }
            }
   #break
   #case (15) // Golden Spiral 
        box { <0,0,0>,<X,Y,0> 
               texture {
                pigment {
                   image_map {
                        png "golden_spiral.png" once
                        filter 1,1
                        }
                  rotate z*90  translate <1,0,0>
                  scale <image_width/image_height,1,1>
                  }
               scale <1,-1,1> translate <0,Y,0>
               }
            }
   #break
   #case (16) // Golden Spiral
        box { <0,0,0>,<X,Y,0> 
               texture {
                pigment {
                   image_map {
                        png "golden_spiral.png" once
                        filter 1,1
                        }
                  rotate z*90  translate <1,0,0>
                  scale <image_width/image_height,1,1>
                  }
               scale <-1,1,1> translate <X,0,0>
               }
            }
   #break

   #end // end grid switch.
    
      // ...object grid

      texture {
              pigment {pgmnt}
              finish {ambient 1 diffuse 0}
              } 

        }

      Screen_Object (GRID,<.5,.5>,0,true,0)


#end

/* 
Set_Camera(<25,15,-33>, <-5,3,0>, 40) // set location, look_at and angle
Set_Camera_Aspect(13,8) // set width in relation to height
Set_Camera_Sky(<0,1,0.3>) // set the sky vector

Composition_Guides (1 ,.007,Black)

*/