

/*
CREATES A STAR OF RADIUS 1 AT THE ORIGIN IN THE x,y PLANE 
If the star has a 3D height (beveled), the "front" protrudes in the -z direction
=================================================================================

USAGE: 
object{ MakeStar([StarPts],[StarHt],[Taper],[StarDbl]) [Object Modifiers...] } 

=================================================================================

StarPts: The number of points in the star, a whole number 2 or greater

         
StarHt:  The height (distance the center of the star extends in the -z
         direction).  0 (zero) creates a flat 2D Star. Remember that the
         unscaled star has a radius of 1. Values greater than 1 are allowed,
         but will make an object that looks more like a pyramid or a spike
         than a star.
 
Taper:   Value between 0 and 1, Higher values create narrower points.
         (Specifically, it's the proportion of the overall radius of the star
         by which the inner endpoints are drawn in toward the origin.)
         For stars of 5 through 10 points, a special feature has been built in
         such that a Taper of 0 (zero) will result in a "regular" star shape...
         (shaped like a pentacle for 5, "Star of David" for 6, etc. For all
         other numbers of points, a zero Taper is automatically reset to .5.
            
StarDbl: Whether or not to create a "double star" with a beveled height in both
         the -z and +z directions: 0 (zero) is "no", any other value is "yes".
         If the star has a non-zero height and StarDbl=0, a flat "back"
         surface is created in the x,y plane. This value is ignored when
         StarHt=0.            
*/ 

#macro MakeStar(StarPts,StarHt,Taper,StarDbl)



//Filter inappropiate values (NOT 100% fool proof, but helpful).
#local StarPts=int(abs(StarPts));
#if (StarPts<2) #local StarPts=2; #end 
#local StarHt=abs(StarHt);
#local Taper = abs(Taper);
#if (Taper >1)  #local Taper=1;   #end


//Set Taper values when the special zero Taper value is used
#if(Taper=0)
  #if (StarPts<5)  #local Taper=.500; #end
  #if (StarPts=5)  #local Taper=.620; #end
  #if (StarPts=6)  #local Taper=.425; #end
  #if (StarPts=7)  #local Taper=.305; #end
  #if (StarPts=8)  #local Taper=.234; #end
  #if (StarPts=9)  #local Taper=.180; #end
  #if (StarPts=10) #local Taper=.150; #end
  #if (StarPts>10) #local Taper=.500; #end 
#end 


//Count off the points
union{
#local PtNum =0; #while(PtNum<StarPts)

 
//Generate and store values reused for locating endpoints 
#local PPV   = PtNum*pi*2/StarPts;      #local PSV   = pi/StarPts;
#local LrgX  = sin(PPV);                #local LrgY  = cos(PPV);
#local SmlXa = (1-Taper)*sin(PPV+PSV);  #local SmlYa = (1-Taper)*cos(PPV+PSV);
#local SmlXb = (1-Taper)*sin(PPV-PSV);  #local SmlYb = (1-Taper)*cos(PPV-PSV); 

//These two triangles make the "front" of a star point (the whole star if 2D)
triangle {<0,0,-StarHt>,<LrgX,LrgY,0>,<SmlXa,SmlYa,0>}
triangle {<0,0,-StarHt>,<LrgX,LrgY,0>,<SmlXb,SmlYb,0>}

   #if (StarHt != 0)
      #if (StarDbl!= 0)
      //These two triangles make the back side of a "double" 3D star point.
      triangle {<0,0,StarHt>,<LrgX,LrgY,0>,<SmlXa,SmlYa,0>}
      triangle {<0,0,StarHt>,<LrgX,LrgY,0>,<SmlXb,SmlYb,0>}
        
      #else
      //These two triangles make the flat back of a "single" 3D star point.
      triangle {<0,0,0>,<LrgX,LrgY,0>,<SmlXa,SmlYa,0>}
      triangle {<0,0,0>,<LrgX,LrgY,0>,<SmlXb,SmlYb,0>}
      #end
   #end

#local PtNum=PtNum+1;

#end // end point count off
}    // close union
#end // end the macro
