#local UseRandomness = 1;
#local UseLastRandomSeed = 1;
#local RandomSeed = 0;
#local InitializeFile = 0;

#if (UseRandomness & !InitializeFile & file_exists ("Seed.txt"))
   #fopen RandomSeedFile "Seed.txt" read
   #read (RandomSeedFile, RandomSeed)
   #fclose RandomSeedFile
#end //#if

#if (!UseLastRandomSeed & !InitializeFile)
   #local RandomSeed = RandomSeed + 1;
#end //#if

#if (UseRandomness)
   #fopen RandomSeedFile "Seed.txt" write
   #write (RandomSeedFile, RandomSeed)
   #fclose RandomSeedFile
#end //#if

#local Randomizer = seed (RandomSeed);

#local GoodColor = false;
#while (!GoodColor)
   #local C1R = rand (Randomizer);
   #local C1G = rand (Randomizer);
   #local C1B = rand (Randomizer);
   #if (max (C1R, C1G, C1B) = C1R)
      #local GoodColor = true;
   #end //#if
#end //#while
#local GoodColor = false;
#while (!GoodColor)
   #local C2R = rand (Randomizer);
   #local C2G = rand (Randomizer);
   #local C2B = rand (Randomizer);
   #if (max (C2R, C2G, C2B) = C2R)
      #local GoodColor = true;
   #end //#if
#end //#while
#local Color1 = color <C1R, C1G, C1B>;
#local Color2 = color <C2R, C2G, C2B>;
#debug concat ("\n\nRandomSeed: ", str (RandomSeed, 0, 0))
#debug concat ("\n\nColor 1: <", str (C1R, 0, 4), ", ", str (C1G, 0, 4), ", " str (C1B, 0, 4), ">\n")
#debug concat ("\nColor 2: <", str (C2R, 0, 4), ", ", str (C2G, 0, 4), ", " str (C2B, 0, 4), ">\n\n\n")




//+w1366 +h1024
//Use this size for Paula's computer, then crop the edges to 1280 x 1024.

#local UseRadiosity = 0;
#local UsePhotons = 1;
#local UseTextures = 1;
#local UseAreaLight = 1;

global_settings {
   charset utf8
   assumed_gamma 2.2
   max_trace_level 20
   #if (UseRadiosity)
      radiosity {
         count 300
         error_bound .02
         pretrace_start .08
         pretrace_end .004
         recursion_limit 2
         normal on
      } //radiosity
   #end //#if
   #if (UsePhotons)
      photons {
         count 200000
         autostop 0
      } //photons
   #end //#if
} //global_settings

#local CameraX = 0;
#local CameraY = 11;
#local CameraZ = -26;

camera {
   location <CameraX, CameraY, CameraZ>
   direction <0, 0, 4/3>
   angle 40
   look_at <CameraX, 5, 0>
} //camera

#include "colors.inc"
#include "metals.inc"

light_source {
   <0, 0, -200>
   color White * 1.6
   #if (UseAreaLight)
      area_light
      <6, 0, 0>, <0, 6, 0>, 6, 6
      circular
      adaptive 1
      jitter
   #end //#if
   rotate 20 * x
   rotate 30 * y
} //light_source

#if (UseTextures)
   #local CaseColor_Base = texture {
      pigment {color Black}
      finish {reflection .12 specular 1 roughness .002}
   } //texture

   #local CaseColor_Highlight = texture {T_Gold_3E}

   #local Glass = texture {
      pigment {color White * .98 filter .95}
      finish {
         ambient .1
         diffuse .1
         reflection .1
         specular .8
         roughness .0003
         phong 1 
         phong_size 400
      } //finish
   } //texture

   #local CapColor = material {texture {Glass} interior {ior 1.5 dispersion 1.1}}

   //Metallic paint texture by Jaime Vives Piqueres
   //The effect can be controlled playing with the specular amount of the first layer and the transmit value on the second.
   #local RMin = .1;
   #local RMax = .33;
   //#local C1 = Blue * .25; #local C2 = Green * .5;
   //#local C1 = Red * .125; #local C2 = Yellow * .5;
   //#local C1 = Blue * .2 + Green * .1; #local C2 = Yellow * .5;
   //#local C1 = Violet * .5; #local C2 = Red;
   //#local C1 = Red * .5; #local C2 = Green;
   //#local C1 = Black; #local C2 = White;
   //#local C1 = color Black; #local C2 = color Red;
   //#local C1 = Blue * .5; #local C2 = Orange;
   //#local C1 = Black; #local C2 = Aquamarine;
   //#local C1 = Black; #local C2 = Blue * .7 + Green * .3;

   #local C1 = color White * .2;
   #local C2 = color rgb <.9663, .3371, .5135>;
   #local LipstickColor1 = texture {
      pigment {color C2}
      finish {specular .1 metallic roughness .1 brilliance 10}
   } //texture
   texture {
      pigment {color C1 transmit .33}
      finish {
         specular .2 roughness .0125
         diffuse 1 - RMax reflection {RMin, RMax} conserve_energy
         irid {.25 thickness pi / 2}
      } //finish
   } //texture

   #local C1 = color Black;
   #local C2 = color rgb <.4212, .1557, .1538>;
   #local LipstickColor2 = texture {
      pigment {color C2}
      finish {specular .7 metallic roughness .1 brilliance 10}
   } //texture
   texture {
      pigment {color C1 transmit .33}
      finish {
         specular .4 roughness .0125
         diffuse 1 - RMax reflection {RMin, RMax} conserve_energy
         irid {.25 thickness pi / 2}
      } //finish
   } //texture

   #local C1 = color Black;
   #local C2 = color <.6448, .0316, .0599>;
   #local LipstickColor3 = texture {
      pigment {color C2}
      finish {specular .5 metallic roughness .1 brilliance 10}
   } //texture
   texture {
      pigment {color C1 transmit .33}
      finish {
         specular .4 roughness .0125
         diffuse 1 - RMax reflection {RMin, RMax} conserve_energy
         irid {.25 thickness pi / 2}
      } //finish
   } //texture

   #local BackgroundColor = texture {
      #local Color1 = color <1, .98, .84> * .9;
      #local Color2 = NewTan * .6;
      pigment {
         bozo
         turbulence .8
         omega 1.2
         color_map {
            [0 color Color1]
            [.5 color (Color1 + Color2) / 2]
            [1 color Color2]
         } //color_map
      } //pigment
      scale .6
   } //texture

   #local FloorColor = texture {
      BackgroundColor
      finish {reflection {.08, .2}}
   } //texture
#else
   #local CaseColor_Base = texture {pigment {color White * .6}}
   #local CaseColor_Highlight = texture {pigment {color rgb <.9, 1, .95>}}
   #local CapColor = material {texture {pigment {color SeaGreen transmit .8}}}
   #local LipstickColor1 = texture {pigment {color NeonPink}}
   #local LipstickColor2 = texture {pigment {color Red}}
   #local LipstickColor3 = texture {pigment {color DarkOrchid}}
   #local BackgroundColor = texture {pigment {color <1, .98, .84> * .9}}
   #local FloorColor = texture {BackgroundColor}
#end //#if

plane {z, 6 inverse texture {BackgroundColor}}
//plane {z, -600 rotate 10 * y texture {pigment {color <1, .98, .84> * .9}} no_radiosity photons {collect off}}
plane {z, -600 rotate 10 * y texture {pigment {color <1, .98, .84> * .9}} photons {collect off}}
plane {y, -.01 texture {FloorColor}}

#local Lipstick = object {
   #local A = <7.76 / 2, -6>;
   #local B = <7.76 / 2, -5>;
   #local C = <7.76 / 2, 5>;
   #local D = <6.4 / 2, 12>;
   #local E = <0, 20>;
   #local F = <0, 10>;
   lathe {
      cubic_spline
      6
      A B C D E F
      sturm
   } //lathe
   scale .18
   translate 3.7 * y
} //object

#local Lipstick = object {
   intersection {
      object {Lipstick}
      plane {x, 0 inverse rotate -33 * z translate 6.6 * y}
   } //intersection
   translate .3 * y
   photons {collect off}
} //object

//These are variables that should remain the same for all lipstick case types.
#local PlasticThickness = .06;
#local RoundTubeRadius = 1 - PlasticThickness - .04 - .04;
#local Gap = .002;

#include "LipstickCase_Square.inc"

#local Lipstick1 = object {
   union {
      object {LipstickCase_Square}
      object {Lipstick texture {LipstickColor1} rotate -150 * y}
   } //union
} //object

#include "LipstickCase_Round.inc"

#local Lipstick2 = object {
   union {
      object {LipstickCase_Round}
      object {Lipstick texture {LipstickColor2} rotate -50 * y translate 2.1 * y}
   } //union
} //object

#local Lipstick3 = object {
   union {
      object {LipstickCase_Round}
      object {Lipstick texture {LipstickColor3} rotate -80 * y translate 1.8 * y}
   } //union
} //object

object {Lipstick1 rotate 40 * y translate <2, 0, -.5>}
object {Lipstick2 translate <5, 0, 2>}
object {Lipstick3 translate <7, 0, 0>}
object {Cap_Round_Horizontal rotate 200 * y translate <-1, 0, 3>}
object {Cap_Round translate <5.5, 0, -1.5>}
