#macro SquareCase_Basic (R1, BorderWidth)

   #local R1_ = R1;
   #local BorderWidth_ = BorderWidth;

   #local R2 = .2; //Corner radius, not yes used...

   #local SquareCase_ = object {
      intersection {
         cylinder {<0, 0, 0> <0, 1, 0>, R1_ translate (R1_ - 1 + BorderWidth_) * z}
         cylinder {<0, -.1, 0> <0, 1.1, 0>, R1_ translate (-R1_ + 1 - BorderWidth_) * z}
         cylinder {<0, -.2, 0> <0, 1.2, 0>, R1_ translate (R1_ - 1 + BorderWidth_) * x}
         cylinder {<0, -.3, 0> <0, 1.3, 0>, R1_ translate (-R1_ + 1 - BorderWidth_) * x}
      } //intersection
      bounded_by {box {<-1.1, -.1, -1.1> <1.1, 1.1, 1.1>}}
   } //object

   object {SquareCase_}

#end //#macro SquareCase_Basic

#local RoundnessFactor = 6;
#local BaseBottomHeight = 3.44;
#local BaseMiddleHeight = .4;
#local BaseTopHeight = .2;
#local RoundTubeHeight = 1.92;
#local CapHeight = BaseBottomHeight;

#local Paula = object {
   intersection {
      text {ttf "English.ttf" "Paula" 1, 0 scale <.7, .7, 1> rotate 20 * z translate <-.71, 0, -1.1>}
      cylinder {<0, -1, 0> <0, 2, 0>, RoundnessFactor translate (RoundnessFactor - 1) * z}
   } //intersection
   texture {CaseColor_Highlight}
} //object

#local Base = object {
   union {
      object {SquareCase_Basic (RoundnessFactor, 0) scale <1, BaseBottomHeight, 1> texture {CaseColor_Base}}
      object {SquareCase_Basic (RoundnessFactor, 0) scale <1, BaseMiddleHeight, 1> translate BaseBottomHeight * y texture {CaseColor_Highlight}}
      object {SquareCase_Basic (RoundnessFactor, PlasticThickness) scale <1, BaseTopHeight, 1> translate (BaseBottomHeight + BaseMiddleHeight) * y texture {CaseColor_Highlight}}
   } //union
} //object

#local Base = object {
   difference {
      object {Base}
      object { //Gap
         difference {
            cylinder {<0, 0, 0>, <0, Gap, 0>, 1.5}
            cylinder {<0, -.1, 0>, <0, .1, 0>, .95}
         } //difference
         translate BaseBottomHeight * y
         texture {pigment {color Black}}
      } //object
      cylinder {<0, .1, 0> <0, BaseBottomHeight + BaseMiddleHeight + BaseTopHeight + .1, 0>, RoundTubeRadius + .04 texture {CaseColor_Highlight}}
      object {Paula translate <0, 1.5, -.1>}
   } //difference
} //object

#local Base = object {
   union {
      object {Base}
      object {Paula translate 1.5 * y}
   } //union
   photons {target reflection on}
} //object

#local RoundTube = object {
   union {
      difference {
         cylinder {<0, .1, 0> <0, BaseBottomHeight + BaseMiddleHeight + BaseTopHeight + RoundTubeHeight, 0>, RoundTubeRadius}
         cylinder {<0, .2, 0> <0, BaseBottomHeight + BaseMiddleHeight + BaseTopHeight + RoundTubeHeight + .1, 0>, RoundTubeRadius - PlasticThickness}
      } //difference
      torus {RoundTubeRadius - PlasticThickness / 2, PlasticThickness / 2 sturm translate (BaseBottomHeight + BaseMiddleHeight + BaseTopHeight + RoundTubeHeight) * y}
   } //union
   texture {CaseColor_Highlight}
   photons {target reflection on}
} //object

#declare Cap_Square = object {
   difference {
      object {SquareCase_Basic (6, 0) scale <1, CapHeight, 1>}
      object {SquareCase_Basic (6, PlasticThickness + Gap) scale <1, CapHeight, 1> translate -PlasticThickness * y}
   } //difference
   material {CapColor}
   photons {target reflection on refraction on collect off}
} //object

#declare LipstickCase_Square = object {
   union {
      object {Base}
      object {RoundTube}
      //object {Lipstick rotate -0 * y}
      object {Cap_Square translate (BaseBottomHeight + BaseMiddleHeight + Gap) * y}
   } //union
} //object
