#local BaseBottomHeight = 2.16;
#local BaseBottomRadius = 1.02;
#local BaseMiddleHeight = 1.04;
#local BaseMiddleRadius = BaseBottomRadius;
#local BaseTopHeight = .72;
#local BaseTopRadius = BaseBottomRadius - .06 - Gap;
#local RoundTubeHeight = 2.56;
#local CapHeight = 3.68;
#local CapRadius = BaseBottomRadius;

#local Base = object {
   union {
      cylinder {<0, 0, 0> <0, BaseBottomHeight, 0>, BaseBottomRadius texture {CaseColor_Base}}
      cylinder {<0, 0, 0> <0, BaseMiddleHeight, 0>, BaseMiddleRadius translate BaseBottomHeight * y texture {CaseColor_Highlight}}
      torus {BaseMiddleRadius - PlasticThickness / 2, PlasticThickness / 2 sturm translate (BaseBottomHeight + BaseMiddleHeight) * y texture {CaseColor_Highlight}}
      cylinder {<0, 0, 0> <0, PlasticThickness / 2, 0> BaseMiddleRadius - PlasticThickness / 2 translate (BaseBottomHeight + BaseMiddleHeight) * y texture {CaseColor_Highlight}}
      cylinder {<0, 0, 0> <0, BaseTopHeight, 0>, BaseTopRadius translate (BaseBottomHeight + BaseMiddleHeight) * y texture {CaseColor_Highlight}}
   } //union
} //object

#local Base = object {
   difference {
      object {Base}
      object { //Gap
         difference {
            cylinder {<0, 0, 0>, <0, Gap, 0>, 1.5}
            cylinder {<0, -.1, 0>, <0, .1, 0>, .95}
         } //difference
         translate BaseBottomHeight * y
         texture {pigment {color Black}}
      } //object
      cylinder {<0, .1, 0> <0, BaseBottomHeight + BaseMiddleHeight + BaseTopHeight + .1, 0>, RoundTubeRadius + .04 texture {CaseColor_Highlight}}
   } //difference
   photons {target reflection on}
} //object

#local RoundTube = object {
   union {
      difference {
         cylinder {<0, .1, 0> <0, BaseBottomHeight + BaseMiddleHeight + BaseTopHeight + RoundTubeHeight, 0>, RoundTubeRadius}
         cylinder {<0, .2, 0> <0, BaseBottomHeight + BaseMiddleHeight + BaseTopHeight + RoundTubeHeight + .1, 0>, RoundTubeRadius - PlasticThickness}
      } //difference
      torus {RoundTubeRadius - PlasticThickness / 2, PlasticThickness / 2 sturm translate (BaseBottomHeight + BaseMiddleHeight + BaseTopHeight + RoundTubeHeight) * y}
   } //union
   texture {CaseColor_Highlight}
   photons {target reflection on}
} //object

#declare Cap_Round = object {
   union {
      difference {
         union {
            cylinder {<0, 0, 0> <0, CapHeight - PlasticThickness / 2, 0>, CapRadius texture {CaseColor_Base}}
            torus {CapRadius - PlasticThickness / 2, PlasticThickness / 2 sturm translate (CapHeight - PlasticThickness / 2) * y texture {CaseColor_Base}}
         } //union
         cylinder {<0, -.1, 0> <0, CapHeight + .1, 0>, CapRadius - PlasticThickness + Gap texture {CaseColor_Base}}
      } //difference
      cylinder {<0, -PlasticThickness, 0> <0, 0, 0>, CapRadius - PlasticThickness / 2 translate CapHeight * y material {CapColor}}
   } //union
   photons {target reflection on refraction on}
} //object

#declare Cap_Round_Horizontal = object {Cap_Round rotate 90 * x translate CapRadius * y}

#declare LipstickCase_Round = object {
   union {
      object {Base}
      object {RoundTube}
      //object {Lipstick rotate -0 * y translate 2 * y}
      //object {Cap_Round translate (BaseBottomHeight + BaseMiddleHeight + Gap) * y}
   } //union
} //object