#local UseRadiosity = no;

global_settings {
   charset utf8
   assumed_gamma 2
   max_trace_level 20
   #if (UseRadiosity)
      radiosity {
         pretrace_start .08
         pretrace_end .02
         count 300
         error_bound .06
         recursion_limit 1
      } //radiosity
   #end //#if
} //global_settings

#include "colors.inc"

#local CameraX = 8.14;
#local CameraY = .5;
#local CameraZ = -13;

camera {
   location <CameraX, CameraY, CameraZ>
   look_at <CameraX, CameraY, 0>
} //camera

#if (UseRadiosity)
   #local Dome = object {
      difference {
         sphere {0, 2000}
         sphere {0, 1999}
         box {<-2001, -2001, 1400> <2001, 2001, 2001>}
      } //difference
      pigment {color White * 16}
/*
      #local Brightness = 16;
      pigment {
         radial
         color_map {
            [0 color White * Brightness]
            [.5 color NewTan * .7 * Brightness]
            [.75 color (White + Yellow) / 2 * Brightness]
            [1 color White * Brightness]
         } //color_map
         rotate 90 * x
         rotate 20 * z
      } //pigment
*/
      no_reflection
   } //object
   object {Dome}
#else
   light_source {<20, 10, -200> color White * 1.6 shadowless}
#end //#if

#local MetalColor1 = texture {
   pigment {
      gradient y
      color_map {
         #local Color2 = color White * 255; //Top
         #local Color1 = color rgb <222, 214, 195>; //Bottom
         [0 Color1 / 255]
         [1 color Color2 / 255]
      } //color_map
      scale 5.4
      translate 4 * y
   } //pigment
} //texture

#local MetalColor2 = texture {
   pigment {
      gradient y
      color_map {
         #local Color2 = color rgb <213, 250, 81>; //Top - Green
         #local Color1 = color rgb <93, 104, 53>; //Bottom
         #local Color2 = color rgb <243, 79, 255>; //Top - Purple
         #local Color1 = color rgb <107, 69, 144>; //Bottom
         [0 Color1 / 255 * .2]
         [.4 color (Color1 + Color2) / 510 * .25]
         [1 color Color2 / 255]
      } //color_map
      scale 5
      translate 3.9 * y
   } //pigment
} //texture

#local BkgColor = texture {
   pigment {
      gradient y
      color_map {
         #local Color2 = color NavyBlue * .6; //Top
         #local Color1 = color NavyBlue * .55; //Bottom
         #local Color2 = color SeaGreen * .3; //Top
         #local Color1 = color rgb <119, 185, 192> / 255 * .8; //Bottom
         [0 Color1]
         [1 color Color2]
      } //color_map
      scale 15
      translate 8 * y
   } //pigment
} //texture

/*
#local BkgColor = texture {pigment {color NavyBlue * .6}}
*/

#local Depth = .7;

#local BorderWidth = .1;
#local BorderHeight = .06;

#local CornerRadius = .02;
#local EdgeRadius = CornerRadius;

#local VerticalGap = .02;

#local DeltaTheta = 1;

#include "Dokken.inc"

Create_Logo (BorderWidth, BorderHeight, Depth, CornerRadius, EdgeRadius, VerticalGap, DeltaTheta, MetalColor1, MetalColor2)

object {DOKKEN}

plane {z, Depth + .1 inverse texture {BkgColor}}
