#include "fractals.inc"

global_settings
{
  max_trace_level 10
}

camera
{
  location <-5, 2.5, 2.5>
  //location<0,5,0>
  look_at  <0, 0, 0>
}

light_source
{
  <10, 5, 5>
  rgb 1.5
}

#declare cliff_mat = material
{
  texture
  {
    pigment
    {
      gradient z
      colour_map
      {
        [0   rgbt <1,0,0,1.0>]
        [1/6 rgbt <1,1,0,0.9>]
        [1/3 rgbt <0,1,0,0.8>]
        [1/2 rgbt <0,1,1,0.85>]
        [2/3 rgbt <0,0,1,0.9>]
        [5/6 rgbt <1,0,1,0.95>]
        [1   rgbt <1,0,0,1.0>]
      }
      scale 2
      translate <0,0,1>
    }
    finish { ambient 0.5 }
  }
}

#declare cliff_trans = transform
{
  scale 1
  translate <0, 0, 0>
  rotate <0,0,0>
}

//here's a few examples for each attractor...
clifford (1.6,1.9, 0.5,-1.4, -0.4,-0.1, -1.6,1.8, 1000, 0.0005, 0.00375, cliff_mat, cliff_trans) //scale 1.5
//clifford (-1.6,0.4, 1.3,-0.7, -0.4,-1.9, -1.6,0.5, 1000, 0.0005, 0.005, cliff_mat, cliff_trans)
//clifford (-1.3,1, 1.3,-1.8, -0.3,-0.9, 2,1.8, 200, 0.0001, 0.005, cliff_mat, cliff_trans)
//dejong (-1.6,1, -2,1.8, -0.9,1.8, -1.5,0.3, 300, 0.0005, 0.005, cliff_mat, cliff_trans)
//dejong (1.4,0.8, -1.9,-1.5, 1.8,-1.6, 0.4,1.3, 10, 0.00001, 0.005, cliff_mat, cliff_trans)
//pickover (-1.6,0.4, 1.3,-0.7, -0.4,-1.9, -1.6,0.5, 500, 0.005, 0.0025, cliff_mat, cliff_trans) //scale 2
//pickover (-0.3,-1.3, 0.8,-1.5, 1.1,0.7, -0.5,1.9, 500, 0.005, 0.005, cliff_mat, cliff_trans)
//chaotic1 (0.5,-1.2, -1.8,-0.4, 250, 0.001, 0.005, cliff_mat, cliff_trans)
//chaotic2 (-0.3,-0.9, 1,0.4, -1.6,0.1 200, 0.001, 0.005, cliff_mat, cliff_trans)
