// (C) Copyleft according to the terms of Lesser GNU General Public License (LGPL)
// multicoil2a.inc include file
// Model of multilayer coil (macros)

// Based on toroidcoil.pov developed under leadership of Prof. K. Skala, PhD
// Clean room developed at home.
//
// Started:     2007-03-20
//
// Author:      Mirsad Todorovac <mtodorov@grf.hr>
// DESCRIPTION: macros for multilayer coil

#include "metals.inc"
#include "textures.inc"

#declare debugcoil=0;
#declare develop=1;

// #macro square_multicoil (M, N, a, b, r, d, l, round)
//
// M - number of layers
// N - twists/layer
// a, b - square inner intersection dimensions.
//        coincide with axes of most inner conductors,
//        need d/2 of space at least between iron core & a,b dims
// r    - most inner radius
//        can be zero, must be r <= min (a/2-d/2, b/2-d/2)
// d    - conductor diameter
// l    - distance between twists. usually l = d
// round
//      - whether the outside twists are rounder or
//        orthogonally bent

#macro __square_coil (M, N, a, b, r, d, l, n_first, n_last)
    // frame dimensions a and b are centered to the axes of the wires
    // actual width and height are a+d and b+d
    #local eps1=0; //d*d/(2*(a-2*r))*0.333;
    #local eps2=d*d/(2*(a-2*r))*0.000;
    #local i=0;
    #local not_first=n_first;
    #local not_last =n_last;
    
    #declare a1_x = 0;   #declare a1_y = b;    #declare a1_z = l/4;
    #declare b1_x = a;   #declare b1_y = 0;    #declare b1_z = l/4;
    
    #declare scal_ab = a1_x * b1_x + a1_y * b1_y + a1_z * b1_z;
    #declare abs_a   = sqrt (a1_x*a1_x + a1_y*a1_y + a1_z * a1_z);
    #declare abs_b   = sqrt (b1_x*b1_x + b1_y*b1_y + b1_z * b1_z);
    #declare cosfi   = scal_ab / (abs_a * abs_b);
    #declare fi      = acos (cosfi);
    
    //#debug concat ("a=", str(a, 5,5), ", b=", str(b,5,5), ", |a|=", str(abs_a,5,5), ", |b|=", str(abs_b,5,5), ". cosfi=", str(cosfi,5,5), ", fi=", str(degrees(fi),5,5))
            
    #declare alph = atan2 (l/2, a);
    #declare a_len = sqrt (a * a + (l / 2)* (l / 2));
    
    #declare beta = atan2 (l/4, b);
    #declare sign = l/abs(l);
                             
    #declare dd = d;
  
    //#debug concat ("a=", str(a, 5,5), ", b=", str(b,5,5), ", b-2*r", str(b-2*r,5,5), ", (b-2*r)^2", str((b-2*r)*(b-2*r),5,5), ", r*r=", str(r*r,5,5))
    
    #declare b_len = sqrt ((b - 2*r)*(b - 2*r) - dd * dd);                         
    #declare gamma = atan2(dd, b_len);
    #declare eps3  = d * sin (abs(alph))/2;
    #declare eps4  = d * sin (abs(alph))/2;                            
    union {
      #while (i < N)
       union {
        cylinder { // left wire
  //          <not_first*d, b/2-r+eps1, 0>, <0, -(b/2-r)-eps1, 0>, d/2
            #if (1-not_first)
              <0, b/2-r+eps1, 0>, <0, -(b/2-r)-eps1, 0>, d/2
            #else
              // eps3, eps4 are corrections because tangent is not calculated as a perfect tangent
              <0, -b/2+r-eps3, r*(1-cos(gamma))*sin(alph)>, <0, -b/2+r+eps4+b_len, (r-dd)*(1-cos(gamma))*sin(alph)>, d/2
              translate x*-r
              translate y*(b/2-r)
              rotate z*-degrees(gamma)
              translate y*-(b/2-r)
              translate x*r
            #end
            translate x*-a/2
            //#end
	    #if (debugcoil = 1)
	    #if (not_first) texture { T_Silver_3C } #else
	    pigment { color rgb <1, 0, 0> }
	    #end
	    #end
        }
      union {
         intersection {
            //*PMName intersection rounded corner
            torus {
               r, d/2
            }
            prism {
               d+eps1,
               -(d+eps1),
               5,
               <0, 0>,
               <0, 3*r>,
               #if (not_first)
               <-3*r*cos(gamma), 3*r>,
               <-3*r*cos(gamma), -3*r*sin(gamma)>
               #else
               <-3*r, 3*r>,
               <-3*r, 0>
               #end
               <0, 0>
               pigment { color rgb < 0.5, 0.5, 0.5 > }
            }
            rotate x*90
            translate <-a_len/2+r, -b/2+r, 0>
            #if (debugcoil = 1)
            pigment { color rgb <1, 0.5, 0.5> }
            #end
         }
         cylinder { // lower wire
            <-a_len/2+r-eps1, 0, 0>, <a_len/2-r+eps1, 0, 0>, d/2
            translate y*(-b/2)
            #if (debugcoil = 1)
            pigment { color rgb <0, 1, 0> }
            #end
         }
         intersection {
            //*PMName intersection rounded corner
            torus {
               r, d/2
               rotate x*90
           }
            box {
               <0, 0, (d+eps2)>, <(r+d+eps2), -(r+d+eps2), -d+eps2>
            }
            translate <a_len/2-r, -b/2+r, 0>
            #if (debugcoil = 1)
            pigment { color rgb <0.5, 1, 0.5> }
            #end
         }
         translate x*a_len/2
         rotate y*-degrees(alph)
         translate x*-a/2
        }
        union {
         cylinder { // right wire
            <0, b/2-r+eps1, 0>, <0, -b/2+r-eps1, 0>, d/2
            translate x*a_len/2
            #if (debugcoil = 1)
            pigment { color rgb <0, 0, 1> }
            #end
         }
         intersection {
            //*PMName intersection rounded corner
            torus {
               r, d/2
               rotate x*90
            }
            box {
               <0, 0, (d+eps2)>, <(r+d+eps2), (r+d+eps2), -d+eps2>
            }
            translate <a_len/2-r, +b/2-r, 0>
            #if (debugcoil = 1)
            pigment { color rgb <0.5, 0.5, 1> }
            #end
         }
         cylinder { // upper wire
            <-a_len/2+r-eps1, 0, 0>, <a_len/2-r+eps1, 0, 0>, d/2
            translate y*b/2
            #if (debugcoil = 1)
            pigment { color rgb <0, 1, 1> }
            #end
         }
         intersection {
            //*PMName intersection rounded corner
            torus {
               r, d/2
            }
            prism {
               d+eps1,
               -(d+eps1),
               5,
               <0, 0>,
               <0, -3*r>,
               #if (i = N - 1 & not_last)
               <-3*r*cos(gamma), -3*r>,
               <-3*r*cos(gamma), -3*r*sin(gamma)>
               #else
               <-3*r, -3*r>,
               <-3*r, 0>
               #end
               <0, 0>
               pigment { color rgb < 0.5, 0.5, 0.5 > }
            }
            rotate x*90
            translate <-a_len/2+r, +b/2-r, 0>
            #if (debugcoil = 1)
            pigment { color rgb <0.5, 1, 1> }
            #end
         }
         #local not_first=0;
	 translate x*-a_len/2
	 rotate y*degrees(alph)
	 translate x*a/2
	 translate z*l/2
	} // inner union
	translate z * (i * l - l / 2)
	#if (l < 0)
	   translate z * l
	#end  
       } // mid union
	//sphere { <0, 0, 0>, 0.2 pigment { color rgb <0, 0, 0> } }

      #declare i=i+1;
      #end // while (i < N)

      //texture {
	//   #if (debugcoil & i = 0)
	  //   T_Silver_3C
	  // #else
	  //   T_Copper_3A
	  // #end
      //}
      translate z*(-(l)*N/2)
    } // outer union
#end

#macro square_multicoil (M, N, a, b, r, d, l, round)
      // M - number of layers
      // N - windings per layer
      // a - inner frame width wire axis to wire axis
      // b - inner frame height wire axis to wire axis
      // r - inner r
      // d - thickness of wire
      // l - distance between windings
      // round - sharp (0) or round (1) corners
      // ****************************************************
      // NOTE: SIDE EFFECT! a, b, and r are being modified!!!
      // ****************************************************
      #local not_first=0;
      #local not_last=1;
      #local j=0;
      #local dd=d;
      union {
        #while (j < M)
          //#if (j != 0)
          #if (j = M - 1)
             #declare not_last = 0;
          #end      
          object {
            __square_coil (M, N, a, b, r, d, l, not_first, not_last)
          }
          //#end
          #declare a=a+2*dd;
          #declare b=b+2*dd;
          #declare r=r+round * dd;
          #declare j=j+1;
	  #local not_first=1;
	  #if (j < M)
	    #if (j = M - 1)
	      #declare not_last = 0;
	    #end
            object {
              __square_coil (M, N, a, b, r, d, -l, not_first, not_last)
            }
            #declare a=a+2*dd;
            #declare b=b+2*dd;
            #declare r=r+round * dd;
            #declare j=j+1;
	  #end
        #end // while (j < M)
      } // union
#end // macro (multicoil)

#if (develop = 1)
  #declare not_first=1;
  #declare a=2.5;
  #declare b=2.5;
  #declare r=0.1;
  #declare d=0.15;
  #declare l=1.2;
  #declare round=1;
   
  object {
    //__square_coil (1, 5, 2.5, 2.5, 0.5, 0.2, 1.4, not_first)
    square_multicoil (4, 7, a, b, r, d, l, round)
    texture { T_Copper_3C
      //pigment { color rgb <0.8, 0.8, 0.95> }
    }
  }

  camera {
   angle 25
   location <-15, 15, -15>
   look_at <0, 0, 0>
  }

  light_source {
   <-10.5, 10.5, -10>
   color rgb <1, 1, 0.9>*1.9
  }

  background { color rgb <0.95, 0.95, 0.95> }

#end
