// AdjustPigmentGamma demo scene
// Kyle Johnson, 7-2005

// render with the following switches...
// +W800 +H400 +R3 +A0.1 +J0.5

#default { finish { ambient 0 diffuse 1 } }

global_settings { assumed_gamma 1 } // Note: display_gamma = 2.2

camera {
  right x*image_width/image_height
  location <0, 0, -1>
  look_at <0, 0, 0>
  }

// Macro to adjust APGPig pigment by APGGam gamma value
// Adapted from the CIE_Imagemap macro by Jaime Vives Piqueres
#macro AdjustPigmentGamma(APGPig, APGGam)
  #local APGfn = function { pigment { APGPig } }
  pigment {
    average
    pigment_map {
      [function { pow(APGfn(x,y,z).red, APGGam) }   color_map { [0 rgb 0][1 rgb <3,0,0>] } ]
      [function { pow(APGfn(x,y,z).green, APGGam) } color_map { [0 rgb 0][1 rgb <0,3,0>] } ]
      [function { pow(APGfn(x,y,z).blue, APGGam) }  color_map { [0 rgb 0][1 rgb <0,0,3>] } ]
    }
  }
#end

#declare Display_Gamma = 2.2;

// left image - no gamma adjustment 
light_group {
  light_source { z * -2, rgb 1 }
  box { 0, 1 pigment { image_map { jpeg "colors.jpg" } }
  }
  translate <-1, -1/2, 0>
}  

// right image - with gamma adjustment
light_group {
  light_source { z * -2, rgb 1 }
  box { 0, 1 AdjustPigmentGamma(pigment { image_map { jpeg "colors.jpg" } }, Display_Gamma) }
  translate <0, -1/2, 0>
}

