// main shape :
               
#macro matShape(useNorm)  
  material {
    texture {
      pigment { color rgb .9 }
      finish { 
        specular 0.7 roughness 0.011 brilliance 1.15
        phong 0.1 phong_size 20
      }
      #if (useNorm)
        normal { crackle 1.1 scale 0.10 }
      #end
    }
  }
#end

#macro IsosEvaluateBlock()
  #if (dataAtomFunGrad!=0)
    max_gradient dataAtomFunGrad
    #debug concat( "Isosurface uses max gradient ",str(dataAtomFunGrad,3,3),"\n" )
  #else 
    #declare a=dataAtomFunGrad2.x;  #declare b=dataAtomFunGrad2.y;  #declare c=dataAtomFunGrad2.z; 
    evaluate a,b,c 
    #debug concat( "Isosurface uses evaluate ",str(a,5,5)," ",str(b,5,5)," ",str(c,5,5)," ","\n" )
  #end  
#end
                                                                            
#declare objIsosCointainer=sphere{1e50 1e-10}
#macro IsosCointainer(_rad)  
  contained_by { sphere { 0 _rad } }             
  open
    #debug concat( "Isosurface cointainer radius ",str(_rad,3,3),"\n" )
  #declare objIsosCointainer = sphere { 0 _rad } 
#end               


#if (ObjectShadowTest)
  #declare dataAsFunction=-1;
  union {
    cone { <0,-1,0> .7 <0,1,0> .7 }
    pigment { color rgb .9 }
  }  
#end

#macro PutIsosNormalBlock() 
  #local s=20; #local b=16;
  #if (QQ_NormAsIsos=1)
    - pow(f_bozo(x*s,y*s,z*s),3)*0.02 
  #end
  #if (QQ_NormAsIsos=2)
    - 0.02* pow(f_bozo(x*s,y*s-2134,z*s),3)
    + 0.09* pow(f_bozo(x*b,y*b     ,z*b),9)
  #end  
#end


// ############################################################################
// MAIN SHAPE :
#declare PureMainShape =   
#if (!strcmp(dataShapeModel,"blob"))
  #debug "Using BLOB shape model\n"   
  
  #macro ToSphere(vShape, vDefStr)
    #local r=pow(0.5,1/3);
    #local ret=<r,r,r>*((1-vDefStr) + vShape*vDefStr);
    (ret)
  #end              
  
  
  blob {              
    threshold 0.2   
    //#debug concat(str(antiDef,10,5) ,"\n") 
    sphere {  <0,0,0>  1, 2 scale ToSphere(dataAtomSize, 1-dataAtomAntiDef) translate aiAtomPartW1 }
    sphere {  <0,0,0>  1, 2 scale ToSphere(dataAtomSize, 1-dataAtomAntiDef) translate aiAtomPartW2 }
    sturm
    matShape(1)
  }  

#end // blob model
                                          
                                          
#if (!strcmp(dataShapeModel,"iso-sphere"))
  #debug "Using iso-sphere model\n"
  
  #if (dataAsFunction=0)
    #if (QQ_NormAsIsos=0)    
      DbgQuality("Main shape",1,"sphere + faked normal")
      sphere { 0 1 scale dataAtomSize matShape(1) }
    #else
      DbgQuality("Main shape",2,concat("isosurface sphere + isosurface normal (normal quality = ",str(QQ_NormAsIsos,0,0),")"))
      isosurface {         
        #local sx=dataAtomSize.x;  #local sy=dataAtomSize.y;  #local sz=dataAtomSize.z;
        function { pow(x/sx,2) + pow(y/sy,2) + pow(z/sz,2) - 1 
                   PutIsosNormalBlock()
                 }
        IsosCointainer( max(dataAtomSize.x,dataAtomSize.y,dataAtomSize.z)+0.09  )
        accuracy 1/QQ_Isos_Acc  IsosEvaluateBlock()
        matShape(0)
      }
    #end  
  #end
  #if (dataAsFunction=1)
    #if (QQ_NormAsIsos=0)
      DbgQuality("Main shape",3,"isosurface function real shape + faked normal")
      isosurface {         
        #local sx=dataAtomSize.x;  #local sy=dataAtomSize.y;  #local sz=dataAtomSize.z;
        function { dataAtomFunction(x,y,z) }
        IsosCointainer( dataAtomFunRad + 0.05  )
        accuracy 1/QQ_Isos_Acc  IsosEvaluateBlock()
        matShape(1)
      }   
    #else
      DbgQuality("Main shape",4,concat("isosurface function real shape + isosurface normal (q = ",str(QQ_NormAsIsos,0,0),")"))
      isosurface {         
        #local sx=dataAtomSize.x;  #local sy=dataAtomSize.y;  #local sz=dataAtomSize.z;
        function { dataAtomFunction(x,y,z)
          PutIsosNormalBlock()
        }
        IsosCointainer( dataAtomFunRad + 0.09 )
        accuracy 1/QQ_Isos_Acc  IsosEvaluateBlock()
        matShape(0)
      }   
    #end  
  #end      
#end // iso-sphere model

// ############################################################################  

#if (ShowIsosBounding)
  object {
    objIsosCointainer
    pigment { color rgbf <.97,.77,.77, .5> }
    finish { ambient .3 }
  }
#end                                        


object { 
  PureMainShape      
  rotate y*(dataAtomRotY*3*360)
  translate <0,0.5,0>  
}  

 
 
