#macro ResizeTo(a,b)
  scale <(b.x-a.x), (b.y-a.y), (b.z-a.z)>
  translate a
#end

#local vPovLogoFade=Fade(Clock, 0.50, 3.50, "e3",0,1);
#local vRafLogoFade=Fade(Clock, initial_clock, -0, "!",1,1);
#local vTimeLogoFade=0.45;

#declare ObjLogoPov = union {
  #local fin = finish { ambient 1 diffuse 0 }                           
  union {
    #local e=0.35;
    #local a=<-0.2-e,-0.3-e,0>;  #local b=<3.7+e,1.4+e,0.0001>;
    union {                                      
      text { ttf "povlogo.ttf" "P" 0.001,0      scale 1.15*<1.00,1.10,1.00> rotate z*5 translate -y*0.08 }
      text { ttf "timrom.ttf"  "OVRay" 0.001,0 translate x*0.60 }
      pigment { 
        function{min(1,pow(sqrt(x*x+y*y),4))}
        //function{min(1,pow(max(abs(x),abs(y)),2))}  
        color_map{[0 rgb 1 transmit 0+vPovLogoFade][1 rgb 1 transmit 1]} 
        scale .5 translate <.5,.5,0> ResizeTo(a,b) 
      }
      finish {fin} 
    }  
    box {                            
      a,b
      pigment { 
        function{min(1,pow(sqrt(x*x+y*y),6))}
        //function{min(1,pow(max(abs(x),abs(y)),2))}  
        color_map{[0 rgb 0 transmit 0+vPovLogoFade][1 rgb 0 transmit 1]} 
        scale .5 translate <.5,.5,0> ResizeTo(a,b) 
      }
      finish {fin} translate z*0.01 
    }
    scale Fade(Clock, initial_clock, -0, "!",0.080,0.035)
  }  
}
               

#declare ObjLogoRaf256 = union {
  #local fin = finish { ambient 1 diffuse 0 }                           
  union {
    #local e=0.19;
    #local a=<-0.0-e,-0.3-e,0>;  #local b=<9.0+e,1.4+e,0.0001>;
    union {                                      
      text { ttf "timrom.ttf"  "Rafal \"Raf256\" Maj" 0.001,0 translate x*0.60 }
      pigment { 
        function{0}
        //function{min(1,pow(max(abs(x),abs(y)),2))}  
        color_map{[0 rgb 1 transmit 0+vRafLogoFade][1 rgb 1 transmit 1]} 
        scale .5 translate <.5,.5,0> ResizeTo(a,b)
      }
      finish {fin}
      translate <0,0.2,0> 
    }  
    box {                            
      a,b
      pigment { 
        //function{min(1,pow(sqrt(x*x+y*y),6))}
        function{min(1,pow(max(abs(pow(x,2)),pow(abs(y),2)),5))}  
        color_map{[0 rgb 0 transmit 0+vRafLogoFade][1 rgb 0 transmit 1]} 
        scale .5 translate <.5,.5,0> ResizeTo(a,b) 
      }
      finish {fin} translate z*0.01 
    }         
    scale <1.4,1,1>
    scale 0.05
  }  
}                   

//=============================================================================
#declare ObjLogoTime = union {
  #local fin = finish { ambient 1 diffuse 0 }                           
  union {
    #local e=0.19;
    #local a=<-0.0-e,-0.3-e,0>;  #local b=<2.5+e,1.4+e,0.0001>;
    union {                            
      #if (clock_on)
        #declare clk=(clock/final_clock)*100;
      #else
        #declare clk=100;
      #end  
                
      text { ttf "timrom.ttf"  str( clk ,3,0)  0.001,0 translate x*0.60 }
      pigment { 
        function{0}
        //function{min(1,pow(max(abs(x),abs(y)),2))}  
        color_map{[0 rgb 1 transmit 0+vTimeLogoFade][1 rgb 1 transmit 1]} 
        scale .5 translate <.5,.5,0> ResizeTo(a,b)
      }
      translate <0,0.2,0> 
      finish {fin}
    }  
    box {                            
      a,b
      pigment { 
        //function{min(1,pow(sqrt(x*x+y*y),6))}
        function{min(1,pow(max(abs(pow(x,2)),pow(abs(y),2)),5))}  
        color_map{[0 rgb 0 transmit 0.5+vTimeLogoFade][1 rgb 0 transmit 1]} 
        scale .5 translate <.5,.5,0> ResizeTo(a,b) 
      }
      finish {fin} translate z*0.01 
    }                
    translate <-2.60,0.5,0>     
    scale <1.2,1,1>
    scale 0.08
  }  
}                   

#if (vPovLogoFade<1)
  Screen_Object(ObjLogoPov, <0,1>, 0.01, 1, 0.1)
#end  

#if (vRafLogoFade<1)
  Screen_Object(ObjLogoRaf256,<0.6,0>, 0.01, 1, 0.1)
#end

#if (vTimeLogoFade<1)
  Screen_Object(ObjLogoTime,<0.6,0>, 0.01, 0, 0.1)
#end
