// Persistence of Vision Ray Tracer POV-Ray scene file ".pov"
// POV-Ray 3.8
// Desc: Wavefunction Collapse Toy Release 0.1
// +w600 +h600
/*
    Wave Function Collapse: First Toy Release
    
    Sample file for the Wave Function Collapse system.
    
    

       
*/
//--------------------------------------------------------------------------
#version 3.8;
global_settings{ assumed_gamma 1.0 }
#include "math.inc"
#default{ finish{ ambient 0.1 diffuse 0.9 }} 
//--------------------------------------------------------------------------

camera {
  orthographic
  location <0,0,-1>     // position & direction of view
  look_at  <0,0,0>
  right    x*image_width/image_height*1.05
  up 1.05*y
}

// ----------------------------------------

box {                  // with a quadatic field of view this box fits exactly in view 
  <-0.5, -0.5, 0.01>, <0.5, 0.5, 0.01>
  texture {
    pigment {
      checker color rgb 0.5 color rgb 0.9
      scale 0.1
    }
    finish {
      ambient 0
      diffuse 1
    }
  }
}

//------------------------------------------------------

light_source { <0, 0, -10> 
  color rgb 1 
 // parallel
  //point_at <0, 0, 0>
}

// --------- USER INPUTS
// The Resolution determines the number of cells.
#declare res = <10, 10>;

// Global seed 
// Seed 1643 exposes a bug at 10,10 resolution
#declare WFCSeed = seed(1643);

// MapMin, MapMax are on the XY plane
// they define the target drawing plane for the final map
#declare MapMin = <-0.5, -0.5>;
#declare MapMax = < 0.5, 0.5>;
// (here they map onto the box the orthographic camera stares at

// Pigment Array - Defines A_Pigments
#include "basiccoastpigments.inc"

// Option to draw the tile borders or not
#declare BorderTiles = yes;

// Include before defining the InputTiles object
#include "wfc0.inc" 


// Manually define tils with edges
// Be sure to create enough tiles for the pigments
// Options for CreateTile
// tname - name of tile
// north, east, south, west - edge socket definitions
// pidx - pigment index from A_Pigments (usually imported)
// rot - rotation index (0-3) (always initalize to 0)
#declare InputTiles = array[5]
#declare InputTiles[0] = CreateTile("land", "LL", "LL", "LL", "LL", 0, 0)
#declare InputTiles[1] = CreateTile("water", "WW", "WW", "WW", "WW", 1, 0)
#declare InputTiles[2] = CreateTile("coast", "WL", "LL", "LW", "WW", 2, 0)
#declare InputTiles[3] = CreateTile("land-c", "WW", "WW", "WL", "LW", 3, 0)
#declare InputTiles[4] = CreateTile("water-c", "LL", "LL", "LW", "WL", 4, 0)

// -------- END OF USER INPUTS

// ----- SETUP BOILERPLATE

#declare MaxEntropy = FillTileSet();

CreateGrid() // Creates global Grid and Possibilities objects

// ------ STARTING THE PER-TURN LOGIC
#declare MaxTurns = Ures*Vres;
#declare ThisTurn = 0;
#while(ThisTurn < MaxTurns)
 
  #declare ThisTurn = ThisTurn + 1;
  #declare Entropy = CalculateEntropies()
  #declare LowestScores = GetLowestEntropyTiles()
  CollapseTheObvious()
  
  #ifndef(LowestScores[0])
    CollapseTheObvious()
    #break
  #end

  // snurched from arrays.inc as the macro is generating an error
  #declare CollapsingCell = LowestScores[floor(rand(WFCSeed)*0.99999*dimension_size(LowestScores,1))];

  #declare ChosenOption = ChooseATile(CollapsingCell);
  #declare Grid[CollapsingCell.u][CollapsingCell.v] = ChosenOption;

  CollapseCell(CollapsingCell, ChosenOption)
  CollapseTheObvious()
  
#end // WHILE LOOP

#declare Entropy = CalculateEntropies()
#declare LowestScores = GetLowestEntropyTiles()

// Should be a #render statement but I'm on Windows
#warning concat("Took ", str(ThisTurn,0,0), " turns out of ", str(MaxTurns,0,0), "cells.")

// Draw the thing
DrawEntropies(Grid)
HighlightLowestScores()









